
from imaplib import _Authenticator
from django import forms
from .models import *
from django.contrib.auth.forms import UserCreationForm, UserChangeForm, AuthenticationForm
from django.contrib.auth.models import AbstractUser
from phonenumber_field.formfields import PhoneNumberField
from phonenumber_field.widgets import PhoneNumberPrefixWidget

class CustomAuthenticationForm(AuthenticationForm):
    class Meta:
        model = CustomUser
        fields = ['username', 'password']      

class LibrarianRegistrationForm(UserCreationForm):
    class Meta:
        model = CustomUser
        fields = UserCreationForm.Meta.fields + ('email', 'is_librarian',)

class MemberRegistrationForm(UserCreationForm):
    class Meta:
        model = CustomUser
        fields = UserCreationForm.Meta.fields + ('email',)


class BookForm(forms.ModelForm):
    class Meta:
        model = Book
        fields = '__all__'

class MemberForm(forms.ModelForm):
    phone_number = PhoneNumberField(
        widget=PhoneNumberPrefixWidget(attrs={'class': 'form-control'})
    )

    class Meta:
        model = Member
        fields = '__all__'

class LibrarianForm(forms.ModelForm):
    phone_number = PhoneNumberField(
        widget=PhoneNumberPrefixWidget(attrs={'class': 'form-control'})
    )

    class Meta:
        model = Librarian
        fields = ['name', 'last_name', 'address', 'birth_place', 'date_birth', 'phone_number']

class MemberProfileUpdateForm(forms.ModelForm):
    class Meta:
        model = Member
        fields = ['name', 'email', 'address', 'birth_place', 'date_birth', 'phone_number']

class LibrarianProfileUpdateForm(forms.ModelForm):
    class Meta:
        model = Librarian
        fields = ['name', 'last_name', 'address', 'birth_place', 'date_birth', 'phone_number']


class BookLoanForm(forms.ModelForm):
    book = forms.ModelChoiceField(queryset=Book.objects.all(), label='Book')
    member = forms.ModelChoiceField(queryset=Member.objects.all(), label='Member')

    class Meta:
        model = BookLoan
        fields = ['book', 'member', 'due_date', 'return_date', 'is_returned']

class CategoryForm(forms.ModelForm):
    class Meta:
        model = Category
        fields = ['name']
