# middleware.py
from django.utils.functional import SimpleLazyObject
from .models import CustomUser  # Gantilah dengan model pengguna yang sesuai

def get_user_type(request):
    if hasattr(request, '_cached_user_type'):
        return request._cached_user_type

    user_type = 'member'  # Default ke anggota

    if request.user.is_authenticated:
        user_type = 'librarian' if request.user.is_librarian else 'member'

    request._cached_user_type = user_type
    return user_type

class UserTypeMiddleware:
    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        request.user_type = SimpleLazyObject(lambda: get_user_type(request))
        response = self.get_response(request)
        return response
