from django.urls import path
from django.contrib.auth.views import LogoutView, LoginView
from .views import *
from django.views.generic import *
from django.conf.urls.static import static

urlpatterns = [
    path('', homepage, name='homepage'),
    # path('login/', login_view, name='login'),
    # path('register/', register, name='register'),
    path('login/', Login, name='login'),
    path('logout/', LogoutView.as_view(next_page='homepage'), name='logout'),
    path('dashboard/', dashboard, name='dashboard'),

    path('librarian-registration/', librarian_registration, name='librarian_registration'),
    path('librarians/', librarian_list, name='librarian_list'),
    path('librarians/add/', librarian_new, name='librarian_new'),
    path('librarians/edit/<int:id>/', librarian_update, name='librarian_edit'),
    path('librarians/delete/<int:pk>/', librarian_delete, name='librarian_delete'),

    path('books/', BookList.as_view(), name='book-list'),
    path('books/detail/<int:pk>/', BookDetail.as_view(), name='book-detail'),
    path('books/add/', BookCreateView.as_view(), name='book-new'),
    path('books/edit/<int:pk>/', BookUpdateView.as_view(), name='book-edit'),
    path('books/delete/<int:id>/', book_delete, name='delete_book'),
    path('books/<int:pk>/delete/', BookDeleteView.as_view(), name='book-delete'),

    path('book-loans/', book_loan_list, name='book_loan_list'),
    path('book-loans/add/', book_loan_new, name='book_loan_new'),
    path('book-loans/edit/<int:id>/', book_loan_update, name='book_loan_edit'),
    # path('book-loans/edit/<str:pk>/', book_loan_update, name='book_loan_edit'),
    # path('book-loans/edit/<uuid:pk>/', book_loan_update, name='book_loan_edit'),
    path('book-loans/delete/<int:id>/', book_loan_delete, name='book_loan_delete'),

    path('bookloans/', BookLoanList.as_view(), name='bookloan-list'),


    path('near-outstanding-loans/', near_outstanding_loans, name='near_outstanding_loans'),
    path('overdue-loans/', overdue_loans, name='overdue_loans'),

    path('member-registration/', member_registration, name='member_registration'),
    path('member/', member_list, name='member_list'),
    path('member/add/', member_new, name='member_new'),
    path('member/edit/<int:id>/', edit_member, name='edit_member'),
    path('member/delete/<int:id>', delete_member, name='delete_member'),

    path('librarian-login-history/', librarian_login_history, name='librarian_login_history'),

    path('update-usermember/', update_usermember, name='update-usermember'),
    path('update-userlibrarian/', update_userlibrarian, name='update-userlibrarian'),
    path('updateuser_success/', updateuser_success, name='updateuser_success'),

    path('update-password', userchange_password, name='update-password'),
    path('updatepassword_success/', updateuser_success, name='updatepassword_success'),

    path('categories/', CategoryListView.as_view(), name='category_list'),
    path('category/add/', CategoryCreateView.as_view(), name='category_new'),
    path('category/edit/<int:pk>/', CategoryUpdateView.as_view(), name='category_edit'),

    path('unauthorized/', unauthorized, name='unauthorized'),

]

if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)