from django import forms
from librarians.models import Librarians


class LibrarianForm(forms.ModelForm):
    class Meta:
        model = Librarians
        fields = ["name", "email", "password"]
        widgets = {
            "name": forms.TextInput(
                attrs={
                    "placeholder": "Name",
                    "class": "form-control",
                }
            ),
            "email": forms.EmailInput(
                attrs={
                    "placeholder": "Email",
                    "class": "form-control",
                }
            ),
            "password": forms.PasswordInput(
                attrs={
                    "placeholder": "Password",
                    "class": "form-control",
                }
            ),
        }

    def __init__(self, *args, **kwargs):
        super(LibrarianForm, self).__init__(*args, **kwargs)
        self.fields["password"].required = False
