"""
URL configuration for config project.

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/5.0/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""

from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static
from django.contrib.auth.views import (
    PasswordResetConfirmView,
    PasswordResetCompleteView,
)
from rest_framework_simplejwt.views import (
    TokenRefreshView,
)

from dashboard.views import UpcomingLoanView, OverduedLoanView

urlpatterns = [
    # local
    path("admin/", admin.site.urls),
    path("dashboard/", include("dashboard.urls")),
    path("books/", include("book.urls")),
    path("users/", include("users.urls")),
    path("book-loans/", include("loans.urls")),
    path("upcoming-loans/", UpcomingLoanView.as_view(), name="upcoming_loans"),
    path("overdued-loans/", OverduedLoanView.as_view(), name="overdued_loans"),
    # password reset
    path(
        "password-reset-confirm/<uidb64>/<token>/",
        PasswordResetConfirmView.as_view(
            template_name="password/password_reset_confirm.html"
        ),
        name="password_reset_confirm",
    ),
    path(
        "password-reset-complete/",
        PasswordResetCompleteView.as_view(
            template_name="password/password_reset_complete.html"
        ),
        name="password_reset_complete",
    ),
    # api
    path("api/v1/token/refresh/", TokenRefreshView.as_view(), name="token_refresh"),
    path("api/v1/", include("api.urls"), name="API_V1"),
    # 3rd party
    path("api-auth/", include("rest_framework.urls"), name="api_auth"),
]

if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
