import 'package:bloc/bloc.dart';
import 'package:manager_queue/api.dart';
import 'package:manager_queue/models/queue.dart';

class QueueBloc extends Cubit<List<OrderQueue>> {
  QueueBloc() : super([]);

  Future<List<OrderQueue>> getData() async {
    var apiQueue = await ApiQueue.getQueue();
    return apiQueue.where((i) => (i.status == "In Queue")).toList();
  }

  // QueueBloc() : super(Future.empty);

  void queueList() {
    getData().then((value) {
      // print(value);
      emit(value);
    });
  }

  onPressed(OrderQueue thisQueue) {
    var index = state.indexOf(thisQueue);
    thisQueue.isSelected = !thisQueue.isSelected;
    state[index] = thisQueue;
    // print('berubah');
    emit(state);
  }
}
