import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:manager_queue/models/queue.dart';

import '../api.dart';

part 'ready_state.dart';

class ReadyCubit extends Cubit<ReadyState> {
  ReadyCubit() : super(ReadyInitial());

  Future<void> getData() async {
    emit(ReadyLoading());
    // Future.delayed(const Duration(milliseconds: 2000), () async {
    var apiQueue = await ApiQueue.getQueue();
    var data = apiQueue.where((i) => (i.status == "Ready")).toList();

    emit(ReadyLoaded(data));
    // });
  }

  onPressed(List<OrderQueue> active, OrderQueue toUpdate) {
    emit(ReadyInitial());
    var index = active.indexOf(toUpdate);
    toUpdate.isSelectedReady = !toUpdate.isSelectedReady;
    active[index] = toUpdate;
    emit(ReadyUpdated(active));
  }
}
