import 'dart:async';
import 'dart:convert';
import 'package:http/http.dart' as http;
import 'package:manager_queue/helper/config.dart';
import 'package:manager_queue/models/queue.dart';
import 'package:manager_queue/models/config.dart';

class ApiQueue {
  final String id;
  final String queue_number;
  final String status;

  ApiQueue(this.id, this.queue_number, this.status);

  // factory ApiQueue.createQueue(Map<String, dynamic> json) {
  //   return ApiQueue(json['id'].toString(), json['queue_number'].toString(),
  //       json['status'].toString());
  // }

  static Future<List<OrderQueue>> getQueue() async {
    String apiUrl = apiUrlQueue;
    // print("Test");
    List<OrderQueue> queues = [];
    try {
      Map data = {'': ''};
      var bodyOrderQueue = jsonEncode(data);
      var apiResult = await http.post(Uri.parse(apiUrl), body: bodyOrderQueue);
      var jsonObject = jsonDecode(apiResult.body);
      List<dynamic> listQueue = (jsonObject as Map<dynamic, dynamic>)['data'];

      for (int i = 0; i < listQueue.length; i++) {
        queues.add(OrderQueue.createOrderQueue(listQueue[i]));
      }
      // ignore: empty_catches
    } catch (e) {}

    return queues;
  }

  static Future<List<ConfigApl>> getConfig() async {
    String apiUrl = apiUrlConfig;
    // print("apiUrl dalam getConfig: " + apiUrl);
    List<ConfigApl> configs = [];
    try {
      Map data = {'': ''};
      var bodyConfig = jsonEncode(data);
      var apiResult = await http.post(Uri.parse(apiUrl), body: bodyConfig);
      var jsonObject = jsonDecode(apiResult.body);
      List<dynamic> listConfig = (jsonObject as Map<dynamic, dynamic>)['data'];
      for (int i = 0; i < listConfig.length; i++) {
        configs.add(ConfigApl.createConfig(listConfig[i]));
      }
      // ignore: empty_catches
    } catch (e) {
      print("Errornya pada api.dart config: $e");
    }

    return configs;
  }
}
