import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:manager_queue/models/queue.dart';

import '../api.dart';

part 'queue_state.dart';

class QueueCubit extends Cubit<QueueState> {
  QueueCubit() : super(QueueInitial());

  Future<void> getData() async {
    emit(QueueLoading());
    // Future.delayed(const Duration(milliseconds: 2000), () async {
    var apiQueue = await ApiQueue.getQueue();
    var data = apiQueue.where((i) => (i.status == "In Queue")).toList();

    emit(QueueLoaded(data));
    // });
  }

  onPressed(List<OrderQueue> active, OrderQueue toUpdate) {
    emit(QueueInitial());
    var index = active.indexOf(toUpdate);
    toUpdate.isSelected = !toUpdate.isSelected;
    active[index] = toUpdate;
    emit(QueueUpdated(active));
  }
}
