part of 'queue_cubit.dart';

abstract class QueueState extends Equatable {
  const QueueState();

  @override
  List<Object> get props => [];
}

class QueueInitial extends QueueState {}

class QueueLoading extends QueueState {}

class QueueLoaded extends QueueState {
  final List<OrderQueue> queues;

  QueueLoaded(this.queues);

  @override
  List<Object> get props => [queues];
}

class QueueUpdated extends QueueState {
  final List<OrderQueue> queues;

  QueueUpdated(this.queues);

  @override
  List<Object> get props => [queues];
}
