import 'dart:io';

import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:manager_queue/bloc/queue_bloc.dart';
import 'package:manager_queue/bloc/ready_bloc.dart';
import 'package:manager_queue/cubit/queue_cubit.dart';
import 'package:manager_queue/cubit/ready_cubit.dart';
import 'package:manager_queue/helper/config.dart';

import 'package:manager_queue/main_page.dart';
import 'package:manager_queue/splash.dart';
import 'package:mqtt_client/mqtt_client.dart';
import 'package:shared_preferences/shared_preferences.dart';

import 'bloc/selected_queue_bloc.dart';
import 'bloc/selected_ready_bloc.dart';

late SharedPreferences prefs;
void main() async {
  prefs = await SharedPreferences.getInstance();
  runApp(MyApp());
}

// Future<int> runMqTT(BuildContext context) async {
//   mqClient.logging(on: false);
//   mqClient.setProtocolV311();
//   mqClient.keepAlivePeriod = 86400;
//   mqClient.port = mqttPort;
//   mqClient.onDisconnected;
//   mqClient.onConnected;
//   mqClient.onSubscribed;
//   // mqClient.pongCallback = pong;

//   final connMess = MqttConnectMessage()
//       .withClientIdentifier('Mqtt_MyClientUniqueId')
//       .withWillTopic('willtopic') // If you set this you must set a will message
//       .withWillMessage('My Will message')
//       .startClean() // Non persistent session for testing
//       .withWillQos(MqttQos.atLeastOnce);
//   // print('EXAMPLE::Mosquitto client connecting....');
//   mqClient.connectionMessage = connMess;

//   try {
//     await mqClient.connect();
//   } on NoConnectionException catch (e) {
//     // Raised by the client when connection fails.
//     // print('EXAMPLE::client exception - $e');
//     mqClient.disconnect();
//   } on SocketException catch (e) {
//     // Raised by the socket layer
//     // print('EXAMPLE::socket exception - $e');
//     mqClient.disconnect();
//   }
//   if (mqClient.connectionStatus!.state == MqttConnectionState.connected) {
//     // print('EXAMPLE::Mosquitto client connected');
//   } else {
//     /// Use status here rather than state if you also want the broker return code.
//     // print(
//     //     'EXAMPLE::ERROR Mosquitto client connection failed - disconnecting, status is ${mqClient.connectionStatus}');
//     mqClient.disconnect();
//     exit(-1);
//   }

//   /// Ok, lets try a subscription
//   // print('EXAMPLE::Subscribing to the queuetest/1 topic');
//   var topic = queueTopic; // Not a wildcard topic
//   mqClient.subscribe(topic, MqttQos.atMostOnce);

//   /// The client has a change notifier object(see the Observable class) which we then listen to to get
//   /// notifications of published updates to each subscribed topic.
//   // mqClient.updates!.listen((List<MqttReceivedMessage<MqttMessage?>>? c) {
//   //   final recMess = c![0].payload as MqttPublishMessage;
//   //   final pt =
//   //       MqttPublishPayload.bytesToStringAsString(recMess.payload.message);
//   //   // if (c[0].topic == topic && pt == queueMessage) {
//   //   //   context.read<QueueBloc>().queueList();
//   //   //   // print("berhasil update API");
//   //   // } else {
//   //   //   // print("tidak berhasil dapat message yang sesuai");
//   //   // }

//   //   print('Notifikasi masuk dari topic <${c[0].topic}>, isinya adalah: $pt ');
//   //   print('');
//   // });
//   // print('EXAMPLE::Sleeping....');
//   // await MqttUtilities.asyncSleep(60);

//   // /// Finally, unsubscribe and exit gracefully
//   // print('EXAMPLE::Unsubscribing');
//   // mqClient.unsubscribe(topic);

//   /// Wait for the unsubscribe message from the broker if you wish.
//   // await MqttUtilities.asyncSleep(2);
//   // print('EXAMPLE::Disconnecting');
//   // mqClient.disconnect();
//   return 0;
// }

class MyApp extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    // runMqTT(context);
    // return MaterialApp(
    //   initialRoute: '/',
    //   routes: {
    //     '/': (context) => MultiBlocProvider(providers: [
    //           BlocProvider(create: (_) => QueueBloc()),
    //           BlocProvider(create: (_) => ReadyBloc()),
    //           BlocProvider(create: (_) => SelectedQueueBloc()),
    //           BlocProvider(create: (_) => QueueCubit()),
    //           BlocProvider(create: (_) => SelectedReadyBloc()),
    //           BlocProvider(create: (_) => ReadyCubit()),
    //         ], child: MainPage()),
    //   },
    //   debugShowCheckedModeBanner: false,
    // );
    return MultiBlocProvider(
      providers: [
        BlocProvider(create: (_) => QueueBloc()),
        BlocProvider(create: (_) => ReadyBloc()),
        BlocProvider(create: (_) => SelectedQueueBloc()),
        BlocProvider(create: (_) => QueueCubit()),
        BlocProvider(create: (_) => SelectedReadyBloc()),
        BlocProvider(create: (_) => ReadyCubit()),
        // BlocProvider(create: (_) => StylingBloc()),
      ],
      child: Builder(builder: (BuildContext context) {
        return MaterialApp(
          debugShowCheckedModeBanner: false,
          // theme: ThemeData(brightness: Brightness.dark),
          initialRoute: '/',
          routes: {'/': (context) => Splash()},
        );
      }),
    );
  }
}
