// import 'dart:collection';
import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
// import 'package:manager_queue/data.dart';
// import 'package:manager_queue/api.dart';
import 'package:manager_queue/bloc/queue_bloc.dart';
import 'package:manager_queue/bloc/ready_bloc.dart';
import 'package:manager_queue/helper/config.dart';
import 'package:manager_queue/models/queue.dart';
import 'package:http/http.dart' as http;
import 'package:mqtt_client/mqtt_client.dart';
import 'cubit/queue_cubit.dart';
import 'cubit/ready_cubit.dart';
import 'dart:html';

class MainPage extends StatefulWidget {
  @override
  _MainPageState createState() => _MainPageState();
}

class _MainPageState extends State<MainPage> {
  List<dynamic> orderQueue = [];
  List<dynamic> orderReady = [];
  late List<String> queueSelected = [];
  late List<String> readySelected = [];
  late List<String> pickUp = [];
  List clearData = [OrderQueue];

  void setToReady(List queueSelecteds) async {
    var apiUrl = apiUrlUpdate;
    for (var i in queueSelecteds) {
      Map setReady = {"id": i.toString(), "status": 1};
      var dataReady = jsonEncode(setReady);
      var apiResult = await http.post(Uri.parse(apiUrl), body: dataReady);
      // var jsonObject = jsonDecode(apiResult.body)['status'];
      // if (jsonObject == true) {
      //   context.read<QueueCubit>().getData();
      //   context.read<ReadyCubit>().getData();
      // } else {
      //   print("tidak berhasil");
      // }
    }
    context.read<QueueCubit>().getData();
    context.read<ReadyCubit>().getData();
    final pubTopic = queueTopic;
    final builder = MqttClientPayloadBuilder();
    builder.addString(queueMessage);
    mqClient.publishMessage(pubTopic, MqttQos.exactlyOnce, builder.payload!);
    queueSelected = [];
  }

  void setToQueue(List readySelecteds) async {
    // print(readySelected);
    var apiUrl = apiUrlUpdate;
    for (var i in readySelecteds) {
      Map setQueue = {"id": i.toString(), "status": 0};
      var dataQueue = jsonEncode(setQueue);
      var apiResult = await http.post(Uri.parse(apiUrl), body: dataQueue);
      var jsonObject = jsonDecode(apiResult.body)['status'];
      // if (jsonObject == true) {
      //   context.read<ReadyCubit>().getData();
      //   context.read<QueueCubit>().getData();
      // } else {
      //   print("tidak berhasil");
      // }
    }
    context.read<ReadyCubit>().getData();
    context.read<QueueCubit>().getData();
    final pubTopic = queueTopic;
    final builder = MqttClientPayloadBuilder();
    builder.addString(queueMessage);
    mqClient.publishMessage(pubTopic, MqttQos.exactlyOnce, builder.payload!);
    readySelected = [];
  }

  // void setToPickUp(List<OrderQueue> readySelected) {
  //   for (var i in readySelected) {
  //     orderReady.remove(i);
  //   }

  //   pickUp.addAll(readySelected);
  // }

  void setToPickUp(List readySelecteds) async {
    print(readySelecteds);
    var apiUrl = apiUrlUpdate;
    for (var i in readySelecteds) {
      Map setPickUp = {"id": i.toString(), "status": 2};
      var dataPickUp = jsonEncode(setPickUp);
      var apiResult = await http.post(Uri.parse(apiUrl), body: dataPickUp);
      var jsonObject = jsonDecode(apiResult.body)['status'];
      // if (jsonObject == true) {
      //   context.read<ReadyCubit>().getData();
      //   context.read<QueueCubit>().getData();
      // } else {
      //   print("tidak berhasil");
      // }

    }
    context.read<ReadyCubit>().getData();
    context.read<QueueCubit>().getData();
    final pubTopic = queueTopic;
    final builder = MqttClientPayloadBuilder();
    builder.addString(queueMessage);
    mqClient.publishMessage(pubTopic, MqttQos.exactlyOnce, builder.payload!);
    readySelected = [];
  }

  // ignore: non_constant_identifier_names
  Future setToClear() async {
    // print(readySelected);
    var apiUrl = apiUrlClear;
    // print(apiUrl);
    Map setClear = {'': ''};
    var dataClear = jsonEncode(setClear);
    var apiResult = await http.post(Uri.parse(apiUrl), body: dataClear);
    var jsonObject = jsonDecode(apiResult.body)['status'];
    if (jsonObject == "ok") {
      context.read<ReadyCubit>().getData();
      context.read<QueueCubit>().getData();
      final pubTopic = queueTopic;
      final builder = MqttClientPayloadBuilder();
      builder.addString(queueMessage);
      mqClient.publishMessage(pubTopic, MqttQos.exactlyOnce, builder.payload!);
    } else {
      print("gabisa");
    }
  }

  @override
  Widget build(BuildContext context) {
    context.read<QueueCubit>().getData();
    context.read<ReadyCubit>().getData();

    return MaterialApp(
      debugShowCheckedModeBanner: false,
      home: Scaffold(
        backgroundColor: Colors.white,
        body: Row(
          children: <Widget>[
            Flexible(
              flex: 2,
              child: Container(
                color: Colors.black12,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: <Widget>[
                    Container(
                      width: MediaQuery.of(context).size.width * 0.4,
                      height: MediaQuery.of(context).size.height * 0.1,
                      color: Colors.lightBlue,
                      alignment: Alignment.center,
                      child: Text(
                        "QUEUE",
                        style: TextStyle(
                            fontSize: MediaQuery.of(context).size.height * 0.03,
                            fontWeight: FontWeight.w700),
                      ),
                    ),
                    Container(
                      width: MediaQuery.of(context).size.width * 0.38,
                      height: MediaQuery.of(context).size.height * 0.75,
                      child: MediaQuery.removePadding(
                        context: context,
                        removeTop: true,
                        child: BlocConsumer<QueueCubit, QueueState>(
                          listener: (context, state) {
                            print('listener');
                            print(state);
                          },
                          builder: (context, state) {
                            if (state is QueueLoading) {
                              return Text("");
                              // return CircularProgressIndicator();
                            } else if (state is QueueLoaded) {
                              return GridView.builder(
                                itemCount: state.queues.length,
                                gridDelegate:
                                    const SliverGridDelegateWithFixedCrossAxisCount(
                                        crossAxisCount: 2,
                                        crossAxisSpacing: 10,
                                        mainAxisSpacing: 5,
                                        childAspectRatio: 2),
                                itemBuilder: (BuildContext context, int index) {
                                  var thisQueue = state.queues[index];
                                  return Material(
                                    borderRadius: BorderRadius.circular(10),
                                    child: InkWell(
                                      onTap: () {
                                        context
                                            .read<QueueCubit>()
                                            .onPressed(state.queues, thisQueue);
                                      },
                                      child: Card(
                                          color: Colors.black38,
                                          shape: RoundedRectangleBorder(
                                            borderRadius:
                                                BorderRadius.circular(10),
                                          ),
                                          child: Center(
                                              child: Text(
                                            "Pesanan " + thisQueue.queue_number,
                                            style: TextStyle(fontSize: 20),
                                          ))),
                                    ),
                                  );
                                },
                              );
                            } else if (state is QueueUpdated) {
                              return GridView.builder(
                                itemCount: state.queues.length,
                                gridDelegate:
                                    const SliverGridDelegateWithFixedCrossAxisCount(
                                        crossAxisCount: 2,
                                        crossAxisSpacing: 10,
                                        mainAxisSpacing: 5,
                                        childAspectRatio: 2),
                                itemBuilder: (BuildContext context, int index) {
                                  var thisQueue = state.queues[index];
                                  if (thisQueue.isSelected) {
                                    if (!queueSelected.contains(thisQueue.id)) {
                                      queueSelected.add(thisQueue.id);
                                    }
                                  } else {
                                    queueSelected.remove(thisQueue.id);
                                  }
                                  return Material(
                                    borderRadius: BorderRadius.circular(10),
                                    child: InkWell(
                                      onTap: () {
                                        context
                                            .read<QueueCubit>()
                                            .onPressed(state.queues, thisQueue);
                                      },
                                      child: Card(
                                          color: thisQueue.isSelected
                                              ? Colors.lightGreen
                                              : Colors.black38,
                                          shape: RoundedRectangleBorder(
                                            borderRadius:
                                                BorderRadius.circular(10),
                                          ),
                                          child: Center(
                                              child: Text(
                                            "Pesanan " + thisQueue.queue_number,
                                            style: TextStyle(fontSize: 20),
                                          ))),
                                    ),
                                  );
                                },
                              );
                            } else {
                              return SizedBox();
                            }
                          },
                        ),
                      ),
                    ),
                    InkWell(
                      onTap: () {
                        setToReady(queueSelected);
                      },
                      child: Container(
                        width: MediaQuery.of(context).size.width * 0.4,
                        height: MediaQuery.of(context).size.height * 0.1,
                        color: Colors.lightBlue,
                        alignment: Alignment.center,
                        child: InkWell(
                          onTap: () => setToReady(queueSelected),
                          child: Text(
                            "SET TO READY",
                            style: TextStyle(
                                fontSize: 30, fontWeight: FontWeight.w700),
                          ),
                        ),
                      ),
                    ),
                  ],
                ),
              ),
            ),
            Flexible(
              flex: 1,
              child: Container(
                width: MediaQuery.of(context).size.width * 0.2,
                height: MediaQuery.of(context).size.height * 1,
                color: Colors.blueGrey,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: <Widget>[
                    // Container(
                    //   width: 400,
                    //   height: 100,
                    //   margin: EdgeInsets.all(20),
                    //   decoration: BoxDecoration(
                    //     borderRadius: BorderRadius.all(
                    //       Radius.circular(20),
                    //     ),
                    //     color: Colors.amber,
                    //   ),
                    //   alignment: Alignment.center,
                    //   child: Text(
                    //     "REFRESH",
                    //     style: TextStyle(
                    //         fontSize: 30, fontWeight: FontWeight.w700),
                    //   ),
                    // ),
                    InkWell(
                      onTap: () {
                        // print("clear");
                        showDialog(
                          context: context,
                          builder: (BuildContext context) => AlertDialog(
                            title: Text("Clear"),
                            content: Text("Are you sure to clear data?"),
                            actions: <Widget>[
                              TextButton(
                                onPressed: () => Navigator.pop(context),
                                child: Text('Cancel'),
                              ),
                              TextButton(
                                onPressed: () =>
                                    Navigator.pop(context, setToClear()),
                                child: Text('OK'),
                              ),
                            ],
                          ),
                        );
                      },
                      child: Container(
                        width: MediaQuery.of(context).size.width * 0.18,
                        height: MediaQuery.of(context).size.height * 0.07,
                        margin: EdgeInsets.all(10),
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.all(
                            Radius.circular(20),
                          ),
                          color: Colors.red,
                        ),
                        alignment: Alignment.center,
                        child: Text(
                          "CLEAR",
                          style: TextStyle(
                              fontSize: 30, fontWeight: FontWeight.w700),
                        ),
                      ),
                    ),
                  ],
                ),
              ),
            ),
            Flexible(
              flex: 2,
              child: Container(
                color: Colors.black12,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: <Widget>[
                    Container(
                      width: MediaQuery.of(context).size.width * 0.4,
                      height: MediaQuery.of(context).size.height * 0.1,
                      color: Colors.lightGreen,
                      alignment: Alignment.center,
                      child: Text(
                        "READY",
                        style: TextStyle(
                            fontSize: 30, fontWeight: FontWeight.w700),
                      ),
                    ),
                    Container(
                      width: MediaQuery.of(context).size.width * 0.38,
                      height: MediaQuery.of(context).size.height * 0.75,
                      child: MediaQuery.removePadding(
                        context: context,
                        removeTop: true,
                        child: BlocConsumer<ReadyCubit, ReadyState>(
                          listener: (context, state) {
                            print('listener');
                            print(state);
                          },
                          builder: (context, state) {
                            if (state is ReadyLoading) {
                              // return CircularProgressIndicator();
                              return Text("");
                            } else if (state is ReadyLoaded) {
                              return GridView.builder(
                                itemCount: state.readys.length,
                                gridDelegate:
                                    const SliverGridDelegateWithFixedCrossAxisCount(
                                        crossAxisCount: 2,
                                        crossAxisSpacing: 10,
                                        mainAxisSpacing: 5,
                                        childAspectRatio: 2),
                                itemBuilder: (BuildContext context, int index) {
                                  var thisQueue = state.readys[index];
                                  return Material(
                                    borderRadius: BorderRadius.circular(10),
                                    child: InkWell(
                                      onTap: () {
                                        context
                                            .read<ReadyCubit>()
                                            .onPressed(state.readys, thisQueue);
                                      },
                                      child: Card(
                                          color: Colors.black38,
                                          shape: RoundedRectangleBorder(
                                            borderRadius:
                                                BorderRadius.circular(10),
                                          ),
                                          child: Center(
                                              child: Text(
                                            "Pesanan " + thisQueue.queue_number,
                                            style: TextStyle(fontSize: 20),
                                          ))),
                                    ),
                                  );
                                },
                              );
                            } else if (state is ReadyUpdated) {
                              return GridView.builder(
                                itemCount: state.readys.length,
                                gridDelegate:
                                    const SliverGridDelegateWithFixedCrossAxisCount(
                                        crossAxisCount: 2,
                                        crossAxisSpacing: 10,
                                        mainAxisSpacing: 5,
                                        childAspectRatio: 2),
                                itemBuilder: (BuildContext context, int index) {
                                  var thisQueue = state.readys[index];
                                  if (thisQueue.isSelectedReady) {
                                    if (!readySelected.contains(thisQueue.id)) {
                                      readySelected.add(thisQueue.id);
                                    }
                                  } else {
                                    readySelected.remove(thisQueue.id);
                                  }
                                  return Material(
                                    borderRadius: BorderRadius.circular(10),
                                    child: InkWell(
                                      onTap: () {
                                        context
                                            .read<ReadyCubit>()
                                            .onPressed(state.readys, thisQueue);
                                      },
                                      child: Card(
                                          color: thisQueue.isSelectedReady
                                              ? Colors.blue
                                              : Colors.black38,
                                          shape: RoundedRectangleBorder(
                                            borderRadius:
                                                BorderRadius.circular(10),
                                          ),
                                          child: Center(
                                              child: Text(
                                            "Pesanan " + thisQueue.queue_number,
                                            style: TextStyle(fontSize: 20),
                                          ))),
                                    ),
                                  );
                                },
                              );
                            } else {
                              return SizedBox();
                            }
                          },
                        ),

                        //   child: BlocBuilder<ReadyBloc, List<dynamic>>(
                        //       builder: (context, list) {
                        //     List<dynamic> orderReady = [];
                        //     orderReady = list;
                        //     return GridView.builder(
                        //       itemCount: orderReady.length,
                        //       gridDelegate:
                        //           const SliverGridDelegateWithFixedCrossAxisCount(
                        //               crossAxisCount: 2,
                        //               crossAxisSpacing: 10,
                        //               mainAxisSpacing: 5,
                        //               childAspectRatio: 2),
                        //       itemBuilder: (BuildContext context, int index) {
                        //         var thisReady = orderReady[index];
                        //         return Material(
                        //           borderRadius: BorderRadius.circular(10),
                        //           child: InkWell(
                        //             onTap: () {
                        //               setState(() {
                        //                 if (readySelected.contains(thisReady)) {
                        //                   readySelected.remove(thisReady);
                        //                 } else {
                        //                   readySelected.add(thisReady);
                        //                 }

                        //                 print(readySelected.toString());
                        //               });
                        //             },
                        //             child: Card(
                        //               color: Colors.black38,
                        //               shape: RoundedRectangleBorder(
                        //                 borderRadius: BorderRadius.circular(10),
                        //               ),
                        //               child: Center(
                        //                 child: Text(
                        //                   readySelected.contains(thisReady)
                        //                       ? "Pesanan " + thisReady.id + " ✅"
                        //                       : "Pesanan " + thisReady.id,
                        //                   style: TextStyle(fontSize: 20),
                        //                 ),
                        //               ),
                        //             ),
                        //           ),
                        //         );
                        //       },
                        //     );
                        //   }),
                      ),
                    ),
                    Row(
                      children: [
                        Flexible(
                          flex: 1,
                          child: InkWell(
                            onTap: () {
                              setToQueue(readySelected);
                            },
                            child: Container(
                              width: MediaQuery.of(context).size.width * 0.2,
                              height: MediaQuery.of(context).size.height * 0.1,
                              color: Colors.lightGreen,
                              alignment: Alignment.center,
                              child: InkWell(
                                onTap: () => setToQueue(readySelected),
                                child: Text(
                                  "SET TO QUEUE",
                                  style: TextStyle(
                                      fontSize: 30,
                                      fontWeight: FontWeight.w700),
                                ),
                              ),
                            ),
                          ),
                        ),
                        Flexible(
                          flex: 1,
                          child: InkWell(
                            onTap: () {
                              setToPickUp(readySelected);
                            },
                            child: Container(
                              width: MediaQuery.of(context).size.width * 0.2,
                              height: MediaQuery.of(context).size.height * 0.1,
                              color: Colors.black26,
                              alignment: Alignment.center,
                              child: InkWell(
                                onTap: () => setToPickUp(readySelected),
                                child: Text(
                                  "PICK UP",
                                  style: TextStyle(
                                      fontSize: 30,
                                      fontWeight: FontWeight.w700),
                                ),
                              ),
                            ),
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
}
