// ignore_for_file: unused_import

import 'dart:convert';
import 'dart:io';

import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:loading_animations/loading_animations.dart';
import 'package:manager_queue/models/queue.dart';
import 'package:manager_queue/models/config.dart';
import 'package:mqtt_client/mqtt_client.dart';
import 'package:manager_queue/api.dart';
import 'package:manager_queue/bloc/queue_bloc.dart';
import 'package:manager_queue/helper/config.dart';
import 'package:manager_queue/main.dart';
import 'package:manager_queue/helper/config.dart';
import 'package:manager_queue/main_page.dart';
import 'package:uuid/uuid.dart';
import 'package:flutter/services.dart' as bundel_root;
import 'package:http/http.dart' as http;

class Splash extends StatefulWidget {
  const Splash({Key? key}) : super(key: key);

  @override
  State<Splash> createState() => _SplashState();
}

class _SplashState extends State<Splash> {
  Future<List<ConfigApl>> config({url = ""}) async {
    // String? base_urlapi = prefs.getString('base_url');
    List<ConfigApl> apiConfigs = [];
    try {
      var apiConfig = await ApiQueue.getConfig();
      apiConfigs = apiConfig;
    } catch (e) {
      print("Error pada splash $e");
    }

    return apiConfigs;
  }

  Future<String> loadBaseUrl() async {
    String data = await bundel_root.rootBundle.loadString('baseurl.json');
    return jsonDecode(data)['base_url'].toString();
  }

  Future<int> runMqTT() async {
    mqClient.logging(on: false);
    mqClient.setProtocolV311();
    mqClient.keepAlivePeriod = 86400;
    mqClient.port = mqttPort;
    mqClient.onDisconnected;
    mqClient.onConnected;
    mqClient.onSubscribed;
    // mqClient.pongCallback = pong;

    final connMess = MqttConnectMessage()
        .withClientIdentifier(mqqtIdentifier)
        .withWillTopic(
            'willtopic') // If you set this you must set a will message
        .withWillMessage('My Will message')
        .startClean() // Non persistent session for testing
        .withWillQos(MqttQos.atLeastOnce);
    // print('EXAMPLE::Mosquitto client connecting....');
    mqClient.connectionMessage = connMess;

    try {
      await mqClient.connect();
    } on NoConnectionException catch (e) {
      // Raised by the client when connection fails.
      // print('EXAMPLE::client exception - $e');
      mqClient.disconnect();
    } on SocketException catch (e) {
      // Raised by the socket layer
      // print('EXAMPLE::socket exception - $e');
      mqClient.disconnect();
    }
    if (mqClient.connectionStatus!.state == MqttConnectionState.connected) {
      // print('EXAMPLE::Mosquitto client connected');
    } else {
      /// Use status here rather than state if you also want the broker return code.
      // print(
      //     'EXAMPLE::ERROR Mosquitto client connection failed - disconnecting, status is ${mqClient.connectionStatus}');
      mqClient.disconnect();
      exit(-1);
    }

    /// Ok, lets try a subscription
    // print('EXAMPLE::Subscribing to the queuetest/1 topic');
    var topic = queueTopic; // Not a wildcard topic
    mqClient.subscribe(topic, MqttQos.atMostOnce);

    /// The client has a change notifier object(see the Observable class) which we then listen to to get
    /// notifications of published updates to each subscribed topic.
    mqClient.updates!.listen((List<MqttReceivedMessage<MqttMessage?>>? c) {
      final recMess = c![0].payload as MqttPublishMessage;
      final pt =
          MqttPublishPayload.bytesToStringAsString(recMess.payload.message);
      if (c[0].topic == topic && pt == queueMessage) {
        context.read<QueueBloc>().queueList();
        // print("berhasil update API");
      } else {
        // print("tidak berhasil dapat message yang sesuai");
      }

      // print('Notifikasi masuk dari topic <${c[0].topic}>, isinya adalah: $pt ');
      // print('');
    });

    return 0;
  }

  var uuidUnique = const Uuid();
  @override
  void initState() {
    loadBaseUrl().then((value) async {
      await prefs.setString('base_url', value);
      print(value);
      // await prefs.setString('uuid', uuidUnique.v4());
      // await prefs.setString('mqtt_url', value[0].mqtt_url);
      // await prefs.setInt('mqtt_port', value[0].mqtt_port);
      // await prefs.setString('mqtt_queue_topic', value[0].mqtt_queue_topic);
      // await prefs.setString('mqtt_queue_message', value[0].mqtt_queue_message);
      config(url: value).then((value) async {
        await prefs.setString('mqtt_url', value[0].mqtt_url);
        await prefs.setInt('mqtt_port', value[0].mqtt_port);
        await prefs.setString('mqtt_queue_topic', value[0].mqtt_queue_topic);
        await prefs.setString(
            'mqtt_queue_message', value[0].mqtt_queue_message);
        await prefs.setString('uuid', uuidUnique.v4());

        runMqTT();
        Future.delayed(const Duration(seconds: 3), () {
          Navigator.push(
              context, MaterialPageRoute(builder: (_) => MainPage()));
        });
      });

      // runMqTT();
      // Future.delayed(const Duration(seconds: 3), () {
      //   Navigator.push(context, MaterialPageRoute(builder: (_) => MainPage()));
      // });
    });

    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: [
        Text(
          "Please wait",
          style: TextStyle(
              fontSize: MediaQuery.of(context).size.height * 0.03,
              fontWeight: FontWeight.w500,
              color: Colors.black,
              decoration: TextDecoration.none),
        ),
        LoadingBumpingLine.circle(
          size: MediaQuery.of(context).size.height * 0.1,
          backgroundColor: Colors.black,
        )
      ],
    );
  }
}
