
import Auth from './view/Auth';
import { NavigationContainer } from '@react-navigation/native';
import { persistStore, persistReducer } from 'redux-persist';
import { AsyncStorage } from 'react-native';
import { PersistGate } from "redux-persist/integration/react";
import rootReducer from './redux/globalReducer';
import { createStore } from 'redux';
import { Provider } from 'react-redux';
import * as Localization from 'expo-localization';
import i18n from 'i18n-js';
import en from './lib/en';
import id from './lib/id';
import React, { useState, useEffect } from 'react';
import { Text, View } from 'react-native';
import { AppLoading } from 'expo';
import * as Font from 'expo-font';
import * as Sentry from 'sentry-expo';
import Constants from 'expo-constants';

Sentry.init({
  dsn: 'https://ae2449ac801244d99f170140c7cd6d0a@o392471.ingest.sentry.io/5239999',
  enableInExpoDevelopment: true,
  debug: true,
});

Sentry.setRelease(Constants.manifest.revisionId);

export const lang = i18n.translations = {
  en: en,
  id: id
}

export const set_lang = i18n.locale = Localization.locale;
export const fallbacks = i18n.fallbacks = true;

const persistConfig = {
  key: 'root',
  storage: AsyncStorage,
};

const persistReducers = persistReducer(persistConfig, rootReducer)
const store = createStore(persistReducers);
const persistor = persistStore(store)
i18n.locale = Localization.locale;

let customFonts = {
  'Gotham-Black': require('./assets/font/Gotham-Bold-700.otf'),
  'Gotham-SemiBoldItalic': require('./assets/font/Gotham-BoldItalic-400.otf'),
  'Gotham-Thin': require('./assets/font/iCiel-Gotham-Thin.ttf'),
  'Gotham-Light': require('./assets/font/Metropolis-Light.otf'),
};

export default function App() {
  const [fontsLoaded, setfontsLoaded] = useState(false)

  const loadFont = async () => {
    await Font.loadAsync(customFonts);
  };

  useEffect(() => {
    console.log('===> Did Mount');
    loadFont().then(_ => {
      setfontsLoaded(true);
    })
  }, [])

  if (!fontsLoaded) {
    return <AppLoading />;
  } else {
    return (
      <Provider store={store}>
        <PersistGate loading={null} persistor={persistor}>
          <NavigationContainer>
            <Auth />
          </NavigationContainer>
        </PersistGate>
      </Provider>
    );
  }
}
