import React, { Component, PureComponent } from 'react';
import { StyleSheet, Text, TextInput, View, Button,Alert } from 'react-native';
import Axios from 'axios';
import {BASE_URL_CHANGE_PASSWORD} from '../model/Base_Model';
import { connect } from 'react-redux';

class ChangePassword extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            session_id: '',
            old_password: '',
            Password: '',
            Password_confirmation: '',
        }
    }

    componentDidMount(){

    }

    changePassword() {
        let params = {
            "session_id": this.props.session_id,
            "old_password": this.state.old_password,
            "password": this.state.Password,
            "password_confirmation": this.state.Password_confirmation
        }
        Axios.post(BASE_URL_CHANGE_PASSWORD, params).then(res => {
            this.props.navigation.navigate('Profile');
        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.msg);
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', marginTop: 10, fontSize: 25 }}>Change Password</Text>
                </View>
                <View style={styles.form}>
                    <View style={styles.field_token}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>Current Password</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 50, borderWidth: 1, padding: 5, margin: 10 }}  
                            onChangeText={(old_password) => this.setState({ old_password })}
                            value={this.state.old_password }  
                            secureTextEntry={true}/>
                        </View>
                    </View>
                    <View style={styles.field_new_password}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>New Password</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 50, borderWidth: 1, padding: 5, margin: 10 }}  
                            onChangeText={(Password) => this.setState({ Password })}
                            value={this.state.Password} 
                            secureTextEntry={true}/>
                        </View>
                    </View>
                    <View style={styles.field_repeat_password}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>Repeat Password</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 50, borderWidth: 1, padding: 5, margin: 10 }}  
                            onChangeText={(Password_confirmation) => this.setState({ Password_confirmation })}
                            value={this.state.Password_confirmation} 
                            secureTextEntry={true}/>
                        </View>
                    </View>
                    <View style={styles.button}>
                        <Button title="Change Password" onPress={()=>this.changePassword()}></Button>
                    </View>
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    form: {
        flex: 3,
        margin: 10,
        marginTop: 0,
    },

    field_token: {
        flexDirection: 'row'
    },

    field_new_password: {
        flexDirection: 'row'
    },

    field_repeat_password: {
        flexDirection: 'row'
    },

    button: {
        height: 50,
        margin: 10,

    }

});

const mapStateToProps = (state) => {
    return {
        session_id: state.session_id,
    }
}


export default connect(mapStateToProps)(ChangePassword);
