import React from 'react';
import {
    View,
    StyleSheet,
    Text,
    StatusBar,
    Image,
    ScrollView,
    TouchableOpacity,
    Alert,
    ImageBackground,
} from 'react-native';
import { CheckBox, Separator, Grid, Row, Card, Button, Icon, CardItem, Body } from 'native-base';
import { Collapse, CollapseHeader, CollapseBody, AccordionList } from 'accordion-collapse-react-native'
import Axios from 'axios';
import HTML from 'react-native-render-html';


export default class TopUpInfo extends React.Component {
    constructor(props){
        super(props);
        this.state = {
            content:""
        }
    }

    componentDidMount(){
        Axios.get('https://excelsocrm.ravintoladev.com/cms/v2/detail/topup-info').then(res => {

            let data = res.data
            let contents = data.content

            this.setState({

                content:contents
            })
          
        }).catch(error => {
            let response = error.response.data;
            // console.log(response.msg)
            Alert.alert(response.msg);
        })
    }
    
   

    render() {
    const htmlContent = this.state.content;
        return (
            <ScrollView style={{ backgroundColor:'white'}}>
                <View style={{ flex: 1 }}>

                    <Collapse>
                        <CollapseHeader>
                            <Separator bordered style={{backgroundColor:'white'}}>
                                <Text style={{ fontSize: 12, fontWeight: 'bold' }}>Bank BCA</Text>
                            </Separator>
                        </CollapseHeader>
                        <CollapseBody>
                            <Card style={{ marginLeft: 10, marginRight: 10 }}>
                                <CardItem>
                                    <Body style={{ marginLeft: 5 }}>
                                        <HTML html={this.state.content} />
                                    </Body>
                                </CardItem>
                            </Card>
                        </CollapseBody>
                    </Collapse>

                    <Collapse>
                        <CollapseHeader>

                            <Separator bordered style={{backgroundColor:'white'}}>
                                <Text style={{ fontSize: 12, fontWeight: 'bold' }}>Bank BNI</Text>
                            </Separator>

                        </CollapseHeader>
                        <CollapseBody>
                        <Card style={{ marginLeft: 10, marginRight: 10 }}>
                                <CardItem>
                                <Body style={{ marginLeft: 5 }}>
                                        <HTML html={this.state.content} />
                                    </Body>
                                </CardItem>
                            </Card>
                        </CollapseBody>
                    </Collapse>

                    <Collapse>
                        <CollapseHeader>

                            <Separator bordered style={{backgroundColor:'white'}}>
                                <Text style={{ fontSize: 12, fontWeight: 'bold' }}>Bank MANDIRI</Text>
                            </Separator>

                        </CollapseHeader>
                        <CollapseBody>
                        <Card style={{ marginLeft: 10, marginRight: 10 }}>
                                <CardItem>
                                <Body style={{ marginLeft: 5 }}>
                                        <HTML html={this.state.content} />
                                    </Body>
                                </CardItem>
                            </Card>
                        </CollapseBody>
                    </Collapse>
                    </View>

            </ScrollView>
        )
    }
}