import React from 'react';
import { View, Text, TextInput, StyleSheet, ScrollView, Alert, TouchableOpacity, Image, Linking } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import session from '../function/session';
import HTML from 'react-native-render-html';
import { WebView } from 'react-native-webview';
import ActionType from '../redux/globalActionType';
import moment from 'moment';
import { Button } from 'react-native-elements';
import MyStatusBar from './MyStatusBar';

class RewardDetail extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            image: '',
            title: '',
            subtitle: '',
            content: '',
            expire: '',
            code: '',
            used: '',
            dateNow: '',
            value: '',
            cur_time: '',
            exp_time: '',
        }
    }

    componentDidMount() {
        this.detailReward()
        this._unsubscribe = this.props.navigation.addListener('focus', () => {
            this.detailReward()
        });
    }

    componentWillUnmount() {
        this._unsubscribe()
    }

    detailReward() {

        let params = {
            session_id: this.props.session_id,
            reward_id: this.props.route.params.rewardId
        }
        Axios.post(this.props.BASE_URL+'crm/v2/reward/get_detail', params).then(res => {


            let expire_date = moment(res.data.reward.expire_time).format('DD MMMM YYYY')
            let exp_time = new Date(res.data.reward.expire_time)
            exp_time.setHours(0, 0, 0, 0);
            let cur_time = new Date()
            cur_time.setHours(0, 0, 0, 0);

            this.setState({
                image: res.data.reward.reward.content_image,
                title: res.data.reward.reward.title,
                subtitle: res.data.reward.reward.subtitle,
                content: res.data.reward.reward.content,
                expire: expire_date,
                code: res.data.reward.verification_number,
                used: res.data.reward.used,
                value: res.data.reward,
                cur_time: cur_time,
                exp_time: exp_time

            })

        }).catch(error => {
            const { navigation } = this.props
            let response = error.response.data
            session(response, navigation)
            Alert.alert(response.msg);
        })
    }


    useVoucher() {
        let voucherProps = {
            value_voucher: this.state.value,
            voucher: this.state.value
        }

        this.props.setVoucher(voucherProps);
        this.props.navigation.navigate('Home', { screen: 'MENU' })

    }

    useDVoucher() {
        this.props.navigation.navigate('Reward History')
    }


    render() {
        console.log(this.state.content)
        return (
            <View style={styles.container}>
                <MyStatusBar />
                <ScrollView>
                    <View style={styles.images}>
                        <Image style={{ height: 250, width: '100%' }} source={this.state.image ? { uri: this.state.image } : null} />
                        <View style={styles.voucher_code}>
                            <Text style={styles.text_voucher}>VOUCHER CODE</Text>
                            <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 20, textAlign: 'center', marginBottom: 5, top: 15 }}>{this.state.code}</Text>
                        </View>
                        <View style={styles.expire_time}>
                            <View style={{ flex: 0.5 }}>
                                <Text style={styles.text_expire}>EXPIRED ON</Text>
                            </View>
                            <View style={{ flex: 0.5 }}>
                                <Text style={{ fontFamily: 'Gotham-Light', color: 'white', fontSize: 14, textAlign: 'right', marginBottom: 5, top: 5, paddingRight: 12 }}>{this.state.expire}</Text>
                            </View>
                        </View>

                    </View>

                    <View style={styles.content}>
                        <View style={{ marginRight: 5, marginLeft: 5 }}>
                            <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 15 }}>{this.state.title}</Text>
                        </View>
                        <View
                            style={{ marginHorizontal: 20 }}
                        >

                            <HTML html={this.state.content}
                                tagsStyles={{ p: { fontSize: 12, color: '#838383', fontFamily: 'Gotham-Light' }, li: { fontSize: 12, color: '#838383', fontFamily: 'Gotham-Light' }, ul: { fontSize: 12, color: '#838383', fontFamily: 'Gotham-Light', marginTop: 10 }, blockquote: { backgroundColor: "#f1f1f1", padding: 12, paddingBottom: 0, marginTop: 6 } }}
                                ignoredTags={['br']}
                                ignoredStyles={['font-family']}
                                onLinkPress={(event, href) => {
                                    Linking.openURL(href)
                                }} />
                        </View>
                    </View>
                    <View style={styles.content}>
                        {this.state.cur_time >= this.state.exp_time ? (
                            <View style={{ flex: 1, height: 50, marginRight: 70, marginLeft: 70, justifyContent: 'center' }}>
                                <TouchableOpacity>
                                    <View style={{ height: 40, borderRadius: 10, backgroundColor: 'red' }}>
                                        <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 16, textAlign: 'center', margin: 11 }}>EXPIRED</Text>
                                    </View>
                                </TouchableOpacity>
                            </View>
                        )
                            : this.state.used == 0 ? (
                                <View style={{ flex: 1, height: 50, marginRight: 70, marginLeft: 70, justifyContent: 'center' }}>
                                    <TouchableOpacity onPress={() => this.useVoucher()}>
                                        <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368' }}>
                                            <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 16, textAlign: 'center', margin: 11 }}>USE VOUCHER</Text>
                                        </View>
                                    </TouchableOpacity>
                                </View>
                            ) : (
                                    <TouchableOpacity onPress={() => this.useDVoucher()}>
                                        <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368' }}>
                                            <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 16, textAlign: 'center', margin: 11 }}>USED VOUCHER</Text>
                                        </View>
                                    </TouchableOpacity>
                                )}

                    </View>
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    body: {
        flex: 1,
        backgroundColor: 'red'
    },

    voucher_code: {
        fontFamily: 'Gotham-Black',
        height: 70,
        marginLeft: 20,
        marginRight: 20,
        backgroundColor: '#CFB368',
        flex: 1,
        marginTop: -100

    },

    expire_time: {
        fontFamily: 'Gotham-Light',
        flex: 1,
        flexDirection: 'row',
        justifyContent: 'space-between',
        marginLeft: 20,
        marginRight: 20,
        height: 30,
        justifyContent: 'center',
        backgroundColor: '#838383',
    },

    text_voucher: {
        fontFamily: 'Gotham-Light',
        fontSize: 14,
        marginLeft: 10,
        top: 5,
        color: 'white'
    },

    text_c_voucher: {
        fontFamily: 'Gotham-Black',
        textAlign: 'center',
        fontWeight: 'bold',
        fontSize: 30,
        top: 5,
        color: 'white'
    },

    text_expire: {
        fontFamily: 'Gotham-Light',
        fontSize: 14,
        marginLeft: 10,
        top: 5,
        color: 'white'
    },

    text_c_expire: {
        fontFamily: 'Gotham-Black',
        textAlign: 'center',
        fontWeight: 'bold',
        fontSize: 30,
        top: 5,
        color: 'white',
    },

    content: {

        flex: 1,
        marginBottom: 20,
    },
    button: {
        flex: 1,
        height: 60,
        backgroundColor: '#2ead28',
        borderRadius: 5,
    },
    images: {
        flex: 1,
    }
})


const mapDispatchToProps = (dispacth) => {
    return {

        setVoucher: (voucherProps) => dispacth({
            type: ActionType.SET_VOUCHER,
            data: {

                voucher: voucherProps.voucher,
                value_voucher: voucherProps.value_voucher,

            }
        }),
    }
}

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,
        lat: state.lat,
        long: state.long,
        BASE_URL: state.BASE_URL,

    }
}

export default connect(mapStateToProps, mapDispatchToProps)(RewardDetail);
