import React from 'react';
import { View, Text, Image, StyleSheet, ScrollView, Alert, TouchableOpacity, ActivityIndicator } from 'react-native';
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux';
import Axios from 'axios';
import moment from 'moment'
import i18n from 'i18n-js';

class RewardHistory extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            rewardsList: [],
            indicator: true
        }
    }

    componentDidMount() {
        this.getRewardsList()
        this._unsubscribe = this.props.navigation.addListener('focus', () => {
            this.getRewardsList()

        });
    }

    componentWillUnmount() {
        this._unsubscribe()
    }

    getRewardsList() {
        let params = {
            session_id: this.props.session_id
        }
        Axios.post(this.props.BASE_URL+'crm/v2/reward/history', params).then(res => {
            let data = res.data.rewards
            // console.log(data)
            data.map((item, key) => {
                // console.log(item.expire_time)
                item.expire_time = moment(item.expire_time).format("DD MMMM YYYY")
                item.used_time = moment(item.used_time).format("DD MMMM YYYY")
            })
            // console.log(data)
            this.setState({
                rewardsList: data,
                indicator: false
            })

        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.status, response.msg);
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <ScrollView style={styles.body}>
                    {this.state.indicator ? (<ActivityIndicator style={{ justifyContent: "center", alignItems: 'center', margin: 20 }} size="large" color="#c9af6d" />) :
                        this.state.rewardsList.length ? (
                            this.state.rewardsList.map((item, key) => (
                                <TouchableOpacity key={key} onPress={() => this.props.navigation.navigate('Reward Detail', { rewardId: item.id })}>
                                    <View style={{ alignItems: 'center' }}>
                                        <Card style={{ padding: 5, margin: 10 }}>
                                            <View>
                                                <Image source={{ uri: item.reward.title_image }}
                                                    resizeMethod="resize"
                                                    resizeMode='cover'
                                                    style={{ height: 100, width: '100%' }} />
                                            </View>
                                            <View style={{ flexDirection: 'row', justifyContent: 'space-between', padding: 10 }}>
                                                <View>
                                                    <Text style={{ textAlign: 'left', fontSize: 12, fontFamily: 'Gotham-Black' }}>{item.reward.title}</Text>
                                                    <Text style={{ textAlign: 'left', fontSize: 12, fontFamily: 'Gotham-Light' }}>{item.reward.subtitle}</Text>
                                                </View>
                                                <View>
                                                    <Text style={{ textAlign: 'right', fontSize: 12, fontFamily: 'Gotham-Light' }}>Used at</Text>
                                                    <Text style={{ textAlign: 'right', fontSize: 12, fontFamily: 'Gotham-Light' }}>{item.used_time}</Text>
                                                </View>
                                            </View>
                                        </Card>
                                    </View>
                                </TouchableOpacity>
                            ))
                        ) : (
                                <View style={{ alignItems: 'center', margin: 20 }}>
                                    <Text style={{ textAlign: 'right', fontSize: 12, fontFamily: 'Gotham-Light' }}>{i18n.t('noRewardHistorydata')}</Text>
                                </View>
                            )


                    }
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {
        flex: 0.1,
        backgroundColor: '#ccb46c',
        justifyContent: 'center'
    },

    body: {
        flex: 3,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,
        languange: state.language,
        BASE_URL: state.BASE_URL

    }
}

export default connect(mapStateToProps)(RewardHistory);