import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, Alert, TouchableOpacity, Image, ImageBackground, ScrollView } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import ActionType from '../redux/globalActionType';
import { BASE_URL_NEW_PASSWORD } from '../model/Base_Model'
import Spinner from 'react-native-loading-spinner-overlay';
import MyStatusBar from './MyStatusBar';
import i18n from 'i18n-js';

class NewPassword extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            caretHidden:true,
            confirmation_number: '',
            email: this.props.email,
            password: '',
            password_confirmation: '',
            spinner: false,
        }
    }

    componentDidMount() {
        // console.log(this.props)
    }

    validation() {
        this.setState({
            spinner: true,
        })
        if(this.state.confirmation_number == '') {
            this.setState({
                spinner: false,
            })
            Alert.alert(
                '',
                i18n.t('alertTokenResetPassword')
                ,
            )

        } else if(this.state.password == '') {
            this.setState({
                spinner: false,
            })
            Alert.alert(
                '',
                i18n.t('alertNewPassword')
                ,
            )

        } else if(this.state.password_confirmation == '') {
            this.setState({
                spinner: false,
            })
            Alert.alert(
                '',
                i18n.t('alerConfirmNewPassword')
                ,
            )

        } else if (this.state.password !== this.state.password_confirmation) {
            this.setState({
                spinner: false,
            })
            Alert.alert(
                '',
                i18n.t('alertPasswordMustBeSame')
                ,
            )

        } else {
            this.handleResetPassword();
        }
    }

    handleResetPassword() {
        this.setState({
            spinner: true,
        })
        let params = {
            'confirmation_number': this.state.confirmation_number,
            'email': this.state.email,
            'password': this.state.password,
            'password_confirmation': this.state.password_confirmation
        }
        // console.log(params);
        Axios.post(this.props.BASE_URL + 'crm/v2/auth/reset_password', params).then(res => {
            let isSubmit = {
                isSubmitResetPassword: false
            }
            this.props.setChangeIsSubmit(isSubmit)

            this.setState({
                spinner: false,
            })
            this.props.navigation.navigate('Login')
        }).catch(error => {
            let response = error.response.data;
            Alert.alert(
                '',
                response.msg,
                [
                    {
                        text: 'OK', onPress: () => this.setState({
                            spinner: false,
                        })
                    }
                ]
            );
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <MyStatusBar />
                <Spinner
                    visible={this.state.spinner}
                    textContent={'Loading...'}
                    textStyle={styles.spinnerTextStyle}
                />
                <View style={{ flex: 3 }}>
                     
                    <View style={{ flex: 1, marginRight: 30, marginLeft: 30, top: 20}}> 
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>{i18n.t('email')}</Text>
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#838383', fontSize: 18, textAlign: 'center', margin: 3, marginBottom: 15 }}>{this.props.email}</Text>
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>{i18n.t('token')}</Text>
                        <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                            onChangeText={(confirmation_number) => this.setState({ confirmation_number })}
                            keyboardType='numeric'
                            caretHidden={this.state.caretHidden}
                            onFocus={() => this.setState({caretHidden: false})}
                            value={this.state.confirmation_number} />
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>{i18n.t('newpassword')}</Text>
                        <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                            onChangeText={(password) => this.setState({ password })}
                            value={this.state.password}
                            caretHidden={this.state.caretHidden}
                            onFocus={() => this.setState({caretHidden: false})}
                            secureTextEntry={true} />
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>{i18n.t('repeatpassword')}</Text>
                        <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                            onChangeText={(password_confirmation) => this.setState({ password_confirmation })}
                            value={this.state.password_confirmation}
                            caretHidden={this.state.caretHidden}
                            onFocus={() => this.setState({caretHidden: false})}
                            secureTextEntry={true} />
                        
                        <TouchableOpacity style={{ 
                            marginBottom: 50, top: 20, marginRight: 50, marginLeft: 50 }} 
                            onPress={() => this.validation()} >
                            <View style={{ backgroundColor: '#CFB368', height: 45, paddingVertical:10,  borderRadius: 10 }}>
                                <Text style={{ alignSelf: 'center',  color: 'white', fontFamily: 'Gotham-Black', fontSize: 20 }}>{i18n.t('submit')}</Text>
                            </View>
                        </TouchableOpacity> 

                        <View style={{flex:2}}>
                            <ImageBackground source={require('../assets/images/daun.png')} style={styles.logo}></ImageBackground>
                        </View>
                    </View> 
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    form: {
        flex: 3,
        margin: 10,
        marginTop: 0,
    },

    // v_logo: {
    //     flex: 2,
    //     flexDirection: 'column-reverse',
    //     alignContent: 'flex-start',
    // },
    logo: {
        alignSelf: 'flex-start',
        marginTop: 200,
        width: 290,
        height: 290,
        bottom: 150,

    },

})

const mapStateToProps = (state) => {
    return {
        email: state.email,
        isSubmitResetPassword: state.isSubmitResetPassword,
        BASE_URL: state.BASE_URL,
    }
}

const mapDispatchToProps = (dispacth) => {
    return {
        setChangeIsSubmit: (isSubmitProps) => dispacth({
            type: ActionType.SET_CHANGE_RESET_PASSWORD,
            data: {
                isSubmitResetPassword: isSubmitProps.isSubmitResetPassword
            }
        })
    }
}

export default connect(mapStateToProps,mapDispatchToProps)(NewPassword);



{/* <Spinner
                    visible={this.state.spinner}
                    textContent={'Loading...'}
                    textStyle={styles.spinnerTextStyle}
                />
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', marginTop: 10, fontSize: 25 }}>New Password</Text>
                </View>
                <View style={styles.form}>
                    <View style={styles.field_token}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>Token</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                onChangeText={(confirmation_number) => this.setState({ confirmation_number })}
                                value={this.state.confirmation_number} />
                        </View>
                    </View>
                    <View style={styles.field_new_password}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>New Password</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                onChangeText={(password) => this.setState({ password })}
                                value={this.state.password}  
                                secureTextEntry={true}/>
                        </View>
                    </View>
                    <View style={styles.field_repeat_password}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>Repeat Password</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                onChangeText={(password_confirmation) => this.setState({ password_confirmation })}
                                value={this.state.password_confirmation} 
                                secureTextEntry={true}/>
                        </View>
                    </View>
                    <View style={styles.button}>
                        <Button title="Submit" onPress={() => this.validation()}></Button>
                    </View>
                </View> */}