import Axios from 'axios';
import React from 'react';
import { Image, ScrollView, StyleSheet, Text, TextInput, TouchableOpacity, View } from 'react-native';
import RNPickerSelect from 'react-native-picker-select';
import { connect } from 'react-redux';
import { BASE_URL_GET_ENUM } from '../model/Base_Model';
import ActionType from '../redux/globalActionType';

class ChangeProfil extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            full_name: '',
            dob_day: '',
            dob_month: '',
            dob_year: '',
            gender: [],
            gender_selected: '',
            email: '',
            no_tlp: '',
            caretHidden:true
        }
        // console.log('PROPS : ' + JSON.stringify(props.navigation))
    }

    componentDidMount() {

        Axios.get(BASE_URL_GET_ENUM).then(res => {
            // console.log('ENUM :' + JSON.stringify(res.data.gender));
            let gender = res.data.gender;
            let gender_list = []


            for (const gen in gender) {
                if (gender.hasOwnProperty(gen)) {
                    const label = gender[gen];
                    const value = gen;
                    gender_list.push({ label: label, value: value })
                }
            }

            this.setState({
                gender: gender_list,

            })
            // console.log('STATE GENDER' + JSON.stringify(this.state.gender))
            // this.state.gender.map()
        })

        let params = {
            session_id: this.props.session_id
        }

        Axios.post('https://excelsocrm.ravintoladev.com/crm/v1/member/get_profile', params).then(res => {
            let data = res.data
            this.setState({
                full_name: data.name,
                email: data.email,
                dob_day: data.dob_day,
                dob_month: data.dob_month,
                dob_year: data.dob_year,
                gender_selected: data.gender.toString()
            })


            // console.log('AFTER CALL : ' + JSON.stringify(this.state.gender_selected))
        })


    }

    saveData() {

        let params1 = {
            session_id: this.props.session_id,
            name: this.state.full_name,
            gender: this.state.gender_selected,
            mobile_phone: this.state.no_tlp
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/member/set_profile', params1).then(res => {
            this.props.navigation.goBack()
            this.props.route.params.onChangeProfil({ example: 'wakwaw' })
            // console.log(JSON.stringify('A : ' + JSON.stringify(this.props.route.params)))
        })

    }

    render() {
        return (
            <View style={styles.container}>
            <ScrollView>
            <View style={{ flex: 1, height: 90, top: 10 }}>
            <View style={{ alignSelf: 'center' }}>
                        <Image
                            style={{ height: 70, width: 70, top: 5, justifyContent: 'center' }}
                            source={require('../assets/images/people-actv.png')}
                        />
                    </View>
            </View>
            <View style={{ flex: 3 }}>
                <View style={{ flex: 1, margin: 20,top:20 }}>
                    <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>Name</Text>
                    <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                         onChangeText={(full_name) => this.setState({ full_name })} value={this.state.full_name} 
                         caretHidden={this.state.caretHidden}
                         onFocus={() => this.setState({caretHidden: false})}>
                    </TextInput>
                    <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>Date of Birth</Text>
                    <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                    editable={false}>
                    {this.state.dob_day} / {this.state.dob_month} / {this.state.dob_year}
                    </TextInput>
                    <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin:3 }}>Gender</Text>
                    <View style={{justifyContent:'center',borderRadius:10,borderWidth:1,borderColor:'grey',height:40,marginRight:10,marginLeft:10}}>
                    <RNPickerSelect
                            value={this.state.gender_selected}
                            // itemKey="1"
                            placeholderTextColor='gray'
                            onValueChange={(value) => this.setState({ gender_selected: value })}
                            items={this.state.gender} />
                    </View>
                    
                    <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>Mobile</Text>
                    <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                        onChangeText={(no_tlp) => this.setState({ no_tlp })}
                        editable={true}
                        caretHidden={this.state.caretHidden}
                        onFocus={() => this.setState({caretHidden: false})}>
                    </TextInput>
                </View>
            </View>
            <View style={{ flex: 2 }}>
                <View style={{ flex: 1 }}>
                    <View style={{ flex: 1, flexDirection: 'row', top: 10, margin: 5,marginBottom:20,marginLeft:20,marginRight:20}}>
                        <View style={{ flex: 1, margin: 5 }}>
                        <TouchableOpacity title="Edit" onPress={() => this.saveData()}>
                            <View style={{ height: 60, borderRadius: 20, backgroundColor: '#CFB368' }}>
                                <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 19, textAlign: 'center', margin: 15 }}>Save</Text>
                            </View>
                            </TouchableOpacity>
                        </View>
                        <View style={{ flex: 1, margin: 5 }}>
                        <TouchableOpacity title="Edit" onPress={() => this.props.navigation.navigate('Profile')}>
                            <View style={{ height: 60, borderRadius: 20, backgroundColor: '#CFB368' }}>
                                <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 19, textAlign: 'center', margin: 15 }}>Cancel</Text>
                            </View>
                        </TouchableOpacity>
                        </View>
                    </View>
                </View>
            </View>
            </ScrollView>
        </View>
        )
    }
}


const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
        
    }
})


const mapDispatchToProps = (dispacth) => {
    return {
        setChangeProfilProps: (changeProfilProps) => dispacth({
            type: ActionType.SET_CHANGE_PROFIL,
            data: {
                full_name: changeProfilProps.full_name,
                gender_display: changeProfilProps.gender_display,
            }
        }),
    }
}
const mapStateToProps = (state) => {
    return {
        
        session_id: state.session_id,
        gender_display: state.gender_display,
        full_name: state.full_name
        
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(ChangeProfil);
        // <View style={styles.container}>
        //     <Text style={{ textAlign: "center", margin: 50, fontWeight: 'bold', fontSize: 25 }}> Change Profile </Text>
        //     <View style={{ margin: 10, flex: 1, }}>
        //         <View style={{ height: 50, flexDirection: 'row' }}>
        //             <Text style={{ fontSize: 20, margin: 5, flex: 1 }}>Name </Text>
        //             <TextInput
        //                 style={{ height: 40, borderColor: 'gray', borderWidth: 1, padding: 5, flex: 2 }}
        //                 onChangeText={(full_name) => this.setState({ full_name })}
        //                 value={this.state.full_name}
        //             />
        //         </View>
        //         <View style={{ height: 50, flexDirection: 'row' }}>
        //             <Text style={{ fontSize: 20, margin: 5, flex: 1 }}>Date of {'\n'}Birth </Text>
        //             <Text style={{ fontSize: 15, margin: 5, borderWidth: 1, flex: 2, padding: 5 }}>{this.state.dob_day} - {this.state.dob_month} - {this.state.dob_year} </Text>
        //         </View>
        //         <View style={{ height: 50, flexDirection: 'row' }}>
        //             <View style={{ flex: 1 }}>
        //                 <Text style={{ fontSize: 20, margin: 5, flex: 1 }}>Gender </Text>
        //             </View>
        //             <View style={{ height: 50, flex: 1 }}>
        //                 <RNPickerSelect
        //                     value={this.state.gender_selected}
        //                     // itemKey="1"
        //                     placeholderTextColor='gray'
        //                     onValueChange={(value) => this.setState({ gender_selected: value })}
        //                     items={this.state.gender} />
        //             </View>
        //         </View>
        //         <View style={{ height: 50, flexDirection: 'row' }}>
        //             <Text style={{ fontSize: 20, margin: 5, flex: 1 }}>Email </Text>
        //             <TextInput
        //                 style={{ height: 40, borderColor: 'gray', borderWidth: 1, padding: 5, flex: 2 }}
        //                 onChangeText={(full_name) => this.setState({ full_name })}
        //                 value={this.state.email}
        //             />
        //         </View>
        //         <View style={{ height: 50, flexDirection: 'row' }}>
        //             <Text style={{ fontSize: 20, margin: 5, flex: 1 }}>Mobile phone </Text>
        //             <TextInput
        //                 style={{ height: 40, borderColor: 'gray', borderWidth: 1, padding: 5, flex: 2, margin: 10 }}
        //                 onChangeText={(no_tlp) => this.setState({ no_tlp })}
        //                 value={this.state.no_tlp}
        //             />
        //         </View>
        //         <View style={{ flexDirection: 'row', top: 0, margin: 10, }}>
        //             <View style={{ flex: 1, margin: 5 }}>
        //                 <Button title="Save" onPress={() => this.saveData()}></Button>
        //             </View>
        //             <View style={{ flex: 1, margin: 5 }}>
        //                 <Button title="Cancel"></Button>
        //             </View>
        //         </View>
        //     </View>
    
        // </View>