import React from 'react';
import { View, Text, StyleSheet, Dimensions, Alert } from 'react-native';
import { Image } from 'react-native-elements';
import Axios from 'axios';
import { TouchableOpacity, ScrollView } from 'react-native-gesture-handler';
import HTML from 'react-native-render-html';
import { getStatusBarHeight } from 'react-native-status-bar-height';
import MyStatusBar from './MyStatusBar';
export default class NewsDetail extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            title: '',
            subtitle: '',
            image: '',
            content: '',
            image_height: 400,
            statusbar_height: 50
        }
    }

    componentDidMount() {
        try {
            const screenWidth = Math.round(Dimensions.get('window').width);
            const statusBarHeight = getStatusBarHeight();
            this.setState({
                image_height: screenWidth,
                statusbar_height: statusBarHeight
            })
            this.get_news_detail(this.props.route.params.slug)
        } catch (error) {
            Alert.alert('Error', +  error)
        }
       
    }

    get_news_detail(slug) {
        try {
            Axios.get('https://excelsocrm.ravintoladev.com/cms/v2/detail/' + slug).then(res => {
                const detail = res.data;
                this.setState({
                    title: detail.title,
                    subtitle: detail.subtitle,
                    image: detail.content_image,
                    content: detail.content,
                })
            })  
        } catch (error) {
           Alert.alert('Error:'+ error) 
        }
       

    }

    render() {
        // console.log(this.state.content)
        try {
            return (
                <View style={styles.container}>
                    <MyStatusBar />
                    <ScrollView style={styles.body}>
                        <View style={styles.image_container(this.state.image_height)}>
                            <Image style={styles.image(this.state.image_height)} source={this.state.image ? { uri: this.state.image } : null} />
                        </View>
                        <View style={styles.content}>
                            <Text style={styles.title}>{this.state.title}</Text>
                            <View style={{ backgroundColor: '#adadad', height: 1.5, flex: 1, marginBottom: 5 }} />
                            <HTML html={this.state.content} tagsStyles={{
                                p: { fontSize: 12, color: '#838383', fontFamily: 'Gotham-Light' },
                                blockquote: { backgroundColor: "#f1f1f1", padding: 12, paddingBottom: 0, marginTop: 0 },
                                li: { fontSize: 12, color: '#838383', fontFamily: 'Gotham-Light', marginBottom : 0 },
                                ul: { fontSize: 12, color: '#838383', fontFamily: 'Gotham-Light', marginVertical: 5, marginBottom : -10 },
    
                            }}
                                ignoredTags={['br']}
                                ignoredStyles={['font-family','&nbsp;', '&amp;']} />
                        </View>
                    </ScrollView>
                </View>
            ) 
        } catch (error) {
            Alert.alert('Error' + error)
        }
       
    }
}


const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {
        height: 60,
        paddingHorizontal: 5,
        flexDirection: 'row',
        backgroundColor: '#CFB368',
        alignItems: 'center'
    },
    headerTitle: {
        flex: 1,
        textAlign: 'center',
        margin: 20,
        fontSize: 23,
        alignSelf: 'center',
        color: 'white',
        fontFamily: 'Gotham-Black'
    },
    image_container: (height) => ({
        height: height,
        backgroundColor: 'gray'
    }),
    image: (height) => ({
        width: '100%',
        height: height
    }),
    title: {
        textAlign: 'center',
        fontFamily: 'Gotham-Black',
        fontSize: 22,
        marginBottom: 10,
        color: '#CFB368'
    },
    content: {
        paddingHorizontal: 25,
        paddingVertical: 30
    },
    body: {
    }
})

