import Axios from 'axios';
import React from 'react';
import { Alert, StyleSheet, View } from 'react-native';
import { ScrollView } from 'react-native-gesture-handler';
import Spinner from 'react-native-loading-spinner-overlay';
import HTML from 'react-native-render-html';
import MyStatusBar from './MyStatusBar';
import { connect } from 'react-redux';

class PrivacyStatement extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            contentID: '',
            contentEN: '',
            spinner: true,
        }
    }

    componentDidMount() {
        try {
            this.getPrivacyStatement()
        } catch (error) {
            Alert.alert('Error', +  error)
        }
        console.log(this.props.language)

    }

    getPrivacyStatement() {
        try {
            Axios.get('https://excelsocrm.ravintoladev.com/cms/v2/detail/privacy-statement').then(res => {
                // console.log('ini res data nya : ' + JSON.stringify(res.data))
                const respon = res.data
                this.setState({
                    contentID: respon.content,
                    contentEN: respon.content2,
                    spinner: false
                })
            })
        } catch (error) {
            Alert.alert('Error:' + error)
        }


    }

    render() {
        // console.log(this.state.content)
        try {
            return (
                <View style={styles.container}>
                    <MyStatusBar />
                    <Spinner
                        visible={this.state.spinner}
                        textContent={'Loading...'}
                        textStyle={{ color: 'white' }}
                        animation={'fade'}
                        color={'white'}
                        overlayColor={'#838383'}
                    />
                    <ScrollView style={styles.body}>
                        {/* <View style={styles.image_container(this.state.image_height)}>
                            <Image style={styles.image(this.state.image_height)} source={this.state.image ? { uri: this.state.image } : null} />
                        </View> */}
                        <View style={styles.content}>
                            {
                                this.props.language == 'en' ? (
                                    <HTML html={this.state.contentEN} tagsStyles={{
                                        p: { fontSize: 12, color: '#838383', fontFamily: 'Gotham-Light', marginVertical: 1.5 },
                                        blockquote: { backgroundColor: "#f1f1f1", padding: 12, paddingBottom: 0, marginTop: 0 },
                                        li: { fontSize: 12, color: '#838383', fontFamily: 'Gotham-Light', marginBottom: 0 },
                                        ul: { fontSize: 12, color: '#838383', fontFamily: 'Gotham-Light', marginVertical: 5, marginBottom: -10 },

                                    }}
                                        ignoredTags={['br']}
                                        ignoredStyles={['font-family', '&nbsp;', '&amp;']} />
                                ) : (
                                    <HTML html={this.state.contentID} tagsStyles={{
                                        p: { fontSize: 12, color: '#838383', fontFamily: 'Gotham-Light', marginVertical: 1.5 },
                                        blockquote: { backgroundColor: "#f1f1f1", padding: 12, paddingBottom: 0, marginTop: 0 },
                                        li: { fontSize: 12, color: '#838383', fontFamily: 'Gotham-Light', marginBottom: 0 },
                                        ul: { fontSize: 12, color: '#838383', fontFamily: 'Gotham-Light', marginVertical: 5, marginBottom: -10 },

                                    }}
                                        ignoredTags={['br']}
                                        ignoredStyles={['font-family', '&nbsp;', '&amp;']} />
                                )
                            }

                        </View>
                    </ScrollView>
                </View>
            )
        } catch (error) {
            Alert.alert('Error' + error)
        }

    }
}


const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {
        height: 60,
        paddingHorizontal: 5,
        flexDirection: 'row',
        backgroundColor: '#CFB368',
        alignItems: 'center'
    },
    headerTitle: {
        flex: 1,
        textAlign: 'center',
        margin: 20,
        fontSize: 23,
        alignSelf: 'center',
        color: 'white',
        fontFamily: 'Gotham-Black'
    },
    image_container: (height) => ({
        height: height,
        backgroundColor: 'gray'
    }),
    image: (height) => ({
        width: '100%',
        height: height
    }),
    title: {
        textAlign: 'center',
        fontFamily: 'Gotham-Black',
        fontSize: 22,
        marginBottom: 10,
        color: '#CFB368'
    },
    content: {
        paddingHorizontal: 25,
        paddingVertical: 30
    },
    body: {
    }
})

const mapStateToProps = (state) => {
    return {
        language: state.language,
    }
}

export default connect(mapStateToProps)(PrivacyStatement);

