import React from 'react';
import { View, Text, Image, StyleSheet, Platform, ScrollView, Alert, TouchableOpacity, ActivityIndicator, StatusBar } from 'react-native';
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux';
import Axios from 'axios';
import moment from 'moment'
import i18n from 'i18n-js';
import requestParams from '../helper/requestParams';
import CustomIosStatusBar from './CustomIosStatusBar';

class RewardsList extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            rewardsList: [],
            indicator: true
        }
    }

    componentDidMount() {
        // console.log("INI YA REWARD URL :"+this.props.BASE_URL)

        try {
            this.getRewardsList()
            this._unsubscribe = this.props.navigation.addListener('focus', () => {
                this.setState({
                    indicator: true
                })
                this.getRewardsList()
    
            });
        } catch (error) {
            Alert.alert('Error : ', + error)
        }
       
    }

    componentWillUnmount() {
        try {
            
        this._unsubscribe()
        } catch (error) {
         Alert.alert('Error : ' + error);    
        }
    }

    getRewardsList() {
        try {
            let params = Object.assign(requestParams,{
                session_id: this.props.session_id,
              })
            Axios.post(this.props.BASE_URL+'crm/v2/reward/get_list', params).then(res => {
                let data = res.data.rewards
                console.log(data)
                data.map((item, key) => {
                    // console.log(item.expire_time)
                    item.expire_time = moment(item.expire_time).format("DD MMMM YYYY")
                })
                // console.log(data)
                this.setState({
                    rewardsList: data,
                    indicator: false
                })
    
            }).catch(error => {
                let response = error.response.data;
                Alert.alert(response.status, response.msg);
            })
        } catch (error) {
            Alert.alert('Error : ' + error);
        }
       
    }

    render() {
        try {
            return (
                <View style={styles.container}>
                    <StatusBar backgroundColor='#CFB368' />
                    <View style={styles.header}>
                        <Text style={{ color: 'white', textAlign: 'center', fontSize: 20, fontFamily: 'Gotham-Black' }}>{i18n.t('titlerewardhistory')}</Text>
                    </View>
                    <ScrollView style={styles.body}>
                        {
                            this.state.indicator ? (<ActivityIndicator style={{ top: 20, justifyContent: "center" }} size="large" color="#c9af6d" />) : (
                                this.state.rewardsList.length ? (
                                    this.state.rewardsList.map((item, key) => (
                                        <TouchableOpacity key={key} onPress={() => this.props.navigation.navigate('Reward Detail', { rewardId: item.id })}>
                                            <View style={{ alignItems: 'center' }}>
                                                <Card style={{ padding: 5, margin: 5 }}>
                                                    <View>
                                                        <Image source={{ uri: item.reward.title_image }}
                                                            resizeMethod="resize"
                                                            resizeMode='cover'
                                                            style={{ height: 100, width: '100%' }} />
                                                    </View>
                                                    <View style={{ flex: 1, flexDirection: 'row', justifyContent: 'space-between', padding: 10 }}>
                                                        <View style={{ flex: 0.6 }}>
                                                            <Text style={{ textAlign: 'left', fontSize: 12, fontFamily: 'Gotham-Black', color: '#838383' }}>{item.reward.title}</Text>
                                                            <Text style={{ textAlign: 'left', fontSize: 12, fontFamily: 'Gotham-Light', color: '#838383' }}>{item.reward.subtitle}</Text>
                                                        </View>
                                                        <View style={{ flex: 0.4 }}>
                                                            <Text style={{ textAlign: 'right', fontSize: 12, fontFamily: 'Gotham-Light', color: '#838383' }}>{i18n.t('expired')}</Text>
                                                            <Text style={{ textAlign: 'right', fontSize: 12, fontFamily: 'Gotham-Light', color: '#838383' }}>{item.expire_time}</Text>
                                                        </View>
                                                    </View>
                                                </Card>
                                            </View>
                                        </TouchableOpacity>
                                    ))
                                ) : (
                                        <View style={{ justifyContent: 'center', alignItems: 'center', height: 100 }}>
                                            <Text style={{ textAlign: 'left', fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>{i18n.t('emptyvoucherlist')}</Text>
                                        </View>
                                    ))
                        }
                        <TouchableOpacity style={{ marginVertical: 20 }} onPress={() => this.props.navigation.navigate('Reward History')}>
                            <Text style={{ textAlign: 'center', color: '#CFB368', fontSize: 12, fontFamily: 'Gotham-Black' }}>{i18n.t('rewardhistory')}</Text>
                        </TouchableOpacity>
                        <View style={{ height: 15 }} />
                    </ScrollView>
                </View>
            )
        } catch (error) {
            Alert.alert('ERROR :' + error)
        }
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {
        flex: 0.1,
        paddingTop: StatusBar.currentHeight,
        backgroundColor: '#CFB368',
        justifyContent: 'center'
    },

    body: {
        flex: 3,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,
        language: state.language,
        BASE_URL: state.BASE_URL,

    }
}

export default connect(mapStateToProps)(RewardsList);