import React from 'react';
import { View, Text, TextInput, StyleSheet, ScrollView, Alert, TouchableOpacity, ActivityIndicator } from 'react-native';
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux';
import Axios from 'axios';
import moment from 'moment'
import MyStatusBar from './MyStatusBar';
import NumberFormat from 'react-number-format';
import i18n from 'i18n-js';

class TransactionHistory extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            history_list: [],
            indicator: true
        }
    }

    componentDidMount() {
        console.log(this.props.session_id)
        this.getTransactionHistory()
        this._unsubscribe = this.props.navigation.addListener('focus', () => {

            this.setState({
                indicator: true,
            })
            this.getTransactionHistory()


        });
    }

    componentWillUnmount() {
        this._unsubscribe();
    }

    getTransactionHistory() {
        let params = {
            session_id: this.props.session_id
        }
        Axios.post(this.props.BASE_URL+'crm/v2/transaction/history', params).then(res => {
            let data = res.data.transactions
            console.log(data)
            data.map((item) => {
                item.transactions.map((i) => {
                    if (i.trans_status_display == 'On Queue') {
                        i.trans_status_display = 'Queueing'
                    } else
                        if (i.trans_status_display == 'On Process') {
                            i.trans_status_display = 'Processing'
                        } else
                            if (i.trans_status_display == 'Ready to Pickup') {
                                i.trans_status_display = 'Ready for Pickup'
                            } else
                                if (i.trans_status_display == 'On Delivery') {
                                    i.trans_status_display = 'Delivering'
                                } else
                                    if (i.trans_status_display == 'On Completed') {
                                        i.trans_status_display = 'Completed'
                                    } else
                                        if (i.trans_status_display == 'Cancelled') {
                                            i.trans_status_display = 'Cancelled'
                                        }
                })
            })

            // console.log(data)

            this.setState({
                history_list: data,
                indicator: false
            })
            console.log('ini res history' + JSON.stringify(this.state.history_list))

        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.msg);
            this.setState({
                indicator: false,
            })
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <MyStatusBar />
                <ScrollView style={styles.body}>
                    {this.state.indicator == true ? (<ActivityIndicator style={{ justifyContent: "center" }} size="large" color="#c9af6d" />) :
                        this.state.history_list.length ? (
                            this.state.history_list.map((item) => (

                                item.transactions.map((i, k) => (

                                    i.type == 1 ? (
                                        <View style={{ marginTop: 5 }} key={k}>
                                            <View style={{ flex: 2, height: 120, margin: 5, borderRadius: 5, borderWidth: 1, borderColor: '#838383', flexDirection: 'row' }}>
                                                <View style={{ flex: 1.1, justifyContent: 'center', margin: 10 }}>
                                                    <Text style={{ fontFamily: 'Gotham-Black', color: 'grey', fontSize: 12, margin: 2 }}>{i.type_display}</Text>
                                                    <Text style={{ fontFamily: 'Gotham-Light', color: 'grey', fontSize: 12, margin: 2 }}>{moment(i.trans_time).format("DD MMMM YYYY, hh:mm A")}</Text>
                                                </View>
                                                <View style={{ flex: 0.9, justifyContent: 'center', alignItems: 'center', margin: 10, marginLeft: 15, borderLeftWidth: 1, borderColor: '#838383' }}>
                                                    <View>
                                                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 12 }}></Text>
                                                    </View>
                                                </View>
                                            </View>
                                        </View>
                                    ) :

                                        i.type == 2 ? (
                                            <TouchableOpacity key={k} onPress={() => this.props.navigation.navigate('Order Detail', { idTrans: i.id })}>
                                                <View style={{ marginTop: 5 }} key={k}>
                                                    <View style={{ flex: 2, height: 120, margin: 5, borderRadius: 5, borderWidth: 1, borderColor: '#838383', flexDirection: 'row' }}>
                                                        <View style={{ flex: 1.1, justifyContent: 'center', margin: 10 }}>
                                                            <Text style={{ fontFamily: 'Gotham-Black', color: 'grey', fontSize: 12, margin: 2 }}>{i.outlet}</Text>
                                                            <Text style={{ fontFamily: 'Gotham-Light', color: 'grey', fontSize: 12, margin: 2 }}>{moment(i.trans_time).format("DD MMMM YYYY, hh:mm A")}</Text>
                                                            <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 12, margin: 2 }}>{i.trans_type_display}</Text>
                                                            <TouchableOpacity onPress={() => this.props.navigation.navigate('Order Detail', { idTrans: i.id })}>
                                                                <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', justifyContent: 'center', marginVertical: 5 }}>
                                                                    <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 12, textAlign: 'center', paddingHorizontal: 5 }}>{i18n.t('seeOrderDetail')}</Text>
                                                                </View>
                                                            </TouchableOpacity>
                                                        </View>
                                                        <View style={{ flex: 0.9, justifyContent: 'center', alignItems: 'center', margin: 10, marginLeft: 15, borderLeftWidth: 1, borderColor: '#838383' }}>
                                                            <View>
                                                                <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 12 }}>{i.trans_status_display}</Text>
                                                            </View>
                                                        </View>
                                                    </View>
                                                </View>
                                            </TouchableOpacity>
                                        ) :

                                            i.type == 3 ? (
                                                <View style={{ marginTop: 5 }} key={k}>
                                                    <View style={{ flex: 2, height: 120, margin: 5, borderRadius: 5, borderWidth: 1, borderColor: '#838383', flexDirection: 'row' }}>
                                                        <View style={{ flex: 1.1, justifyContent: 'center', margin: 10 }}>
                                                            <Text style={{ fontFamily: 'Gotham-Black', color: 'grey', fontSize: 12, margin: 2 }}>{i.type_display}</Text>
                                                            <Text style={{ fontFamily: 'Gotham-Light', color: 'grey', fontSize: 12, margin: 2 }}>{moment(i.trans_time).format("DD MMMM YYYY, hh:mm A")}</Text>
                                                        </View>
                                                        <View style={{ flex: 0.9, justifyContent: 'center', alignItems: 'center', margin: 10, marginLeft: 15, borderLeftWidth: 1, borderColor: '#838383' }}>
                                                            <View>
                                                                <NumberFormat decimalScale={0} value={i.point_add} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: '#CFB368' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                                            </View>
                                                        </View>
                                                    </View>
                                                </View>
                                            ) :

                                                i.type == 4 ? (
                                                    <View style={{ marginTop: 5 }} key={k}>
                                                        <View style={{ flex: 2, height: 120, margin: 5, borderRadius: 5, borderWidth: 1, borderColor: '#838383', flexDirection: 'row' }}>
                                                            <View style={{ flex: 1.1, justifyContent: 'center', margin: 10 }}>
                                                                <Text style={{ fontFamily: 'Gotham-Black', color: 'grey', fontSize: 12, margin: 2 }}>{i.type_display}</Text>
                                                                <Text style={{ fontFamily: 'Gotham-Light', color: 'grey', fontSize: 12, margin: 2 }}>{moment(i.trans_time).format("DD MMMM YYYY, hh:mm A")}</Text>
                                                            </View>
                                                            <View style={{ flex: 0.9, justifyContent: 'center', alignItems: 'center', margin: 10, marginLeft: 15, borderLeftWidth: 1, borderColor: '#838383' }}>
                                                                <View>
                                                                    <NumberFormat decimalScale={0} value={i.kaspro_point_add} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: '#CFB368' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                                                </View>
                                                            </View>
                                                        </View>
                                                    </View>
                                                ) :

                                                    i.type == 5 ? (
                                                        <View style={{ marginTop: 5 }} key={k}>
                                                            <View style={{ flex: 2, height: 120, margin: 5, borderRadius: 5, borderWidth: 1, borderColor: '#838383', flexDirection: 'row' }}>
                                                                <View style={{ flex: 1.1, justifyContent: 'center', margin: 10 }}>
                                                                    <Text style={{ fontFamily: 'Gotham-Black', color: 'grey', fontSize: 12, margin: 2 }}>{i.type_display}</Text>
                                                                    <Text style={{ fontFamily: 'Gotham-Light', color: 'grey', fontSize: 12, margin: 2 }}>{moment(i.trans_time).format("DD MMMM YYYY, hh:mm A")}</Text>
                                                                </View>
                                                                <View style={{ flex: 0.9, justifyContent: 'center', alignItems: 'center', margin: 10, marginLeft: 15, borderLeftWidth: 1, borderColor: '#838383' }}>
                                                                    <View>
                                                                        <NumberFormat decimalScale={0} value={i.point_reduce} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: '#CFB368' }}>- Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                                                    </View>
                                                                </View>
                                                            </View>
                                                        </View>
                                                    ) :

                                                        i.type == 6 ? (
                                                            <View style={{ marginTop: 5 }} key={k}>
                                                                <View style={{ flex: 2, height: 120, margin: 5, borderRadius: 5, borderWidth: 1, borderColor: '#838383', flexDirection: 'row' }}>
                                                                    <View style={{ flex: 1.1, justifyContent: 'center', margin: 10 }}>
                                                                        <Text style={{ fontFamily: 'Gotham-Black', color: 'grey', fontSize: 12, margin: 2 }}>{i.type_display}</Text>
                                                                        <Text style={{ fontFamily: 'Gotham-Light', color: 'grey', fontSize: 12, margin: 2 }}>{moment(i.trans_time).format("DD MMMM YYYY, hh:mm A")}</Text>
                                                                    </View>
                                                                    <View style={{ flex: 0.9, justifyContent: 'center', alignItems: 'center', margin: 10, marginLeft: 15, borderLeftWidth: 1, borderColor: '#838383' }}>
                                                                        <View>
                                                                            <NumberFormat decimalScale={0} value={i.point_add} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: '#CFB368' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                                                        </View>
                                                                    </View>
                                                                </View>
                                                            </View>
                                                        ) : (
                                                                <View style={{ marginTop: 5 }} key={k}>
                                                                    <View style={{ flex: 2, height: 120, margin: 5, borderRadius: 5, borderWidth: 1, borderColor: '#838383', flexDirection: 'row' }}>
                                                                        <View style={{ flex: 1.1, justifyContent: 'center', margin: 10 }}>
                                                                            <Text style={{ fontFamily: 'Gotham-Black', color: 'grey', fontSize: 12, margin: 2 }}>{i.type_display}</Text>
                                                                            <Text style={{ fontFamily: 'Gotham-Light', color: 'grey', fontSize: 12, margin: 2 }}>{moment(i.trans_time).format("DD MMMM YYYY, hh:mm A")}</Text>
                                                                        </View>
                                                                        <View style={{ flex: 0.9, justifyContent: 'center', alignItems: 'center', margin: 10, marginLeft: 15, borderLeftWidth: 1, borderColor: '#838383' }}>
                                                                            <View>
                                                                                <NumberFormat decimalScale={0} value={i.point_reduce} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: '#CFB368' }}>- Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                                                            </View>
                                                                        </View>
                                                                    </View>
                                                                </View>
                                                            )
                                ))
                            ))
                        ) : (
                                <View style={{ justifyContent: 'center', alignItems: 'center', height: 100 }}>
                                    <Text style={{ textAlign: 'left', fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>{i18n.t('noTransHistoryData')}</Text>
                                </View>
                            )
                    }
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {

        flex: 0.2,
    },

    body: {
        flex: 3,
        margin: 10,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {
        
        session_id: state.session_id,
        BASE_URL: state.BASE_URL
    }
}

export default connect(mapStateToProps)(TransactionHistory);