import React from 'react';
import {
    View,
    StyleSheet,
    Text,
    StatusBar,
    Image,
    ScrollView,
    TouchableOpacity,
    Alert,
    Button,
    ImageBackground
} from 'react-native';

import { StackActions } from '@react-navigation/native';
import { Icon } from 'react-native-elements'
import { connect } from 'react-redux';
import { Card } from 'react-native-shadow-cards';
import ActionType from '../redux/globalActionType';
import { CommonActions } from '@react-navigation/native';
import { Ionicons, MaterialIcons, AntDesign, FontAwesome } from '@expo/vector-icons';
import Axios from 'axios';
import * as Location from 'expo-location';
import * as Permissions from 'expo-permissions';
import * as Device from 'expo-device';
import session from '../function/session';

class Account extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            email: "",
            points: "",
            balance: "",
            img_card: "",
            member_since: "",
            account_number: "",
            expire_date: "",
            premium: "",
            my_lat: 0,
            my_long: 0,
            full_name: ''
        }
    }

    componentDidMount() {

        this._getProfile()
        this._unsubscribe = this.props.navigation.addListener('focus', () => {
            this._getProfile()
        });
    }

    componentWillUnmount() {
        this._unsubscribe();
    }

    _getPermissions = async () => {
        let { status } = await Permissions.askAsync(Permissions.LOCATION);
        if (status !== 'granted') {
            Alert.alert('Akses tidak dizinkan!')
        } else if (Platform.OS === 'android' && !Device.isDevice) {

            Alert.alert('Silahkan anda coba di real Device')
        } else {
            this._getCurrentPosisition()
        }
    }
    _getCurrentPosisition = async () => {
        this.setState({
            spinner: true,
        })
        let location = await Location.getCurrentPositionAsync({
            accuracy: Location.Accuracy.Highest
        })

        let latitude = location.coords.latitude;
        let longitude = location.coords.longitude;

        this.setState({
            my_lat: latitude,
            my_long: longitude
        })

        this._getProfile()
    }

    logout() {

        let configProps = {
            session_id: ''
        }
        this.props.setConfig(configProps);
        this.props.navigation.replace('Login');
    }

    _getProfile() {
        let params = {
            session_id: this.props.session_id,
            lat: this.state.my_lat,
            long: this.state.my_long,
            closest_outlet: 1

        }

        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/member/get_profile', params).then(res => {
            const dataCard = res.data
            let email = dataCard.email
            let point = dataCard.kaspro_point
            let balance = dataCard.kaspro_balance
            let img_card = dataCard.card_series_image
            let member_since = dataCard.member_since
            let expire = dataCard.expire_date
            let premium = dataCard.kaspro_is_premium
            let kaspro = dataCard.kaspro_account_number
            let full_name = dataCard.name

            if (kaspro === "") {

                let cardProps = {
                    set_card: false

                }

                this.props.setCardactive(cardProps)
            } else {
                let cardProps = {
                    set_card: true
                }
                this.props.setCardactive(cardProps)
            }

            let account_number = dataCard.card_number

            this.setState({
                email: email,
                points: point,
                img_card: img_card,
                member_since: member_since,
                balance: balance,
                account_number: account_number,
                img_card: img_card,
                expire_date: expire,
                premium: premium,
                full_name: full_name
            })

        }).catch(error => {
            const { navigation } = this.props
            let response = error.response.data
            session(response, navigation)
            Alert.alert(response.msg);
            console.log('ini error ' + error)
        })
    }

    TransferBalance() {

        if (this.state.premium === false) {
            Alert.alert(
                'Akun Belum Premium',
                'Apakah anda ingin Upgrade Premium ?',

                [{ text: 'Cancel' },
                { text: 'OK', onPress: () => this.props.navigation.navigate('Upgrade Premium') }
                ]
            )
        } else {
            this.props.navigation.navigate('Transfer Balance');
        }
    }


    render() {
        const navigation = this.props.navigation
        return (
            <View style={styles.container}>
                <ScrollView>
                    <View style={{ flex: 1, height: 90, top: 30 }}>
                        <View style={{ alignSelf: 'center' }}>
                            <Image
                                style={{ height: 70, width: 70, top: 5, justifyContent: 'center' }}
                                source={require('../assets/images/people-actv.png')}
                            />
                        </View>
                        <Text style={{ fontFamily: 'Gotham-Black', color: 'grey', fontSize: 17, textAlign: 'center', top: 5 }}>
                            {/* {this.state.full_name} */}
                        </Text>
                        <View style={{ height: 90, flexDirection: 'row', justifyContent: 'center' }}>

                            <TouchableOpacity style={{ flexDirection: 'row' }} onPress={() => this.props.navigation.navigate('Profile')}>

                                <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 17, textAlign: 'center', top: 10 }}>
                                {this.state.full_name}
                                </Text>
                                <Icon
                                    containerStyle={{ margin: 5 }}
                                    name='ios-create'
                                    type='ionicon'
                                    color='#CFB368'
                                />
                            </TouchableOpacity>
                        </View>
                    </View>
                    {
                        this.props.set_card === false ? (
                            <View style={{ marginTop: 65 }}>
                                <View style={{ flex: 1, backgroundColor: 'grey', height: 250, borderRadius: 20, marginRight: 10, marginLeft: 10,justifyContent:'center' }}>
                                <View style={{justifyContent:'center'}}>
                                <TouchableOpacity onPress={() => this.props.navigation.navigate('Card Activation')}>
                                            <View style={{ height: 50, borderRadius: 20, backgroundColor: 'white', marginRight: 20, marginLeft: 20, }}>
                                                <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 15 }}>ACTIVATE CARD</Text>
                                            </View>
                                        </TouchableOpacity>
                                </View>
                               
                                </View>
                                <View style={{ flex: 1, height: 250 }}>
                                    <TouchableOpacity style={{ top: 20, marginLeft: 10, marginRight: 10, justifyContent: 'center' }} onPress={() => this.logout()}>
                                        <View style={{ height: 40, borderRadius: 20, backgroundColor: '#CFB368', justifyContent: 'center' }}>
                                            <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 20, textAlign: 'center', margin: 15 }}>LOGOUT</Text>
                                        </View>
                                    </TouchableOpacity>
                                    <View style={styles.v_logo}>
                                        <View style={{ flex: 1, alignSelf: 'flex-start',marginTop:20 }}>
                                            <Image resizeMode="contain" source={require('../assets/images/daun.png')} style={styles.logo}></Image>
                                        </View>
                                        <View style={{ flex: 1 }}>

                                        </View>
                                    </View>
                                </View>
                            </View>
                        ) : (
                                <View>
                                    <View style={styles.Card}>
                                        <View style={styles.card}>
                                            <Card style={{ padding: 20, alignContent: 'center' }}>

                                                <View style={{ flexDirection: 'row', flex: 1, paddingBottom: 5 }}>
                                                    <View style={{ flex: 0.5 }}>
                                                        <Text style={{ fontSize: 10, fontFamily: 'Gotham-Light' }}>YOUR CARD NUMBER</Text>
                                                    </View>
                                                    <View style={{ flex: 0.5 }}>
                                                        <Text style={{ fontSize: 10, textAlign: 'right', fontFamily: 'Gotham-Light' }}>Expired At {this.state.expire_date}</Text>
                                                    </View>
                                                </View>
                                                <View style={{ paddingHorizontal: 10 }}>
                                                    <Text style={{ textAlign: "center", fontSize: 30, color: '#c9af6d', fontFamily: 'Gotham-Black' }}>
                                                        {this.state.account_number}
                                                    </Text>
                                                </View>
                                                <View style={styles.line}></View>


                                                <View style={{ flexDirection: 'row', flex: 1 }}>
                                                    <View style={{ flex: 0.2, justifyContent: 'center' }}>
                                                        {/* <Text>{i18n.t('balance')}</Text> */}
                                                        <Text style={{ fontSize: 10, fontFamily: 'Gotham-Light' }}>BALANCE</Text>
                                                    </View>
                                                    <View style={{ flex: 0.8, alignItems: 'center' }}>
                                                        <Text style={{ fontSize: 20, fontFamily: 'Gotham-Black', color: 'gray' }}>IDR {this.state.balance}</Text>
                                                    </View>
                                                </View>

                                                <View style={styles.line2}></View>
                                                <View style={{ flexDirection: 'row', flex: 1 }}>
                                                    <View style={{ flex: 0.2, justifyContent: 'center' }}>
                                                        {/* <Text>{i18n.t('balance')}</Text> */}
                                                        <Text style={{ fontSize: 10, fontFamily: 'Gotham-Light' }}>POINTS</Text>
                                                    </View>
                                                    <View style={{ flex: 0.8, alignItems: 'center' }}>
                                                        <Text style={{ fontSize: 20, fontFamily: 'Gotham-Black', color: 'gray' }}>IDR {this.state.points}</Text>
                                                    </View>
                                                </View>
                                            </Card>
                                        </View>
                                    </View>
                                    <TouchableOpacity style={styles.submitTopUp} activeOpacity={.5} onPress={() => this.props.navigation.navigate('TopUpInfo')}>
                                        <Text style={{ fontFamily: 'Gotham-Black', color: '#fff', textAlign: 'center' }}>TOP UP BALANCE</Text>
                                    </TouchableOpacity>
                                    <View style={{ padding: 10, margin: 10, height: 200, top: 20 }}>
                                        <ImageBackground style={{ width: '100%', height: '100%', padding: 0, margin: 0 }} resizeMode='stretch' source={this.state.img_card ? { uri: this.state.img_card } : null}>
                                            <View style={{ justifyContent: 'center' }}>
                                                <Text style={{ fontFamily: 'Gotham-Black', margin: 15, fontSize: 20, color: '#c9af6d', top: 120 }}>
                                                    {this.state.account_number}
                                                </Text>
                                            </View>
                                        </ImageBackground>
                                    </View>
                                    <View style={{ flex: 1, flexDirection: 'row', justifyContent: 'center', top: 10 }}>
                                        <TouchableOpacity style={{ marginBottom: 10 }} onPress={() => this.TransferBalance()} >
                                            <Card style={{ height: 100, width: 160 }}>

                                                <View style={{ height: 50, alignItems: 'center' }}>
                                                    <MaterialIcons name="monetization-on" size={30} color="gray" style={{ top: 20 }} />
                                                    <Text style={{ fontFamily: 'Gotham-Black', textAlign: 'center', top: 30, fontSize: 14 }}>TRANSFER BALANCE</Text>
                                                </View>
                                            </Card>
                                        </TouchableOpacity>
                                        <View style={{ width: 5 }}></View>
                                        <TouchableOpacity>
                                            <Card style={{ height: 100, width: 160 }}>
                                                <View style={{ height: 50, alignItems: 'center' }}>
                                                    <AntDesign name="shoppingcart" size={30} color="gray" style={{ top: 20 }} />
                                                    <Text style={{ fontFamily: 'Gotham-Black', textAlign: 'center', top: 30, fontSize: 14 }}>BALANCE / POINT</Text>
                                                </View>
                                            </Card>
                                        </TouchableOpacity>
                                    </View>
                                    <View style={{ flex: 1, flexDirection: 'row', justifyContent: 'center', top: 10 }}>
                                        <TouchableOpacity onPress={() => this.props.navigation.navigate('Renewal')} style={{ marginBottom: 20 }}>
                                            <Card style={{ height: 100, width: 160 }}>
                                                <View style={{ height: 50, alignItems: 'center' }}>
                                                    <MaterialIcons name="autorenew" size={30} color="gray" style={{ top: 20 }} />
                                                    <Text style={{ fontFamily: 'Gotham-Black', textAlign: 'center', top: 30, fontSize: 14 }}>RENEWAL</Text>
                                                </View>
                                            </Card>
                                        </TouchableOpacity>
                                        <TouchableOpacity onPress={() => this.props.navigation.navigate('Transaction History')} style={{ marginBottom: 20, marginRight: 5, marginLeft: 5 }}>
                                            <Card style={{ height: 100, width: 160 }}>
                                                <View style={{ height: 50, alignItems: 'center' }}>
                                                    <MaterialIcons name="autorenew" size={30} color="gray" style={{ top: 20 }} />
                                                    <Text style={{ fontFamily: 'Gotham-Black', textAlign: 'center', top: 30, fontSize: 14 }}>TRANSACTION HISTORY</Text>
                                                </View>
                                            </Card>
                                        </TouchableOpacity>
                                    </View>
                                    <View style={{ flex: 1, flexDirection: 'row', justifyContent: 'center', top: 10 }}>
                                        {this.state.premium === false ? (
                                            <TouchableOpacity onPress={() => this.props.navigation.navigate('Upgrade Premium')} style={{ marginBottom: 20, marginRight: 5, marginLeft: 5 }}>
                                                <Card style={{ height: 100, width: 160 }}>
                                                    <View style={{ height: 50, alignItems: 'center' }}>
                                                        <MaterialIcons name="autorenew" size={30} color="gray" style={{ top: 20 }} />
                                                        <Text style={{ fontFamily: 'Gotham-Black', textAlign: 'center', top: 30, fontSize: 14 }}>UPGRADE PREMIUM</Text>
                                                    </View>
                                                </Card>
                                            </TouchableOpacity>
                                        ) : (
                                                null
                                            )}
                                    </View>
                                    <View style={{ flex: 1 }}>
                                        <TouchableOpacity onPress={() => this.logout()}>
                                            <View style={{ height: 50, borderRadius: 20, backgroundColor: '#CFB368', margin: 20 }}>
                                                <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 20, textAlign: 'center', margin: 15 }}>LOGOUT</Text>
                                            </View>
                                        </TouchableOpacity>

                                    </View>
                                </View>
                            )
                    }
                </ScrollView>

            </View>
        )
    }
}

Account.navigationOptions = {
    header: null,
};

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: 'white',
        alignItems: 'stretch',
    },
    profil: {
        height: 150,
        backgroundColor: 'white',
        alignItems: 'center',
        top: 40,
    },

    Card: {
        top: 50,
        alignItems: 'center',
        alignContent: 'center',
    },

    card: {
        top: 20,
        flex: 1,
        alignItems: 'center'
    },

    line: {
        top: 3,
        borderRadius: 1,
        borderColor: 'black',
        borderWidth: 1,
        width: "100%",
        height: 1,
        bottom: 5,

    },
    line1: {
        top: 3,
        borderRadius: 1,
        borderColor: 'black',
        borderWidth: 1,
        width: "100%",
        height: 1,
        bottom: 5,

    },

    imgBackground: {
        width: '100%',
        height: '100%',
        flex: 1
    },
    submitTopUp: {
        marginTop: 70,
        top: 20,
        paddingTop: 15,
        paddingBottom: 15,
        marginLeft: 15,
        marginRight: 15,
        backgroundColor: '#c9af6d',
        borderRadius: 10,
        borderWidth: 0,
        borderColor: '#fff',
        textAlign: 'center',
    },
    logo: {
        alignSelf: 'flex-start',
        marginTop: 70,
        width: 290,
        height: 290,
        bottom: 145,

    },
    v_logo: {
        flex: 2,
        flexDirection: 'column-reverse',
        alignContent: 'flex-start',
    },

    line: {
        borderBottomColor: '#c9af6d',
        borderBottomWidth: 2,
        alignSelf: 'stretch',
        width: "100%",
        height: 10,
        bottom: 5,
    },
    line2: {
        borderBottomColor: '#c9af6d',
        borderBottomWidth: 1,
        alignSelf: 'stretch',
        width: "100%",
        height: 10,
        bottom: 5,
    },
})

//subscribe
const mapStateToProps = (state) => {
    return {
        session_id: state.session_id,
        set_card: state.set_card,
    }
}

const mapDispatchToProps = (dispacth) => {
    return {
        setConfig: (configProps) => dispacth({
            type: ActionType.SET_LOGOUT,
            data: {
                session_id: configProps.session_id
            }
        }),
        setCardactive: (cardProps) => dispacth({

            type: ActionType.SET_CARD,
            data: {
                set_card: cardProps.set_card,
            }
        }),
    }
}
export default connect(mapStateToProps, mapDispatchToProps)(Account);



{/* <TouchableOpacity onPress={() => this.props.navigation.navigate('Profile')} style={{ marginBottom: 10 }}>
<Card style={{ height: 100, width: 160 }}>
    <View style={{ height: 50, alignItems: 'center' }}>
        <MaterialIcons name="monetization-on" size={30} color="gray" style={{ top: 20 }} />
        <Text style={{ textAlign: 'center', top: 30, fontSize: 14 }}>PROFIL</Text>
    </View>
</Card>
</TouchableOpacity>
<View style={{ width: 5 }}></View>
<TouchableOpacity onPress={() => this.props.navigation.navigate('Card Activation')}>
<Card style={{ height: 100, width: 160 }}>
    <View style={{ height: 50, alignItems: 'center' }}>
        <AntDesign name="shoppingcart" size={30} color="gray" style={{ top: 20 }} />
        <Text style={{ textAlign: 'center', top: 30, fontSize: 14 }}>ACTIVATION CARD</Text>
    </View>
</Card>
</TouchableOpacity> */}




{/* <View style={{ flex: 1, flexDirection: 'row', justifyContent: 'center' }}>
                                    <View style={{ height: 250, flex: 1, backgroundColor: 'grey', marginRight: 20, marginLeft: 20, top: 25, borderRadius: 20 }}>
                                        <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 20, textAlign: 'center', top: 20 }}>No card yet</Text>
                                        <TouchableOpacity onPress={() => this.props.navigation.navigate('Card Activation')}>
                                            <View style={{ height: 50, borderRadius: 20, backgroundColor: 'white', marginRight: 20, marginLeft: 20, }}>
                                                <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 15 }}>ACTIVATE CARD</Text>
                                            </View>
                                        </TouchableOpacity>
                                    </View>
                                </View>
                                <View>
                                <TouchableOpacity style={{backgroundColor:'red',top:20}} onPress={() => this.logout()}>
                                    <View style={{ height: 40, borderRadius: 20, backgroundColor: '#CFB368' }}>
                                        <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 20, textAlign: 'center', margin: 15 }}>LOGOUT</Text>
                                    </View>
                                </TouchableOpacity>
                                </View> */}