import React from 'react';
import { View, Text, TextInput, StyleSheet, Button } from 'react-native';

export default class ConfirmMobile extends React.Component {
    render() {
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', marginTop: 10, fontSize: 25 }}>Confirm Mobile</Text>
                </View>
                <View style={styles.form}>
                    <View style={styles.field_email}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>Token</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 50, borderWidth: 1, padding: 5, margin: 10 }} />
                        </View>
                    </View>
                    <View style={styles.button}>
                        <Button title="Verify" onPress={() => this.submit()}></Button>
                    </View>
                    <View style={{ alignItems: 'center' }}>
                        <Text style={{ color: 'red' }}>Send SMS again in 0:30 </Text>
                    </View>
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    form: {
        flex: 3,
        margin: 10,
        marginTop: 0,
    },

    field_email: {
        flexDirection: 'row'
    },

    field_phone: {
        flexDirection: 'row'
    },


    button: {
        height: 50,
        margin: 10,

    }

})