import React from 'react';
import { View, Text, StyleSheet, ScrollView, TouchableOpacity, Image, TextInput,Modal } from 'react-native';
import { connect } from 'react-redux';
import ActionType from '../redux/globalActionType';
import NumberFormat from 'react-number-format';


class Item extends React.Component {

    constructor(props) {
        super(props)
        this.state = {
            value: 0
        }
    }
    handleChangeQuantity = (item, qty) => {

        if (qty == '') {
            item.qty = 0
        } else {

            const order_item = {
                id: item.id,
                code: item.code,
                name: item.name,
                description: item.description,
                note: 'jangan garing',
                image: item.image,
                price: parseInt(item.price),
            }

            this.props.changeQuantity({ item: order_item, quantity: qty })
            console.log("ini udah masuk sini");
        }
    }

    render() {
        const { item } = this.props
        // console.log("ini id itemnya "+item.id)
        return (
            <View style={{ flex: 1, margin: 10 }} key={item.id} ref={this.props._scrollView}>
                <ScrollView ref={view => this._scrollView = view}>
                    {item.code == 'CATEGORY' ? (
                        <Text style={{ fontSize: 15, color: '#c9af6d', fontFamily: 'Gotham-Black' }}>{item.name}</Text>
                    ) : (

                            <View style={{ flex: 1, flexDirection: 'row', height: 100 }}>
                                <View style={{ flex: 1, height: 100 }}>
                                <TouchableOpacity onPress={() => this.props.navigation.navigate('Menu Detail', {nameMenu:item.name,desc:item.description,image:item.image})}>
                                        <Image source={{ uri: item.image }} style={{ height: 100, width: 100, borderRadius: 10, }}></Image>
                                    </TouchableOpacity>
                                </View>
                                <View style={{ flex: 2, height: 150 }}>
                                    <View style={{ marginLeft: 5, marginRight: 5 }}>
                                        <Text style={{ fontSize: 15, margin: 5, marginRight: 10, fontFamily: 'Gotham-Black' }}>{item.name}</Text>
                                        <NumberFormat decimalScale={0} value={item.price} renderText={value => <Text style={{ fontSize: 12, margin: 5, marginRight: 10, fontFamily: 'Gotham-Black', color: 'grey' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                    </View>
                                    <View style={{ marginLeft: 5, marginRight: 5, flexDirection: 'row' }}>
                                        <View style={styles.shadowEdit}>
                                            <Image source={(require('../assets/icon/icon-pencil.png'))} style={{ height: 25, width: 25, marginLeft: 5, marginRight: 5 }}></Image>
                                        </View>
                                        <View style={styles.shadowAdd}>
                                            <TouchableOpacity onPress={() => this.props.handleMin()}>
                                                <Text style={{ fontSize:25,alignSelf:'center' }}> - </Text>
                                            </TouchableOpacity>
                                            <TextInput
                                                style={{  padding: 2, textAlign: 'center', fontFamily: 'Gotham-Black',fontSize:15,marginRight:5,marginLeft:5 }}
                                                keyboardType={'numeric'}
                                                onChangeText={(qty) => this.handleChangeQuantity(item, qty)}>{item.qty}</TextInput>
                                            <TouchableOpacity style={{alignSelf:'center'}} onPress={() => this.props.handleAdd()}>
                                                <Text style={{ fontSize: 25,alignSelf:'center' }}> + </Text>
                                            </TouchableOpacity>
                                        </View>
                                    </View>
                                </View>
                            </View>
                        )}
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    shadowEdit: {
        height: 30,
        width: 40,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 5,
    },
    shadowAdd: {
        height: 30,
        width: 90,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 5,
        flexDirection: 'row'
    },
    shadowMin: {
        height: 20,
        width: 20,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 5,
    }
})

const mapDispatchToProps = (dispacth) => {
    return {
        setChangeQuantity: (item) => dispacth({
            type: ActionType.CHANGE_TO_CHART,
            data: {
                item: item
            }
        }),
        changeQuantity: (params) => dispacth({
            type: ActionType.CHANGE_QUANTITY,
            data: {
                item: params.item,
                new_quantity: params.quantity
            }
        }),
    }
}
const mapStateToProps = (state) => {
    // console.log(state)
    return {
        session_id: state.session_id,
        outlet_id: state.outlet_id,
        order_quantity: state.order_quantity,
        order_total: state.order_total,
        quantity: state.quantity,
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(Item)
