import React from 'react';
import { View, Text, TextInput, StyleSheet, ScrollView, Alert, TouchableOpacity, BackHandler } from 'react-native';
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux';
import Axios from 'axios';
import session from '../function/session';
import moment from 'moment'
import { FontAwesome } from '@expo/vector-icons';

class OrderDetail extends React.Component {

    constructor(props) {
        super(props)
        this.handleBackButtonClick = this.handleBackButtonClick.bind(this)
        this.state = {
            trans_type_display: '',
            outlet: '',
            outlet_code: '',
            trans_status_display: '',
            transaction_detail: [],
            numberId: '',
            detail_trans: '',
        }


    }


    componentDidMount() {

        BackHandler.addEventListener('hardwareBackPress', this.handleBackButtonClick);
        this.getDetailTrans()

    }

    componentWillUnmount() {
        BackHandler.removeEventListener('hardwareBackPress', this.handleBackButtonClick);
    }


    handleBackButtonClick() {
        this.props.navigation.navigate('Home', { screen: 'ORDER' });
        return true;
    }

    getDetailTrans() {
        let params = {
            session_id: this.props.session_id,
            transaction_id: this.props.trans_id
        }
        // console.log("PARAMETER : " + JSON.stringify(params))
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/transaction/detail', params).then(res => {
            let data = res.data
            // console.log("INI OUTLET "+ data.outlet)
            // console.log("OUTLET-CODE" + data.outlet_code)
            // console.log("TRANS-DISPLAY" + data.trans_type_display)

            this.setState({
                outlet: data.outlet,
                outlet_code: data.outlet_code,
                trans_status_display: data.trans_status_display,
                transaction_detail: data.transaction_detail,
                detail_trans: data,
                numberId: data.id.substring(0, 5).toUpperCase()

            })
        }).catch(error => {
            const { navigation } = this.props
            let response = error.response.data
            session(response, navigation)
            Alert.alert(response.msg);
            this.setState({
                indicator: false,
            })
            // let response = error.response.data;
            // Alert.alert(response.msg);
        })
    }

    render() {
        // console.log(this.state.detail_trans)
        // console.log(this.state.detail_trans.used_reward)
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <Text style={{ fontSize: 16, fontFamily: 'Gotham-Light', textAlign: 'center' }}>#{this.state.numberId}</Text>
                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', textAlign: 'center' }}>{moment(this.state.detail_trans.trans_time).format('DD MMMM YYYY HH:mm:ss')}</Text>
                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', textAlign: 'center' }}>{this.state.detail_trans.trans_status_display}</Text>
                </View>
                <ScrollView style={styles.body}>

                    <View style={{ flex: 1, flexDirection: 'row', borderBottomWidth: 1, margin: 10, paddingBottom: 30, padding: 10 }}>
                        <View style={{ flex: 0.1, justifyContent: 'center' }}>
                            <FontAwesome name="map-marker" size={24} color="red" />
                        </View>
                        {
                            this.state.detail_trans.trans_type_display == 'Pick Up' ? (
                                <View style={{ flex: 0.6, justifyContent: 'center' }}>
                                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>{this.state.outlet}</Text>
                                </View>
                            ) : (
                                    <View style={{ flex: 0.6, justifyContent: 'center' }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>{this.state.recipient_address}</Text>
                                    </View>

                                )
                        }
                        {
                            this.state.detail_trans.trans_type_display == 'Pick Up' ? (
                                <View style={{ flex: 0.3, justifyContent: 'center' }}>
                                    <Text style={{ textAlign: 'right', fontSize: 12, fontFamily: 'Gotham-Light' }}>PICKUP</Text>
                                </View>
                            ) : (
                                    <View style={{ flex: 0.3, justifyContent: 'center' }}>
                                        <Text style={{ textAlign: 'right', fontSize: 12, fontFamily: 'Gotham-Light' }}>DELIVERY</Text>
                                    </View>

                                )
                        }
                    </View>
                    <View style={{ margin: 10, paddingLeft: 10 }}>
                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>Pesanan</Text>
                    </View>
                    {
                        this.state.transaction_detail.map((item, index) => {
                            // total = total + item.quantity * item.price
                            return (
                                <View style={{ margin: 10 }} key={index} >
                                    <View style={{ flex: 1, margin: 10, flexDirection: 'row', justifyContent: 'space-around' }}>
                                        <View style={{ flex: 0.3, alignItems: 'center' }}>
                                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>{item.item_quantity}</Text>
                                        </View>
                                        <View style={{ flex: 0.1, alignItems: 'flex-start' }}>
                                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>x</Text>
                                        </View>
                                        <View style={{ flex: 0.3, alignItems: 'baseline' }}>
                                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>{item.item_name} </Text>
                                        </View>
                                        <View style={{ flex: 0.3, alignItems: 'flex-end' }}>
                                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>{item.item_quantity * item.item_price} </Text>
                                        </View>
                                    </View>
                                </View>
                            )
                        })
                    }
                    {/* {
                        this.state.detail_trans.used_reward.length < 0 ? (
                            null
                        ) : (
                                <>
                                    <View style={{ borderTopWidth: 1, margin: 10, padding: 10 }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>Voucher</Text>
                                    </View>

                                    <View style={{ flexDirection: 'row', justifyContent: 'space-between', margin: 10, marginTop: -10 }}>
                                        <View style={{ margin: 10, paddingLeft: 10 }}>
                                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>{this.props.voucher.reward.title}</Text>
                                        </View>
                                        <TouchableOpacity onPress={() => this.props.navigation.navigate('Reward Detail', { rewardId: this.props.voucher.id })}>
                                            <View style={{ margin: 10, paddingRight: 5 }}>
                                                <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: '#CFB368' }}>View Detail</Text>
                                            </View>
                                        </TouchableOpacity>
                                    </View>
                                </>
                            )
                    } */}
                    <View style={{ borderTopWidth: 1, margin: 10, paddingLeft: 10, padding: 20, paddingBottom: -10 }}>
                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>Payment</Text>
                    </View>
                    <View style={{ flexDirection: 'row', justifyContent: 'space-between', margin: 10, marginTop: -10 }}>
                        <View style={{ margin: 10, paddingLeft: 10 }}>
                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>Balance Used</Text>
                        </View>
                        <View style={{ margin: 10, paddingRight: 5 }}>
                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>{this.state.detail_trans.trans_paid}</Text>
                        </View>
                    </View>
                    <View style={{ flexDirection: 'row', justifyContent: 'space-between', margin: 10, marginTop: -10 }}>
                        <View style={{ margin: 10, paddingLeft: 10 }}>
                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>Point Used</Text>
                        </View>
                        <View style={{ margin: 10, paddingRight: 5 }}>
                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>{this.state.detail_trans.point_booked}</Text>
                        </View>
                    </View>
                    <View style={{ borderTopWidth: 1, margin: 10, paddingLeft: 10, padding: 20, paddingBottom: -10, flexDirection: 'row', justifyContent: 'space-between', flex: 1, flexDirection: 'row' }}>
                        <View style={{ flex: 0.6 }}>
                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>Harga</Text>
                        </View>
                        <View style={{ flex: 0.4, marginRight: -5 }}>
                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', textAlign: 'right' }}>{this.state.detail_trans.trans_subtotal}</Text>
                        </View>
                    </View>
                    {
                        this.state.detail_trans.trans_discount == '' ? (
                            null
                        ) : (
                                <View style={{ margin: 10, marginTop: -10, paddingLeft: 10, padding: 20, paddingBottom: -10, flexDirection: 'row', justifyContent: 'space-between', flex: 1, flexDirection: 'row' }}>
                                    <View style={{ flex: 0.6 }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>Voucher</Text>
                                    </View>
                                    <View style={{ flex: 0.4, marginRight: -5 }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', textAlign: 'right' }}>- {this.state.detail_trans.trans_discount}</Text>
                                    </View>
                                </View>
                            )
                    }
                    {/* {
                        this.props.type_pickup == true ? (
                            null
                        ) : (
                                <View style={{ margin: 10, marginTop: -10, paddingLeft: 10, padding: 20, paddingBottom: -10, flexDirection: 'row', justifyContent: 'space-between', flex: 1, flexDirection: 'row' }}>
                                    <View style={{ flex: 0.6 }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>Ongkos Kirim</Text>
                                    </View>
                                    <View style={{ flex: 0.4, marginRight: -5 }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', textAlign: 'right' }}>{this.props.grabamount}</Text>
                                    </View>
                                </View>
                            )
                    } */}
                    <View style={{ margin: 10, marginTop: -10, paddingLeft: 10, padding: 20, paddingBottom: -10, flexDirection: 'row', justifyContent: 'space-between', flex: 1, flexDirection: 'row' }}>
                        <View style={{ flex: 0.6 }}>
                            <Text style={{ fontSize: 20, fontFamily: 'Gotham-Black', color: '#CFB368' }}>Total</Text>
                        </View>
                        <View style={{ flex: 0.4, marginRight: -5 }}>
                            <Text style={{ fontSize: 20, fontFamily: 'Gotham-Black', textAlign: 'right', color: '#CFB368' }}>{this.state.detail_trans.trans_total}</Text>
                        </View>
                    </View>



                    {/* <View>
                        <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                            <Text>OUTLET : {this.state.outlet}</Text>
                            <Text>OUTLET CODE : {this.state.outlet_code}</Text>
                            <Text>OUTLET : {this.state.trans_status_display}</Text>
                        </Card>
                        <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                            {
                                this.state.transaction_detail.map((item, index) => {
                                    return (
                                        <View key={index}>
                                            <Text>NAMA ITEM : {item.item_name}</Text>
                                            <Text>QTY : {item.item_quantity}</Text>
                                            <Text>PRICE  : {item.item_price}</Text>
                                            <Text>DISCOUNT : {item.item_discount}</Text>
                                            <View style={{ borderWidth: 1, margin: 10 }}></View>
                                            <Text>TOTAL : {item.item_subtotal}</Text>
                                        </View>
                                    )
                                })
                            }
                        </Card>
                        <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                            <Text>{}</Text>
                        </Card>
                    </View> */}
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {
        justifyContent: 'center',
        flex: 0.2,
        borderBottomWidth: 1,
        margin: 10
    },

    body: {
        flex: 0.8,
        margin: 5,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,
        trans_id: state.trans_id

    }
}

export default connect(mapStateToProps)(OrderDetail);