import Axios from 'axios';
import React from 'react';
import { ScrollView, StyleSheet, Text, View, Image } from 'react-native';
import { TouchableOpacity } from 'react-native-gesture-handler';
import HTML from 'react-native-render-html';
import { Collapse, CollapseHeader, CollapseBody, AccordionList } from 'accordion-collapse-react-native'
import { getStatusBarHeight } from 'react-native-status-bar-height';


export default class TopUpInfo extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            topup_info: [],
            statusbar_height: 40
        }
    }

    componentDidMount() {
        const statusBarHeight = getStatusBarHeight();
        this.setState({
            statusbar_height: statusBarHeight
        })
        Axios.get('https://excelsocrm.ravintoladev.com/cms/v2/list/topup-info').then(res => {
            let data = res.data;
            this.setState({
                topup_info: data.contents
            })
        })
    }


    render() {
        return (
            <View style={styles.container(this.state.statusbar_height)}>
                <View style={styles.header}>
                    <Text style={styles.headerTitle}>TOPUP INFO</Text>
                </View>
                <ScrollView>
                    <View style={styles.content}>
                        
                        {
                            this.state.topup_info.map((item, i) => {
                                return (
                                    <View style={styles.item_container} key={i}>
                                        <Collapse>
                                            <CollapseHeader>
                                                <View style={{ flexDirection: 'row', height: 24, marginBottom: 10 }}>
                                                    <Text style={styles.item_title}>{item.title}</Text>
                                                    <Image style={styles.item_image} source={item.title_thumb ? { uri: item.title_thumb } : null} />
                                                </View>
                                            </CollapseHeader>
                                            <CollapseBody>
                                                <HTML html={item.content} tagsStyles={{ p: { fontFamily: 'Gotham-Light', marginTop: 8, marginBottom: 8, color: '#adadad' }, blockquote: { backgroundColor: "#f1f1f1", padding: 12, paddingBottom: 0, marginTop: 6, color: '#adadad' }, ul: { fontFamily: 'Gotham-Light', marginLeft: 0, color: '#adadad', paddingLeft: 0 }, li: { fontFamily: 'Gotham-Light', marginLeft: 0, color: '#adadad', paddingLeft: 0 } }} />
                                            </CollapseBody>
                                        </Collapse>
                                    </View>
                                )
                            })
                        }

                    </View>
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: (marginTop) => ({
        flex: 1,
        marginTop: marginTop,
        backgroundColor: 'white',
    }),
    header: {
        height: 60,
        paddingHorizontal: 10,
        flexDirection: 'row',
        backgroundColor: '#CFB368',
        alignItems: 'center'
    },
    headerTitle: {
        flex: 1,
        textAlign: 'center',
        margin: 20,
        fontSize: 23,
        alignSelf: 'center',
        color: 'white',
        fontFamily: 'Gotham-Black'
    },
    image_container: (height) => ({
        height: height,
        backgroundColor: 'gray'
    }),
    image: (height) => ({
        width: '100%',
        height: height
    }),
    title: {
        textAlign: 'center',
        fontFamily: 'Gotham-Black',
        fontSize: 22,
        marginBottom: 10,
        color: '#CFB368'
    },
    content: {
        paddingHorizontal: 20,
        paddingVertical: 25
    },
    item_container: {
        borderColor: 'gray',
        borderWidth: 1,
        borderRadius: 10,
        padding: 20,
        marginBottom: 20,
        color: '#adadad'
    },
    item_title: {
        fontSize: 18,
        color: '#adadad',
        fontFamily: 'Gotham-Black',
        flex: 1,
        alignSelf: 'center',
    },
    item_image: {
        width: 96,
        height: 24,
        alignItems: 'flex-end'
    }
})