import { SimpleLineIcons } from '@expo/vector-icons';
import Axios from 'axios';
import * as Device from 'expo-device';
import * as Location from 'expo-location';
import * as Permissions from 'expo-permissions';
import i18n from 'i18n-js';
import * as React from 'react';
import { ActivityIndicator, Alert, Dimensions, Platform, ScrollView, StatusBar, StyleSheet, Text, TouchableOpacity, View } from 'react-native';
import { Badge } from 'react-native-elements';
import { SliderBox } from "react-native-image-slider-box";
import { Card } from 'react-native-shadow-cards';
import Toast from 'react-native-tiny-toast';
import NumberFormat from 'react-number-format';
import { connect } from 'react-redux';
import session from '../function/session';
import requestParams from '../helper/requestParams';
import ActionType from '../redux/globalActionType';
import CustomIosStatusBar from './CustomIosStatusBar';
import Spinner from 'react-native-loading-spinner-overlay';


class Home extends React.Component {


  constructor(props) {
    super(props);

    this.state = {
      spinner: false,
      data_baner: [],
      images: [],
      point: "",
      account_number: "",
      my_lat: 0,
      my_long: 0,
      indicator: true,
      indicatorProfileCard: true,
      slider_height: 350,
      slugs: [],
      placeholder: true,
      inbox: "0",
      is_expired_date: true,
      old_balance_claimed: true,
      member_since: "",
      old_balance: 0,
      expired: '',
      card_number: '' 
    }
  }

  componentDidMount() { 
    this.loadAll()
  }

  loadAll(){
    this.CheckInbox()
    const screenWidth = Math.round(Dimensions.get('window').width);

    this.setState({
      slider_height: screenWidth
    })
    this._account();

    if (this.props.outlet_id == '' && this.props.name_outlet == '' && this.props.outlet_detailadress == '') {
      this._getPermissions()
    } else {
      this.setState({
        indicator: false
      })
    }

    this._renderCarousell()

    this._unsubscribe = this.props.navigation.addListener('focus', () => {
      this.CheckInbox()
      this.setState({
        indicator: true,
        indicatorProfileCard: true
      })
      this._account();
      if (this.props.outlet_id == '' && this.props.name_outlet == '' && this.props.outlet_detailadress == '') {
        this._getPermissions()

      } else {
        this.setState({
          indicator: false,
        })
      }
      this._renderCarousell()
      // CheckVersion(navigation)
    });
  }

  CheckInbox() {
    let params = Object.assign(requestParams, {
      session_id: this.props.session_id,
    })
    Axios.post( this.props.BASE_URL + 'crm/v2/inbox/unread_count', params).then(respon => {
      let res = respon.data.unread_count

      this.setState({
        inbox: res.toString()
      })

    }).catch(error => {
      let response = error.response.data;
      // custom Toast
      // Toast.show(response.msg, {
      //   position: 0,
      //   containerStyle: { backgroundColor: 'white', borderRadius: 10 },
      //   textColor: '#838383',
      //   textStyle: { fontSize: 14, fontFamily: 'Gotham-Black' }
      // })
      Toast.show(response.msg)

      // Tes Logout jika session habis
      // let configProps = {
      //   session_id: ''
      // }
      // this.props.setConfig(configProps);
      // this.props.navigation.replace('Login');
    })
  }

  componentWillUnmount() {
    this._unsubscribe();
  }

  _getPermissions = async () => {
    let { status } = await Permissions.askAsync(Permissions.LOCATION);
    if (status !== 'granted') {
      // Alert.alert('Akses tidak dizinkan!')
      Toast.show(i18n.t('accessNotPermitted'))
    } else if (Platform.OS === 'android' && !Device.isDevice) {

      // Alert.alert('Silahkan anda coba di real Device')
      Toast.show(i18n.t('tryItRealDevice'))
    } else {
      this._getCurrentPosisition()
    }
  }
  _getCurrentPosisition = async () => {
    this.setState({
      spinner: true,
    })
    let location = await Location.getCurrentPositionAsync({
      accuracy: Location.Accuracy.Highest
    })

    let latitude = location.coords.latitude;
    let longitude = location.coords.longitude;

    this.setState({
      my_lat: latitude,
      my_long: longitude
    })

    let cordinate = {
      lat: this.state.my_lat,
      long: this.state.my_long,
    }
    this.props.setCordinatProps(cordinate);
    this._getOutletClosest();
  }
  _renderCarousell() {
    Axios.get(this.props.BASE_URL + 'cms/v2/list/promotions-carousel').then(respon => {
      const dataCarousell = respon.data.contents;
      let imageLink = []
      let slugs = []


      for (let i = 0; i < dataCarousell.length; i++) {
        const element = dataCarousell[i];
        imageLink.push(element.title_thumb)
        slugs.push(element.slug)
      }
      this.setState({
        images: imageLink,
        slugs: slugs,
        placeholder: false
      })
    }).catch(error => {

      const { navigation } = this.props
      let response = error.response.data
      session(response, navigation)
    })
  }

  _account() {
    let params = Object.assign(requestParams, {
      session_id: this.props.session_id,
    })
    this.setState({indicatorProfileCard: true})

    Axios.post(this.props.BASE_URL + 'crm/v2/member/get_profile', params).then(res => {
      const dataCard = res.data
      let point = dataCard.kaspro_point
      let balance = dataCard.kaspro_balance
      let expired = dataCard.expire_date
      let account_number = dataCard.kaspro_account_number
      let is_expired = dataCard.is_expired
      let old_balance_claimed = dataCard.old_balance_claimed
      let member_since = dataCard.member_since
      let old_balance = dataCard.old_balance
      let card_number = dataCard.card_number

      this.setState({
        point: point,
        balance: balance,
        account_number: account_number,
        expired: expired,
        indicatorProfileCard: false,
        is_expired: is_expired,
        old_balance_claimed: old_balance_claimed,
        member_since: member_since,
        old_balance: old_balance,
        card_number: card_number
      })

      let setCardNumberProps = {
        card_number: this.state.card_number
      }
      this.props.setCardNumber(setCardNumberProps)

    }).catch(error => {
      let response = error.response.data
      // Alert.alert('',response.msg);
      Toast.show(response.msg)
    })
  }

  _getOutletClosest() {

    let params = Object.assign(requestParams, {
      session_id: this.props.session_id,
      lat: this.state.my_lat,
      long: this.state.my_long,
    })

    // console.log("INI DATANYA " + JSON.stringify(params));
    Axios.post(this.props.BASE_URL + 'crm/v2/outlet/get_closest', params).then(res => {
      let outletId = res.data.data.outlet_id
      let outletName = res.data.data.outlet_name
      let outletAddress = res.data.data.outlet_address

      let OutletChange = {
        outlet_id: outletId,
        name_outlet: outletName,
        outlet_detailadress: outletAddress
      }
      this.props.setChangeOutletProps(OutletChange);
      this.setState({
        indicator: false
      })
    }).catch(error => {
      let response = error.response.data
      // Alert.alert('',response.msg);
      Toast.show(response.msg)
    })
  }

  handleuseBalance() {
    let params = Object.assign(requestParams, {
      session_id: this.props.session_id,
    })
    Axios.post(this.props.BASE_URL + 'crm/v2/point/check', params).then(res => {
      if (res.data.in_process_redeem == false) {
        this.props.navigation.navigate('UseBalance')
      } else {
        this.props.navigation.navigate('Redeem Code')
      }
    }).catch(error => {
      let response = error.response.data
      Alert.alert(error, response.msg)
    })
  }

  _pickup() {
    this.props.navigation.navigate('Pickup Name', { from: 'home' });
  }

  _delivery() {
    this.props.navigation.navigate('Delivery Address', { from: 'home' });
  }

  _orderNow = () => {
    if (this.props.outlet_id != '' && this.props.name_outlet != '') {
      // this.props.setTypePickup(true)
      this.props.navigation.navigate('Home', {
        screen: 'MENU',
        params: { user: 'jaxi' },
      });

    } else {
      // Alert.alert('Belum dapat outlet terdekat')
      Toast.show(i18n.t('alertCantGetOutlet'))
    }
  }

  handleClaimCredit() {
    this.setState({spinner: true}) 
    this.setState({old_balance_claimed: true}) /** set jadi true dulu buat hilangkan bagian claim credit */
    this.setState({indicatorProfileCard: true}) /** atau sekalian dibuat loading aja bagian profilecardnya */

    let params = Object.assign(requestParams, {
      session_id: this.props.session_id,
    })
     
    Axios.post(this.props.BASE_URL + 'crm/v2/card/claim_old_balance', params).then(res => {
      this.setState({spinner: false}) 
      this._account()
      // Alert.alert(i18n.t('success'), i18n.t('alertclaimcredit')) 
    }).catch(error => {
      this.setState({spinner: false})
      this._account()
      let response = error.response.data  
      Alert.alert(error, response.msg) 
    })
  }

  onClickClaimCredit() {
    Alert.alert(
      "",
      i18n.t('makeSureClaimCredit'),
      [
        {
          text: i18n.t('alertno'),
          onPress: () => console.log('Cancel Claim Credit'),
          style: 'cancel',
        },
        {
          text: i18n.t('alertyes'), onPress: () => {            
            this.handleClaimCredit()
          }
        },
      ],
      { cancelable: false },
    )
  }

  render() {
    const { navigation } = this.props
    navigation.setOptions({
      headerRight: () => (
        <Text style={{ color: 'red' }}>hahah</Text>
      ),
    })
    return (

      <View style={styles.container}>
        <Spinner visible={this.state.spinner} textContent={'Loading...'}  textStyle={{ color: "white" }} />

        {Platform.OS === 'ios' ? (
          <CustomIosStatusBar color='#CFB368' />
        ) : (
            <StatusBar backgroundColor='#CFB368' />
          )}
        <ScrollView>
          <View style={{ flex: 6 }}>
            <View style={styles.header}>
              <View style={{ flex: 0.1, padding: 15 }} />
              <View style={{ flex: 0.8, alignItems: 'center', padding: 15 }}>
                <Text style={styles.titleText}>{i18n.t('promotion')}</Text>
              </View>
              <View style={{ padding: 15, flex: 0.1, alignItems: 'flex-end' }}>
                <TouchableOpacity onPress={() => this.props.navigation.navigate('Inbox List')}>
                  <SimpleLineIcons name="bell" size={24} color="white" />
                  {
                    this.state.inbox == '0' ? (
                      null
                    ) : (
                        <Badge value={this.state.inbox} status="error" containerStyle={{ position: 'absolute', top: -4, right: -4 }} />
                      )
                  }

                </TouchableOpacity>
              </View>
            </View>
            <View style={{ flex: 2 }}>
              {
                this.state.images.length ? (
                  <SliderBox
                    images={this.state.images}
                    onCurrentImagePressed={index => console.log(`image ${index} pressed`)}
                    autoplay
                    circleLoop
                    dotColor='black'
                    inactiveDotColor='white'
                    sliderBoxHeight={this.state.slider_height}
                    paginationBoxVerticalPadding={20}
                    resizeMethod={'resize'}
                    resizeMode={'stretch'}
                    paginationBoxStyle={{
                      position: "absolute",
                      bottom: 0,
                      padding: 0,
                      alignItems: 'center',
                      alignSelf: 'center',
                      justifyContent: 'center',
                      paddingVertical: 10,
                    }}
                    dotStyle={{
                      width: 10,
                      height: 10,
                      borderRadius: 5,
                      marginHorizontal: 0,
                      padding: 0,
                      margin: 0,
                    }}
                    ImageComponentStyle={{
                      width: '100%',
                    }}
                    imageLoadingColor='#c7c7c7'
                    onCurrentImagePressed={(index) => this.props.navigation.navigate('News Detail', { slug: this.state.slugs[index] })}
                  />
                ) : (
                    <View style={{ height: this.state.slider_height, backgroundColor: '#838383', justifyContent: 'center' }}>
                      <ActivityIndicator size="large" color="#c9af6d" />
                    </View>
                  )
              }
            </View>
          </View>
          <View style={styles.content}>
            <View style={styles.card}>
              {
                this.props.type_pickup == true ? (
                  <Card>
                    <View style={{ flexDirection: 'row', justifyContent: 'center' }}>
                      {/* <TouchableOpacity style={styles.buttonDelivery} onPress={() => this._delivery()}>
                    <Text style={{ textAlign: 'center', color: '#354175', fontWeight: 'bold' }}>{i18n.t('delivery')}</Text>
                  </TouchableOpacity>
                  <TouchableOpacity style={styles.buttonPickup} onPress={() => this._pickup()}>
                    <Text style={{ textAlign: 'center', color: '#fff', fontWeight: 'bold' }}>{i18n.t('pickup')}</Text>
                  </TouchableOpacity> */}
                      <TouchableOpacity style={styles.buttonDeliveryFalse} onPress={() => this._delivery()}>
                        <Text style={{ textAlign: 'center', color: 'white', fontFamily: 'Gotham-Black' }}>{i18n.t('delivery')}</Text>
                      </TouchableOpacity>
                      <TouchableOpacity style={styles.buttonPickupTrue} onPress={() => this._pickup()}>
                        <Text style={{ textAlign: 'center', color: '#fff', fontFamily: 'Gotham-Black' }}>{i18n.t('pickup')}</Text>
                      </TouchableOpacity>
                    </View>
                    {/* <Text style={{ textAlign: 'center', fontSize: 12, }}>
                  {i18n.t('orderInfo')}
                </Text> */}
                    <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color: '#838383' }}>
                      {i18n.t('orderInfo')}
                    </Text>
                    {this.state.indicator == true ? (
                      <ActivityIndicator size="small" color="#c9af6d" />
                    ) : (
                        <Text style={{ textAlign: "center", fontSize: 12, top: 5, fontFamily: 'Gotham-Light', color: '#838383' }}>
                          {this.props.name_outlet}
                        </Text>
                      )}
                    {/* <TouchableOpacity style={styles.submitOrder} activeOpacity={.5} onPress={() => this._orderNow()}>
                  <Text style={{ textAlign: 'center', bottom: 5, color: 'white' }}>{i18n.t('orderNow')}</Text>
                </TouchableOpacity> */}
                    <TouchableOpacity style={styles.submitOrder} activeOpacity={.5} onPress={() => this._orderNow()}>
                      <Text style={{ textAlign: 'center', color: 'white', fontFamily: 'Gotham-Black', fontSize: 16 }}>{i18n.t('orderNow')}</Text>
                    </TouchableOpacity>
                  </Card>
                ) : (
                    <Card>
                      <View style={{ flexDirection: 'row', justifyContent: 'center' }}>
                        {/* <TouchableOpacity style={styles.buttonDelivery} onPress={() => this._delivery()}>
                    <Text style={{ textAlign: 'center', color: '#354175', fontWeight: 'bold' }}>{i18n.t('delivery')}</Text>
                  </TouchableOpacity>
                  <TouchableOpacity style={styles.buttonPickup} onPress={() => this._pickup()}>
                    <Text style={{ textAlign: 'center', color: '#fff', fontWeight: 'bold' }}>{i18n.t('pickup')}</Text>
                  </TouchableOpacity> */}
                        <TouchableOpacity style={styles.buttonDeliveryTrue} onPress={() => this._delivery()}>
                          <Text style={{ textAlign: 'center', color: '#354175', fontFamily: 'Gotham-Black' }}>{i18n.t('delivery')}</Text>
                        </TouchableOpacity>
                        <TouchableOpacity style={styles.buttonPickupFalse} onPress={() => this._pickup()}>
                          <Text style={{ textAlign: 'center', color: '#fff', fontFamily: 'Gotham-Black' }}>{i18n.t('pickup')}</Text>
                        </TouchableOpacity>
                      </View>
                      {/* <Text style={{ textAlign: 'center', fontSize: 12, }}>
                  {i18n.t('orderInfo')}
                </Text> */}
                      <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color: '#838383' }}>
                        {i18n.t('deliveryinfo')}
                      </Text>
                      {this.state.indicator == true ? (
                        <ActivityIndicator size="small" color="#c9af6d" />
                      ) : (
                          <Text style={{ textAlign: "center", fontSize: 12, top: 5, fontFamily: 'Gotham-Light', color: '#838383' }}>
                            {this.props.home_address}
                          </Text>
                        )}
                      {/* <TouchableOpacity style={styles.submitOrder} activeOpacity={.5} onPress={() => this._orderNow()}>
                  <Text style={{ textAlign: 'center', bottom: 5, color: 'white' }}>{i18n.t('orderNow')}</Text>
                </TouchableOpacity> */}
                      <TouchableOpacity style={styles.submitOrder} activeOpacity={.5} onPress={() => this._orderNow()}>
                        <Text style={{ textAlign: 'center', color: 'white', fontFamily: 'Gotham-Black', fontSize: 16 }}>{i18n.t('orderNow')}</Text>
                      </TouchableOpacity>
                    </Card>
                  )
              }
  
              {
                this.state.indicatorProfileCard == true ? (
                  <View style={styles.card}>
                    <Card style={{ padding: 50, margin: 10, alignContent: 'center' }}>
                      <ActivityIndicator style={{ justifyContent: "center" }} size="large" color="#c9af6d" />
                    </Card>
                  </View>
                ) :
                  
                  //jika member belum punya account kaspro
                  this.state.account_number == "" ? (
                    <View style={styles.card}>
                      <Card style={{ padding: 10, margin: 10, alignContent: 'center', backgroundColor: '#838383' }}>
                        <View style={{ flex: 1, backgroundColor: 'grey', height: 150, borderRadius: 20, marginRight: 10, marginLeft: 10, justifyContent: 'center' }}>
                          <View style={{ justifyContent: 'center' }}>
                            <TouchableOpacity onPress={() => this.props.navigation.navigate('Card Activation', { cardNumber: this.state.card_number })}>
                              <View style={{ height: 50, borderRadius: 20, backgroundColor: 'white', marginRight: 20, marginLeft: 20, }}>
                                <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 15 }}> {i18n.t('Acitvatecard')}</Text>
                              </View>
                            </TouchableOpacity>
                          </View>
                        </View>
                      </Card>
                    </View>
                  ) :
                    //jika memeber udah punya account kaspro tapi tidak expired
                    this.state.account_number !== "" && this.state.is_expired == false ? (
                      <View style={styles.card}>
                        <Card style={{ padding: 20, margin: 10, alignContent: 'center' }}>
                          <View style={{ flexDirection: 'row', flex: 1, paddingBottom: 5 }}>
                            <View style={{ flex: 0.5 }}>
                              <Text style={{ fontSize: 10, fontFamily: 'Gotham-Light' }}>{i18n.t('cardnumber')}</Text>
                            </View>
                            <View style={{ flex: 0.5 }}>
                              <Text style={{ fontSize: 10, textAlign: 'right', fontFamily: 'Gotham-Light' }}> {i18n.t('expired')} {this.state.expired}</Text>
                            </View>
                          </View>
                          <View style={{ paddingHorizontal: 10 }}>
                            <Text style={{ textAlign: "center", fontSize: 30, color: '#c9af6d', fontFamily: 'Gotham-Black' }}>
                              {this.state.card_number}
                            </Text>
                          </View>
                          <View style={styles.line}></View>
                          <View style={{ flexDirection: 'row', flex: 1 }}>
                            <View style={{ flex: 0.3, justifyContent: 'center' }}>
                              {/* <Text>{i18n.t('balance')}</Text> */}
                              <Text style={{ fontSize: 14, fontFamily: 'Gotham-Light' }}>{i18n.t('balance')} : </Text>
                            </View>
                            <View style={{ flex: 0.7, alignItems: 'center' }}>
                              <Text style={{ fontSize: 14, fontFamily: 'Gotham-Black', color: 'gray' }}>IDR {this.state.balance}</Text>
                            </View>
                          </View>
                          <View style={styles.line2}></View>
                          <View style={{ flexDirection: 'row', flex: 1 }}>
                            <View style={{ flex: 0.3, justifyContent: 'center' }}>
                              {/* <Text>{i18n.t('balance')}</Text> */}
                              <Text style={{ fontSize: 14, fontFamily: 'Gotham-Light' }}>{i18n.t('point')} : </Text>
                            </View>
                            <View style={{ flex: 0.7, alignItems: 'center' }}>
                              <Text style={{ fontSize: 14, fontFamily: 'Gotham-Black', color: 'gray' }}>IDR {this.state.point}</Text>
                            </View>
                          </View>
                        </Card> 
                        {this.state.old_balance_claimed == false ? (
                          this.state.old_balance == 0 ? (null) :
                            (<Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                              <View style={{ flex: 1, height: 80, borderRadius: 20, marginRight: 10, marginLeft: 10, justifyContent: 'center' }}>
                                <NumberFormat decimalScale={0} value={this.state.old_balance} renderText={value => <Text style={{ fontSize: 14, fontFamily: 'Gotham-Light', textAlign: 'center', marginBottom: 10, color: '#838383' }}>CREDIT : Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                <View style={{ justifyContent: 'center' }}>
                                  <TouchableOpacity onPress={() => this.onClickClaimCredit()}>
                                    <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', marginRight: 20, marginLeft: 20, justifyContent: 'center' }}>
                                      <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 20, textAlign: 'center', margin: 15 }}>CLAIM CREDIT</Text>
                                    </View>
                                  </TouchableOpacity>
                                </View>
                              </View>
                            </Card>)
                        ) : (null)}
                      </View>
                    ) :
                      this.state.account_number == "" && this.state.is_expired == true ? (
                        <View style={styles.card}>
                          <Card style={{ padding: 20, margin: 10, alignContent: 'center' }}>
                            <View style={{ flexDirection: 'row', flex: 1, paddingBottom: 5 }}>
                              <View style={{ flex: 0.5 }}>
                                <Text style={{ fontSize: 10, fontFamily: 'Gotham-Light' }}>{i18n.t('cardnumber')}</Text>
                              </View>
                              <View style={{ flex: 0.5 }}>
                                <Text style={{ fontSize: 10, textAlign: 'right', fontFamily: 'Gotham-Light', color: 'red' }}>{i18n.t('expired')} {this.state.expired}</Text>
                              </View>
                            </View>
                            <View style={{ paddingHorizontal: 10 }}>
                              <Text style={{ textAlign: "center", fontSize: 30, color: '#c9af6d', fontFamily: 'Gotham-Black' }}>
                                {this.state.card_number}
                              </Text>
                            </View>
                            <View style={styles.line}></View>
                            <View style={{ flexDirection: 'row', flex: 1 }}>
                              <View style={{ flex: 0.3, justifyContent: 'center' }}>
                                {/* <Text>{i18n.t('balance')}</Text> */}
                                <Text style={{ fontSize: 14, fontFamily: 'Gotham-Light' }}>{i18n.t('balance')} : </Text>
                              </View>
                              <View style={{ flex: 0.7, alignItems: 'center' }}>
                                <Text style={{ fontSize: 14, fontFamily: 'Gotham-Black', color: 'gray' }}>IDR {this.state.balance}</Text>
                              </View>
                            </View>
                            <View style={styles.line2}></View>
                            <View style={{ flexDirection: 'row', flex: 1 }}>
                              <View style={{ flex: 0.3, justifyContent: 'center' }}>
                                {/* <Text>{i18n.t('balance')}</Text> */}
                                <Text style={{ fontSize: 14, fontFamily: 'Gotham-Light' }}>{i18n.t('point')} : </Text>
                              </View>
                              <View style={{ flex: 0.7, alignItems: 'center' }}>
                                <Text style={{ fontSize: 14, fontFamily: 'Gotham-Black', color: 'gray' }}>IDR {this.state.point}</Text>
                              </View>
                              <View style={styles.line2}></View>
                              <View style={{ justifyContent: 'center', marginTop: 20 }}>
                                <TouchableOpacity onPress={() => this.props.navigation.navigate('Renewal')}>
                                  <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', marginRight: 20, marginLeft: 20, justifyContent: 'center' }}>
                                    <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 16, textAlign: 'center', margin: 15 }}>RENEWAL</Text>
                                  </View>
                                </TouchableOpacity>
                              </View>
                            </View>
                          </Card>
                          {this.state.old_balance_claimed == false ? (
                            this.state.old_balance == 0 ? (null) :
                              (<Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                                <View style={{ flex: 1, height: 80, borderRadius: 20, marginRight: 10, marginLeft: 10, justifyContent: 'center' }}>
                                  <NumberFormat decimalScale={0} value={this.state.old_balance} renderText={value => <Text style={{ fontSize: 14, fontFamily: 'Gotham-Light', textAlign: 'center', marginBottom: 10, color: '#838383' }}>CREDIT : Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                  <View style={{ justifyContent: 'center' }}>
                                    <TouchableOpacity onPress={() => this.onClickClaimCredit()}>
                                      <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', marginRight: 20, marginLeft: 20, justifyContent: 'center' }}>
                                        <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 20, textAlign: 'center', margin: 15 }}>CLAIM CREDIT</Text>
                                      </View>
                                    </TouchableOpacity>
                                  </View>
                                </View>
                              </Card>)
                          ) : (null)}
                        </View>
                      ) : (
                          <View style={styles.card}>
                            <Card style={{ padding: 20, margin: 10, alignContent: 'center' }}>
                              <View style={{ flexDirection: 'row', flex: 1, paddingBottom: 5 }}>
                                <View style={{ flex: 0.5 }}>
                                  <Text style={{ fontSize: 10, fontFamily: 'Gotham-Light' }}>{i18n.t('cardnumber')}</Text>
                                </View>
                                <View style={{ flex: 0.5 }}>
                                  <Text style={{ fontSize: 10, textAlign: 'right', fontFamily: 'Gotham-Light' }}>{i18n.t('expired')} {this.state.expired}</Text>
                                </View>
                              </View>
                              <View style={{ paddingHorizontal: 10 }}>
                                <Text style={{ textAlign: "center", fontSize: 30, color: '#c9af6d', fontFamily: 'Gotham-Black' }}>
                                  {this.state.card_number}
                                </Text>
                              </View>
                              <View style={styles.line}></View>
                              <View style={{ flexDirection: 'row', flex: 1 }}>
                                <View style={{ flex: 0.3, justifyContent: 'center' }}>
                                  <Text style={{ fontSize: 14, fontFamily: 'Gotham-Light' }}>{i18n.t('balance')} : </Text>
                                </View>
                                <View style={{ flex: 0.7, alignItems: 'center' }}>
                                  <Text style={{ fontSize: 14, fontFamily: 'Gotham-Black', color: 'gray' }}>IDR {this.state.balance}</Text>
                                </View>
                              </View>
                              <View style={styles.line2}></View>
                              <View style={{ flexDirection: 'row', flex: 1 }}>
                                <View style={{ flex: 0.3, justifyContent: 'center' }}>
                                  <Text style={{ fontSize: 14, fontFamily: 'Gotham-Light' }}>{i18n.t('point')} : </Text>
                                </View>
                                <View style={{ flex: 0.7, alignItems: 'center' }}>
                                  <Text style={{ fontSize: 14, fontFamily: 'Gotham-Black', color: 'gray' }}>IDR {this.state.point}</Text>
                                </View>
                              </View>
                              <View style={styles.line2}></View>
                              {this.state.is_expired_date == true ? (
                                <View style={{ justifyContent: 'center', marginTop: 20 }}>
                                  <TouchableOpacity onPress={() => this.props.navigation.navigate('Renewal')}>
                                    <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', marginRight: 20, marginLeft: 20, justifyContent: 'center' }}>
                                      <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 16, textAlign: 'center', margin: 15 }}>RENEWAL</Text>
                                    </View>
                                  </TouchableOpacity>
                                </View>
                              ) : (null)}
                            </Card>
                          </View>
                        )
              }
              <View style={{ flexDirection: 'row', flex: 1, height: 40, marginTop: 40 }}>
                <View style={{ justifyContent: 'center', flex: 1 }}>
                  <TouchableOpacity onPress={() => this.props.navigation.navigate('TopUpInfo')}>
                    <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', marginRight: 20, marginLeft: 20, justifyContent: 'center' }}>
                      <Text style={{ textAlign: 'center', color: 'white', fontFamily: 'Gotham-Black', fontSize: 14 }}>{i18n.t('topup')}</Text>
                    </View>
                  </TouchableOpacity>
                </View>
                <View style={{ justifyContent: 'center', flex: 1 }}>
                  <TouchableOpacity onPress={() => this.handleuseBalance()}>
                    <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', marginRight: 20, marginLeft: 20, justifyContent: 'center' }}>
                      <Text style={{ textAlign: 'center', color: 'white', fontFamily: 'Gotham-Black', fontSize: 14 }}>{i18n.t('usebalance')}</Text>
                    </View>
                  </TouchableOpacity>
                </View>
              </View>
              <View style={{ height: 40 }}></View>
            </View>
          </View>
        </ScrollView>
      </View>
    )
  }
}

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: 'white',
  },
  header: {
    flex: 0.1,
    flexDirection: 'row',
    backgroundColor: '#CFB368',
    paddingTop: StatusBar.currentHeight,
    // justifyContent: 'space-between',
    alignItems: 'center'
  },
  titleText: {
    fontSize: 20,
    // fontWeight: 'bold',
    fontFamily: 'Gotham-Black',
    color: 'white',
    // textAlign: 'center'
  },

  content: {
    flex: 1,
  },
  card: {
    top: 20,
    flex: 1,
    alignItems: 'center'
  },
  buttonDeliveryTrue: {
    justifyContent: 'center',
    height: 40,
    marginTop: 10,
    // paddingTop: 15,
    // paddingBottom: 15,
    marginRight: 0,
    marginLeft: 0,
    backgroundColor: '#cce8f0',
    borderRadius: 10,
    borderWidth: 0,
    borderColor: '#fff',
    width: '50%',
    top: -20,
  },
  buttonDeliveryFalse: {
    justifyContent: 'center',
    height: 40,
    marginTop: 10,
    // paddingTop: 15,
    // paddingBottom: 15,
    marginRight: 0,
    marginLeft: 0,
    backgroundColor: '#838383',
    borderRadius: 10,
    borderWidth: 0,
    borderColor: '#fff',
    width: '50%',
    top: -20,
  },
  buttonPickupTrue: {
    justifyContent: 'center',
    height: 40,
    marginTop: 10,
    // paddingTop: 15,
    // paddingBottom: 15,
    marginRight: 0,
    marginLeft: -30,
    backgroundColor: '#354175',
    borderRadius: 10,
    borderWidth: 0,
    borderColor: '#fff',
    width: '40%',
    top: -20,
  },
  buttonPickupFalse: {
    justifyContent: 'center',
    height: 40,
    marginTop: 10,
    // paddingTop: 15,
    // paddingBottom: 15,
    marginRight: 0,
    marginLeft: -30,
    backgroundColor: '#838383',
    borderRadius: 10,
    borderWidth: 0,
    borderColor: '#fff',
    width: '40%',
    top: -20,
  },

  submitOrder: {
    height: 40,
    margin: 10,
    paddingTop: 10,
    backgroundColor: '#CFB368',
    borderRadius: 10,
    borderWidth: 0,
    borderColor: '#fff',
  },

  topUseBalance: {
    flex: 0.5,
    height: 40,
    top: 20,
    margin: 5,
    paddingVertical: 12,
    paddingHorizontal: 16,
    borderRadius: 10,
    backgroundColor: '#CFB368',
    // paddingBottom: -5
  },

  line: {
    borderBottomColor: '#c9af6d',
    borderBottomWidth: 2,
    alignSelf: 'stretch',
    width: "100%",
    height: 10,
    bottom: 5,
  },
  line2: {
    borderBottomColor: '#c9af6d',
    borderBottomWidth: 1,
    alignSelf: 'stretch',
    width: "100%",
    height: 10,
    bottom: 5,
  },
})

const mapDispatchToProps = (dispacth) => {
  return {

    setChangeOutletProps: (OutletChange) => dispacth({
      type: ActionType.SET_CHANGE_OUTLET,
      data: {
        outlet_id: OutletChange.outlet_id,
        name_outlet: OutletChange.name_outlet,
        outlet_detailadress: OutletChange.outlet_detailadress
      }
    }),
    setTypePickup: (type) => dispacth({
      type: ActionType.SET_TYPE,
      data: {
        type_pickup: type
      }
    }),

    setCordinatProps: (cordinate) => dispacth({
      type: ActionType.SET_CORDINAT,
      data: {
        lat: cordinate.lat,
        long: cordinate.long,
      }
    }),

    setCardNumber: (setCardNumberProps) => dispacth({

      type: ActionType.SET_ACCOUNT_NUMBER,
      data: {
        card_number: setCardNumberProps.card_number,
      }
    }),
    setConfig: (configProps) => dispacth({
      type: ActionType.SET_LOGOUT,
      data: {
        session_id: configProps.session_id
      }
    }),

  }
}

const mapStateToProps = (state) => {
  return {
    // login
    in_payment: state.in_payment,
    BASE_URL: state.BASE_URL,
    email: state.email,
    outlet_id: state.outlet_id,
    name_outlet: state.name_outlet,
    outlet_detailadress: state.name_outlet,
    session_id: state.session_id,
    password: state.password,
    fb_token: state.fb_token,
    device_id: state.device_id,
    os_version: state.os_version,
    os_name: state.os_name,
    app_version: state.app_version,
    isEmailverif: state.isEmailverif,
    proses: state.proses,
    pageEmailConfirmation: state.pageEmailConfirmation,
    language: state.language,
    lat: state.lat,
    long: state.long,
    type_pickup: state.type_pickup,
    address: state.address,
    home_address: state.home_address,
  }
}



export default connect(mapStateToProps, mapDispatchToProps)(Home)