import React from 'react';
import { View, Text, StyleSheet, Button, Alert, TouchableOpacity } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import MyStatusBar from './MyStatusBar';
import i18n from 'i18n-js';
import Toast from 'react-native-tiny-toast';
import moment from 'moment'

class Renewal extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            current_balance: "",
            expired: "",
            card_number: "",
            biaya_renewal: "100.000",
            renew_until: "",
        }
    }

    componentDidMount() {
        this._getProfile();
        // console.log(this.props.BASE_URL)
    }

    _handleRenewal() {
        Alert.alert(
            i18n.t('alertRenewalTitle'),
            i18n.t('alertRenewalContent'),
            [
                {
                    text: i18n.t('alertno'),
                    onPress: () => console.log('Cancel Renewal'),
                    style: 'cancel',
                },
                {
                    text: i18n.t('alertyes'), onPress: () => this._renewal()
                },
            ],
            { cancelable: false },
        )
    }

    _renewal() {
        let params = {
            session_id: this.props.session_id
        }
        // console.log(params);
        Axios.post(this.props.BASE_URL+'crm/v2/card/renewal', params).then(res => {
            // console.log('ini res ' + JSON.stringify(res.data))
            this._getProfile();
            Toast.show(i18n.t('successRenewal'))
            this.props.navigation.navigate('Home', { screen: 'ACCOUNT' });
        }).catch(error => {
            let response = error.response.data;
            // console.log(response.msg)
            Alert.alert('', response.msg);
        })
    }

    _getProfile() {
        let params = {
            session_id: this.props.session_id
        }

        Axios.post(this.props.BASE_URL+'crm/v2/member/get_profile', params).then(res => {
            // console.log('ini res ' + JSON.stringify(res.data))
            const dataCard = res.data

            let balance = dataCard.kaspro_balance
            let expired = dataCard.expire_date
            let c_renew_until = dataCard.expire_date

            var date_string = c_renew_until
            var date_arr = date_string.split('-');
            var date = new Date(date_arr[0], date_arr[1], date_arr[2]);

            date.setFullYear(date.getFullYear() + 1);
            let date_nextyear_string = moment([date.getFullYear(),date.getMonth(), date.getDate()]).month(date.getMonth() - 1).format("YYYY-MM-DD")
            // console.log("INI YA : " + date_nextyear_string)

            this.setState({
                current_balance: balance,
                expired: expired,
                renew_until: date_nextyear_string
            })

        }).catch(error => {
            // console.log('ini error ' + error)
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <MyStatusBar />
                {/* <View style={styles.header}> */}
                {/* <Text style={{ textAlign: 'center', margin: 20, fontSize: 25, alignSelf: 'center' }}>Renewal</Text> */}
                {/* </View> */}
                <View style={styles.body}>
                    <View style={styles.cont_curent_balance}>
                        <View style={styles.current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color: '#CFB368' }}>{i18n.t('currentbalance')}</Text>
                        </View>
                        <View style={styles.value_current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color: 'gray' }}>IDR {this.state.current_balance}</Text>
                        </View>
                    </View>
                    <View style={styles.cont_curent_balance}>
                        <View style={styles.current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color: '#CFB368' }}>{i18n.t('renewalfees')}</Text>
                        </View>
                        <View style={styles.value_current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color: 'gray' }}>IDR {this.state.biaya_renewal}</Text>
                        </View>
                    </View>
                    <View style={styles.cont_curent_balance}>
                        <View style={styles.current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color: '#CFB368' }}>{i18n.t('expired')}</Text>
                        </View>
                        <View style={styles.value_current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color: 'gray' }}>{this.state.expired}</Text>
                        </View>
                    </View>

                    <View style={styles.cont_curent_balance}>
                        <View style={styles.current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color: '#CFB368' }}>{i18n.t('renewuntil')}</Text>
                        </View>
                        <View style={styles.value_current_balance}>
                            <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color: 'gray' }}>{this.state.renew_until}</Text>
                        </View>
                    </View>
                    {/* <View style={styles.btn_renewal}>
                        <Button title="Renew" onPress={() => this._renewal()}></Button>
                    </View> */}
                    <TouchableOpacity onPress={() => this._handleRenewal()}>
                        <View style={styles.button}>
                            <Text style={{ color: 'white', fontSize: 16, textAlign: 'center', fontFamily: 'Gotham-Black' }}>{i18n.t('renew')}</Text>
                        </View>
                    </TouchableOpacity>
                </View>
            </View>
        )
    }
}


const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {
        flex: 0.1,
    },
    body: {
        flex: 0.9,
        marginTop: 12
    },
    cont_curent_balance: {
        flex: 0.2
    },
    current_balance: {
        flex: 1,
        // backgroundColor:'cyan',
        justifyContent: 'center',
    },
    value_current_balance: {
        flex: 1,
        marginHorizontal: 30,
        paddingHorizontal: 10,
        paddingVertical: 5,
        justifyContent: 'center',
        borderWidth: 1,
        borderColor: 'gray',
        borderRadius: 10,
        // backgroundColor:'maroon'
    },
    button: {
        height: 40,
        borderRadius: 10,
        backgroundColor: '#CFB368',
        justifyContent: 'center',
        margin: 30,
        padding: 5,
        bottom: 5,
    },
})

const mapStateToProps = (state) => {
    return {
        session_id: state.session_id,
        language: state.language,
        BASE_URL: state.BASE_URL
    }
}
export default connect(mapStateToProps)(Renewal);
