import React from 'react'
import { View, Text, TextInput, StyleSheet, ScrollView, Alert, TouchableOpacity, Button } from 'react-native'
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux'
import Axios from 'axios'
import moment from 'moment'
import NumberFormat from 'react-number-format';
import { FontAwesome } from '@expo/vector-icons';

class TransactionDetail extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            transDetail: [],
            trans_date: '',
            transDiscount: '',
            transId: '',
            transTax: '',
            transTotal: '',
            trans_type_display: '',
            outlet: '',
            outlet_code: '',
            trans_time: '',
            trans_total: '',
            point_reduce: '',
            transaction_detail: [],
            detail_trans: '',
            numberId: ''
        }
    }

    componentDidMount() {
        this.getDetailTrans()
    }

    getDetailTrans() {
        let params = {
            session_id: this.props.session_id,
            transaction_id: this.props.route.params.idTrans
        }
        Axios.post(this.props.BASE_URL + 'crm/v2/transaction/detail', params).then(res => {
            // console.log("INI DATA NYA LHOOOOO ......." + JSON.stringify(res.data))
            let data = res.data
            // console.log(data)
            this.setState({
                trans_type_display: data.trans_type_display,
                transId: data.trans_id,
                trans_date: data.trans_date,
                transTotal: data.trans_total,
                outlet: data.outlet,
                outlet_code: data.outlet_code,
                trans_time: data.trans_time,
                trans_total: data.trans_total,
                point_reduce: data.point_reduce,
                transaction_detail: data.transaction_detail,
                detail_trans: data,
                numberId: data.id.substring(0, 5).toUpperCase()
            })
            console.log(this.state.detail_trans)
            // console.log(this.props.route.params.idTrans)
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <Text style={{ fontSize: 16, fontFamily: 'Gotham-Light', textAlign: 'center', color: 'grey' }}>#{this.state.numberId}</Text>
                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', textAlign: 'center', color: 'grey' }}>{moment(this.state.detail_trans.trans_time).format('DD MMMM YYYY HH:mm:ss')}</Text>
                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', textAlign: 'center', color: 'grey' }}>{this.state.detail_trans.trans_status_display}</Text>
                </View>
                <ScrollView style={styles.body}>

                    <View style={{ flex: 1, flexDirection: 'row', borderBottomWidth: 1, borderColor: 'grey', margin: 10, paddingBottom: 30, padding: 10 }}>
                        <View style={{ flex: 0.1, justifyContent: 'center' }}>
                            <FontAwesome name="map-marker" size={24} color="red" />
                        </View>
                        {
                            this.state.detail_trans.trans_type_display == 'Pick Up' ? (
                                <View style={{ flex: 0.6, justifyContent: 'center' }}>
                                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>{this.state.outlet}</Text>
                                </View>
                            ) : (
                                    <View style={{ flex: 0.6, justifyContent: 'center' }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>{this.state.recipient_address}</Text>
                                    </View>

                                )
                        }
                        {
                            this.state.detail_trans.trans_type_display == 'Pick Up' ? (
                                <View style={{ flex: 0.3, justifyContent: 'center' }}>
                                    <Text style={{ textAlign: 'right', fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>PICKUP</Text>
                                </View>
                            ) : (
                                    <View style={{ flex: 0.3, justifyContent: 'center' }}>
                                        <Text style={{ textAlign: 'right', fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>DELIVERY</Text>
                                    </View>

                                )
                        }
                    </View>
                    <View style={{ margin: 10, paddingLeft: 10 }}>
                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>Pesanan</Text>
                    </View>
                    {
                        this.state.transaction_detail.map((item, index) => {
                            // total = total + item.quantity * item.price
                            return (
                                <View style={{ margin: 10 }} key={index} >
                                    <View style={{ flex: 1, margin: 10, flexDirection: 'row', justifyContent: 'space-around' }}>
                                        <View style={{ flex: 0.3, alignItems: 'center' }}>
                                            {/* <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>{item.item_quantity}</Text> */}
                                            <NumberFormat decimalScale={0} value={item.item_quantity} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>{value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                        </View>
                                        <View style={{ flex: 0.1, alignItems: 'flex-start' }}>
                                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>x</Text>
                                        </View>
                                        <View style={{ flex: 0.3, alignItems: 'baseline' }}>
                                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>{item.item_name} </Text>
                                        </View>
                                        <View style={{ flex: 0.3, alignItems: 'flex-end' }}>
                                            {/* <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>{item.item_quantity * item.item_price} </Text> */}
                                            <NumberFormat decimalScale={0} value={item.item_quantity * item.item_price} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                        </View>
                                    </View>
                                </View>
                            )
                        })
                    }
                    {/* {
                        this.state.detail_trans.used_reward.length < 0 ? (
                            null
                        ) : (
                                <>
                                    <View style={{ borderTopWidth: 1, margin: 10, padding: 10 }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>Voucher</Text>
                                    </View>

                                    <View style={{ flexDirection: 'row', justifyContent: 'space-between', margin: 10, marginTop: -10 }}>
                                        <View style={{ margin: 10, paddingLeft: 10 }}>
                                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>{this.props.voucher.reward.title}</Text>
                                        </View>
                                        <TouchableOpacity onPress={() => this.props.navigation.navigate('Reward Detail', { rewardId: this.props.voucher.id })}>
                                            <View style={{ margin: 10, paddingRight: 5 }}>
                                                <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: '#CFB368' }}>View Detail</Text>
                                            </View>
                                        </TouchableOpacity>
                                    </View>
                                </>
                            )
                    } */}
                    <View style={{ borderTopWidth: 1, borderColor: 'grey', margin: 10, paddingLeft: 10, padding: 20, paddingBottom: -10 }}>
                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>Payment</Text>
                    </View>
                    <View style={{ flexDirection: 'row', justifyContent: 'space-between', margin: 10, marginTop: -10 }}>
                        <View style={{ margin: 10, paddingLeft: 10 }}>
                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>Balance Used</Text>
                        </View>
                        <View style={{ margin: 10, paddingRight: 5 }}>
                            {/* <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>{this.state.detail_trans.trans_paid}</Text> */}
                            <NumberFormat decimalScale={0} value={this.state.detail_trans.trans_paid} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                        </View>
                    </View>
                    <View style={{ flexDirection: 'row', justifyContent: 'space-between', margin: 10, marginTop: -10 }}>
                        <View style={{ margin: 10, paddingLeft: 10 }}>
                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>Point Used</Text>
                        </View>
                        <View style={{ margin: 10, paddingRight: 5 }}>
                            <NumberFormat decimalScale={0} value={this.state.detail_trans.point_booked} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                        </View>
                    </View>
                    <View style={{ borderTopWidth: 1, borderColor: 'grey', margin: 10, paddingLeft: 10, padding: 20, paddingBottom: -10, flexDirection: 'row', justifyContent: 'space-between', flex: 1, flexDirection: 'row' }}>
                        <View style={{ flex: 0.6 }}>
                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>Harga</Text>
                        </View>
                        <View style={{ flex: 0.4, marginRight: -5 }}>
                            <NumberFormat decimalScale={0} value={this.state.detail_trans.trans_subtotal} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey', textAlign: 'right' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                        </View>
                    </View>
                    {
                        this.state.detail_trans.trans_discount == '' ? (
                            null
                        ) : (
                                <View style={{ margin: 10, marginTop: -10, paddingLeft: 10, padding: 20, paddingBottom: -10, flexDirection: 'row', justifyContent: 'space-between', flex: 1, flexDirection: 'row' }}>
                                    <View style={{ flex: 0.6 }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>Voucher</Text>
                                    </View>
                                    <View style={{ flex: 0.4, marginRight: -5 }}>
                                        <NumberFormat decimalScale={0} value={this.state.detail_trans.trans_discount} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey', textAlign: 'right' }}>- Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                    </View>
                                </View>
                            )
                    }
                    {/* {
                        this.props.type_pickup == true ? (
                            null
                        ) : (
                                <View style={{ margin: 10, marginTop: -10, paddingLeft: 10, padding: 20, paddingBottom: -10, flexDirection: 'row', justifyContent: 'space-between', flex: 1, flexDirection: 'row' }}>
                                    <View style={{ flex: 0.6 }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light' }}>Ongkos Kirim</Text>
                                    </View>
                                    <View style={{ flex: 0.4, marginRight: -5 }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', textAlign: 'right' }}>{this.props.grabamount}</Text>
                                    </View>
                                </View>
                            )
                    } */}
                    <View style={{ margin: 10, marginTop: -10, paddingLeft: 10, padding: 20, paddingBottom: -10, flexDirection: 'row', justifyContent: 'space-between', flex: 1, flexDirection: 'row' }}>
                        <View style={{ flex: 0.6 }}>
                            <Text style={{ fontSize: 15, fontFamily: 'Gotham-Black', color: '#CFB368' }}>Total</Text>
                        </View>
                        <View style={{ flex: 0.4, marginRight: -5 }}>
                            <NumberFormat decimalScale={0} value={this.state.detail_trans.trans_total} renderText={value => <Text style={{ fontSize: 15, fontFamily: 'Gotham-Black', textAlign: 'right', color: '#CFB368' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                        </View>
                    </View>



                    {/* <View>
                        <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                            <Text>OUTLET : {this.state.outlet}</Text>
                            <Text>OUTLET CODE : {this.state.outlet_code}</Text>
                            <Text>OUTLET : {this.state.trans_status_display}</Text>
                        </Card>
                        <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                            {
                                this.state.transaction_detail.map((item, index) => {
                                    return (
                                        <View key={index}>
                                            <Text>NAMA ITEM : {item.item_name}</Text>
                                            <Text>QTY : {item.item_quantity}</Text>
                                            <Text>PRICE  : {item.item_price}</Text>
                                            <Text>DISCOUNT : {item.item_discount}</Text>
                                            <View style={{ borderWidth: 1, margin: 10 }}></View>
                                            <Text>TOTAL : {item.item_subtotal}</Text>
                                        </View>
                                    )
                                })
                            }
                        </Card>
                        <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                            <Text>{}</Text>
                        </Card>
                    </View> */}
                </ScrollView>

                {/* <View style={styles.body}>
                    <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                        <Text> Jenis Transaksi : {this.state.trans_type_display}</Text>
                        <Text> Tanggal : {this.state.trans_date}</Text>
                        <Text> Total : {this.state.transTotal}</Text>
                        <Text> Waktu Transaksi  : {this.state.trans_time}</Text>
                        <Text> Poin reduce : {this.state.point_reduce}</Text>
                        <Text> Total : {this.state.outlet_code}</Text>
                        <Text> Total : {this.state.outlet_code}</Text>
                    </Card>

                    <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                        {
                            this.state.transaction_detail.map((item, index) => {
                                return (
                                    <View key={index}>
                                        <Text>NAMA ITEM : {item.item_name}</Text>
                                        <Text>QTY : {item.item_quantity}</Text>
                                        <Text>PRICE  : {item.item_price}</Text>
                                        <Text>DISCOUNT : {item.item_discount}</Text>
                                        <View style={{ borderWidth: 1, margin: 10 }}></View>
                                        <Text>TOTAL : {item.item_subtotal}</Text>
                                    </View>
                                )
                            })
                        }

                    </Card>

                </View> */}
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {
        justifyContent: 'center',
        flex: 0.2,
        borderBottomWidth: 1,
        borderColor: 'grey'
    },

    body: {
        flex: 0.8,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,
        BASE_URL: state.BASE_URL

    }
}

export default connect(mapStateToProps)(TransactionDetail)