import React from 'react';
import { View, Text, Image, StyleSheet, ScrollView, Alert, TouchableOpacity } from 'react-native';
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux';
import Axios from 'axios';
import moment from 'moment'
import ActionType from '../redux/globalActionType';

class RewardSelect extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            rewardsList: [],
            selectedReward: []
        }
    }

    componentDidMount() {
        this.getRewardsList()
        this._unsubscribe = this.props.navigation.addListener('focus', () => {
            this.getRewardsList()

        });
    }

    componentWillUnmount() {
        this._unsubscribe()
    }

    // useVoucher() {
    //     let voucherProps = {
    //         value_voucher: this.state.value,
    //         voucher: this.state.code
    //     }

    //     this.props.setVoucher(voucherProps);
    //     this.props.navigation.navigate('Home', { screen: 'MENU' })

    // }
    
    handleSelect(item) {
        let params = {
            session_id: this.props.session_id,
            reward_id: item.id
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/reward/get_detail', params).then(res => {
            // console.log(res.data.reward)
            let detail = res.data.reward.reward
            let voucherProps = {
                value_voucher: detail,
                voucher: detail
            }
            // console.log(voucherProps)
    
            this.props.setVoucher(voucherProps);
            // this.props.navigation.navigate('Home', { screen: 'MENU' })
            // console.log(this.props.voucher)
            // console.log(this.props.value_voucher)
            this.props.navigation.goBack()
        })
    }
    getRewardsList() {
        let params = {
            session_id: this.props.session_id
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/reward/get_list', params).then(res => {
            let data = res.data.rewards
            // console.log(data)
            data.map((item, key) => {
                // console.log(item.expire_time)
                item.expire_time = moment(item.expire_time).format("DD MMMM YYYY")
            })
            // console.log(data)
            this.setState({
                rewardsList: data
            })

        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.status, response.msg);
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <Text style={{ color: 'white', textAlign: 'center', fontSize: 28 }}>REWARDS E-VOUCHER</Text>
                </View>
                <ScrollView style={styles.body}>
                    {
                        this.state.rewardsList.map((item, key) => (
                            <TouchableOpacity key={key} onPress={() => this.handleSelect(item)}>
                                <View style={{ alignItems: 'center' }}>
                                    <Card style={{ padding: 5, margin: 10 }}>
                                        <View>
                                            <Image source={{ uri: item.reward.title_image }}
                                                resizeMethod="resize"
                                                resizeMode='cover'
                                                style={{ height: 150, width: '100%' }} />
                                        </View>
                                        <View style={{ flexDirection: 'row', justifyContent:'space-between', padding:10 }}>
                                            <View>
                                                <Text style={{fontWeight:'bold', textAlign:'left'}}>{item.reward.title}</Text>
                                                <Text style={{textAlign:'left'}}>{item.reward.subtitle}</Text>
                                            </View>
                                            <View>
                                                <Text style={{textAlign:'right'}}>Expired</Text>
                                                <Text style={{textAlign:'right'}}>{item.expire_time}</Text>
                                            </View>
                                        </View>
                                    </Card>
                                </View>
                            </TouchableOpacity>
                        ))
                    }
                    <TouchableOpacity>
                        <Text style={{ textAlign: 'right', color: '#ccb46c' }}>REDEEM E-VOUCHER HISTORY</Text>
                    </TouchableOpacity>
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {
        flex: 0.1,
        backgroundColor: '#ccb46c',
        justifyContent: 'center'
    },

    body: {
        flex: 3,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,
        value_voucher: state.value_voucher,
        voucher: state.voucher,

    }
}

const mapDispatchToProps = (dispacth) => {
    return {

        setVoucher: (voucherProps) => dispacth({
            type: ActionType.SET_VOUCHER,
            data: {

                voucher: voucherProps.voucher,
                value_voucher: voucherProps.value_voucher,

            }
        }),
    }
}


export default connect(mapStateToProps, mapDispatchToProps)(RewardSelect);