import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, Alert, TouchableOpacity } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import ActionType from '../redux/globalActionType';
import Spinner from 'react-native-loading-spinner-overlay';
import session from '../function/session';

class CardActivation extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            session_id: "",
            mobile_phone: "",
            card_number: "",
            token: "",
            timer: 80,
            onclick: false,
            spinner: false,
        }
    }

    componentDidUpdate(prevProps) {
        if (this.state.timer === 0) {
            clearInterval(this.interval);
        }
    }

    componentWillUnmount() {
        clearInterval(this.interval);
    }

    handleToken() {
        let params = {
            session_id: this.props.session_id,
            mobile_phone: this.state.mobile_phone
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/get_token', params).then(res => {
            this.setState({
                onclick: true
            })
            Alert.alert('Kami telah mengirimkan sms otp ke nomor anda!');
            this.interval = setInterval(
                () => this.setState((prevState) => ({ timer: prevState.timer - 1 })),
                1000
            );
            this.setState({
                onclick: true
            })
        }).catch(error => {
            let response = error.response.data;
            const { navigation } = this.props
            session(response, navigation)
            Alert.alert(response.msg);
        })
    }

    ResendToken() {
        this.setState({
            spinner: true,
        })
        let params = {
            session_id: this.props.session_id,
            mobile_phone: this.state.mobile_phone
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/resend_token', params).then(res => {
            this.setState({
                spinner: false,
            })

            Alert.alert('Kami telah kembali mengirimkan sms otp ke nomor anda!');
            this.setState({
                timer: 80
            })
            this.interval = setInterval(
                () => this.setState((prevState) => ({ timer: prevState.timer - 1 })),
                1000
            );
        }).catch(error => {
            this.setState({
                spinner: false,
            })
            let response = error.response.data;
            Alert.alert('',response.msg);
        })
    }

    handleActivate() {
        this.setState({
            spinner: true,
        })
        let params = {
            session_id: this.props.session_id,
            mobile_phone: this.state.mobile_phone,
            card_number: this.state.card_number,
            token: this.state.token
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/card/activate', params).then(res => {
            Alert.alert("Kartu anda berhasil di aktifkan");
            this.setState({
                spinner: false,
            })
            this.props.navigation.reset({
                index: 0,
                routes: [{ name: 'Home' }],
            })

        }).catch(error => {
            this.setState({
                spinner: false,
            })
            let response = error.response.data;
            Alert.alert('',response.msg);

        })
    }

    render() {
        return (
            <View style={styles.container}>
                <Spinner
                    visible={this.state.spinner}
                    textContent={'Loading...'}
                    textStyle={styles.spinnerTextStyle}
                />

                <View style={styles.form}>
                    <View style={styles.field_phone}>
                        <View style={{ flex: 1, margin: 10 }}>
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 19, textAlign: 'center', marginBottom: 5 }}>Mobile phone</Text>
                            <TextInput
                                style={{ height: 40, borderColor: 'gray', borderWidth: 1, padding: 5, borderRadius: 10,textAlign:'center',fontFamily:'Gotham-Black',color:'grey', fontSize:16}}
                                onChangeText={mobile_phone => this.setState({ mobile_phone })}
                                keyboardType='numeric'
                                value={this.state.mobile_phone}

                            />
                        </View>
                        <View style={styles.button}>
                        <TouchableOpacity style={{top:25}} onPress={() => this.handleToken()}>
                            <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', justifyContent: 'center' }}>
                                <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 20, textAlign: 'center',margin:10 }}>Token</Text>
                            </View>
                        </TouchableOpacity>
                        </View>
                    </View>
                    {
                        this.state.onclick === true ? (<Text style={{ textAlign: 'center',fontFamily:'Gotham-Black' }}> 0:{this.state.timer} </Text>) : (
                            null
                        )
                    }
                    {
                        this.state.timer === 0 ? (
                        <TouchableOpacity onPress={() => this.ResendToken()}>
                            <View style={{ height: 40, borderRadius: 20, backgroundColor: '#CFB368', margin: 20, justifyContent: 'center' }}>
                                <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 20, textAlign: 'center', margin: 15 }}>Resend Token</Text>
                            </View>
                        </TouchableOpacity>
                        ) : (null)}

                    <View style={styles.field_email}>
                        <View style={{ flex: 1, margin: 10 }}>
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 19, textAlign: 'center', marginBottom: 5 }}>Card Number</Text>
                            <TextInput
                                style={{ height: 40, borderColor: 'gray', borderWidth: 1, padding: 5, borderRadius: 10,textAlign:'center',fontFamily:'Gotham-Black',color:'grey', fontSize:16}}
                                onChangeText={card_number => this.setState({ card_number })}
                                value={this.state.card_number}
                                keyboardType='numeric'
                            />
                        </View>
                    </View>
                    <View style={styles.field_email}>
                        <View style={{ flex: 1, margin: 10 }}>
                            <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 19, textAlign: 'center', marginBottom: 5 }}>Token</Text>
                            <TextInput
                                style={{ height: 40, borderColor: 'gray', borderWidth: 1, padding: 5, borderRadius: 10,textAlign:'center',fontFamily:'Gotham-Black',color:'grey', fontSize:16}}
                                onChangeText={token => this.setState({ token })}
                                value={this.state.token}
                                keyboardType='numeric'
                            />
                        </View>
                    </View>
                    <View style={styles.button}>
                        <TouchableOpacity onPress={() => this.handleActivate()}>
                            <View style={{ height: 40, borderRadius: 20, backgroundColor: '#CFB368', margin: 20, justifyContent: 'center' }}>
                                <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 20, textAlign: 'center', margin: 15 }}>ACTIVATE</Text>
                            </View>
                        </TouchableOpacity>
                    </View>
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    form: {
        flex: 3,
        margin: 5,
        marginTop: 50,
    },

    field_email: {
        flexDirection: 'row'
    },

    field_phone: {
        flexDirection: 'row'
    },


    button: {
        height: 50,
        margin: 10,

    }
})

const mapStateToProps = (state) => {
    return {
        session_id: state.session_id,
        set_card: state.set_card
    }
}


export default connect(mapStateToProps)(CardActivation);