import React, { Component, PureComponent } from 'react';
import { StyleSheet, Text, TextInput, View, Button, Alert, TouchableOpacity } from 'react-native';
import Axios from 'axios';
import { BASE_URL_CHANGE_PASSWORD } from '../model/Base_Model';
import { connect } from 'react-redux';

class ChangePassword extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            session_id: '',
            old_password: '',
            Password: '',
            Password_confirmation: '',
        }
    }

    componentDidMount() {

    }

    changePassword() {
        let params = {
            "session_id": this.props.session_id,
            "old_password": this.state.old_password,
            "password": this.state.Password,
            "password_confirmation": this.state.Password_confirmation
        }
        Axios.post(BASE_URL_CHANGE_PASSWORD, params).then(res => {
            this.props.navigation.navigate('Profile');
        }).catch(error => {
            console.log(error)
            let response = error.response;
            Alert.alert('', response.msg);
        })
    }

    render() {
        return (
            <View style={styles.container}>
                {/* <View style={styles.header}>
                    <Text style={{ textAlign: 'center', marginTop: 10, fontSize: 25 }}>Change Password</Text>
                </View> */}
                <View style={styles.form}>

                    <View style={styles.field_token}>
                        <View style={{ marginBottom: 25 }}>
                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: '#CFB368', textAlign: 'center' }}>Current Password</Text>
                        </View>
                        <View style={styles.items2}>
                            <TextInput style={styles.textInput}
                                onChangeText={(old_password) => this.setState({ old_password })}
                                value={this.state.old_password}
                                secureTextEntry={true}
                                textAlign='center' />
                        </View>
                    </View>
                    <View style={styles.field_token}>
                        <View style={{ marginBottom: 25 }}>
                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: '#CFB368', textAlign: 'center' }}>New Password</Text>
                        </View>
                        <View style={styles.items2}>
                            <TextInput style={styles.textInput}
                                onChangeText={(Password) => this.setState({ Password })}
                                value={this.state.Password}
                                secureTextEntry={true}
                                textAlign='center' />
                        </View>
                    </View>
                    <View style={styles.field_token}>
                        <View style={{ marginBottom: 25 }}>
                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: '#CFB368', textAlign: 'center' }}>Repeat Password</Text>
                        </View>
                        <View style={styles.items2}>
                            <TextInput style={styles.textInput}
                                onChangeText={(Password_confirmation) => this.setState({ Password_confirmation })}
                                value={this.state.Password_confirmation}
                                secureTextEntry={true}
                                textAlign='center' />
                        </View>
                    </View>
                    {/* <View style={styles.button}>
                        <Button title="Change Password" onPress={() => this.changePassword()}></Button>
                    </View> */}

                    <TouchableOpacity onPress={() => this.changePassword()}>
                        <View style={styles.button}>
                            <Text style={{ color: 'white', fontSize: 12, fontFamily: 'Gotham-Black' }}>Change Password</Text>
                        </View>
                    </TouchableOpacity>
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    form: {
        flex: 0.8,
        flexDirection: 'column',
    },

    field_token: {
        marginTop: 25
    },

    field_new_password: {
        flexDirection: 'row'
    },

    field_repeat_password: {
        flexDirection: 'row'
    },

    items2: {
        flex: 1,
        height: 35,
        marginHorizontal: 15,
        justifyContent: 'center',
        alignItems: 'stretch',
    },

    textInput: {
        height: 40,
        borderColor: 'gray',
        borderWidth: 1,
        padding: 10,
        margin: 30,
        borderRadius: 10
    },

    button: {
        backgroundColor: '#CFB368',
        marginTop: 50,
        marginHorizontal: 100,
        borderRadius: 15,
        padding:10,
        alignItems: 'center',
        justifyContent: 'center'
    },

});

const mapStateToProps = (state) => {
    return {
        session_id: state.session_id,
    }
}


export default connect(mapStateToProps)(ChangePassword);
