import React from 'react';
import { View, Text, TextInput, StyleSheet, ScrollView, Alert, TouchableOpacity, ActivityIndicator } from 'react-native';
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux';
import Axios from 'axios';
import session from '../function/session';
import moment from 'moment'
import { Divider } from 'react-native-elements';

class OrderHistory extends React.Component {

    constructor(props) {
        super(props)
        this.state = {
            order_list: [],
            indicator: true
        }
    }


    componentDidMount() {
        this.getOrderHistory()
        this._unsubscribe = this.props.navigation.addListener('focus', () => {

            this.setState({
                indicator: true,
            })
            this.getOrderHistory()


        });
    }

    componentWillUnmount() {
        this._unsubscribe();
    }
    // componentDidMount() {
    //     this.getOrderHistory()
    // }

    getOrderHistory() {
        let params = {
            session_id: this.props.session_id
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/transaction/list', params).then(res => {
            let data = res.data.data
            // console.log(data)
            data.map((item) => {
                if (item.trans_status_display == 'On Queue') {
                    item.trans_status_display = 'Queueing'
                } else
                if (item.trans_status_display == 'On Process') {
                    item.trans_status_display = 'Processing'
                } else
                if (item.trans_status_display == 'Ready to Pickup') {
                    item.trans_status_display = 'Ready for Pickup'
                } else
                if (item.trans_status_display == 'On Delivery') {
                    item.trans_status_display = 'Delivering'
                } else
                if (item.trans_status_display == 'On Completed') {
                    item.trans_status_display = 'Completed'
                } else
                if (item.trans_status_display == 'Cancelled') {
                    item.trans_status_display = 'Cancelled'
                }

                // console.log(data)
            })
            this.setState({
                order_list: data,
                indicator: false,
            })
        }).catch(error => {
            let response = error.response.data
            Alert.alert('', response.msg);
            this.setState({
                indicator: false,
            })
        })
    }

    render() {
        // console.log(this.state.order_list)
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <Text style={{ color: 'white', textAlign: 'center', fontSize: 20, fontFamily: 'Gotham-Black' }}>ORDER HISTORY</Text>
                </View>
                <ScrollView style={styles.body}>
                    {this.state.indicator == true ? (<ActivityIndicator style={{ justifyContent: "center" }} size="large" color="#c9af6d" />) :
                        this.state.order_list.length ? (
                            this.state.order_list.map((item, key) => (
                                <TouchableOpacity key={key} onPress={() => this.props.navigation.navigate('Order Detail', { idTrans: item.id })}>
                                    <View style={{ marginTop: 5 }} key={key}>
                                        <View style={{ flex: 2, height: 120, margin: 5, borderRadius: 5, borderWidth: 1, borderColor:'#838383', flexDirection: 'row' }}>
                                            <View style={{ flex:1.1, justifyContent: 'center', margin: 10}}>
                                                <Text style={{ fontFamily: 'Gotham-Black', color: 'grey', fontSize: 12, margin: 2 }}>{item.outlet}</Text>
                                                <Text style={{ fontFamily: 'Gotham-Light', color: 'grey', fontSize: 12, margin: 2 }}>{moment(item.trans_time).format("DD MMMM YYYY, hh:mm A")}</Text>
                                                <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 12, margin: 2 }}>{item.trans_type_display}</Text>
                                                <TouchableOpacity onPress={() => this.props.navigation.navigate('Order Detail', { idTrans: item.id })}>
                                                    <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', justifyContent: 'center', marginVertical:5 }}>
                                                        <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 12, textAlign: 'center',paddingHorizontal:5}}>Lihat Detail Pemesanan</Text>
                                                    </View>
                                                </TouchableOpacity>
                                            </View>
                                            <View style={{ flex:0.9, justifyContent: 'center', alignItems:'center', margin: 10, marginLeft: 15, borderLeftWidth: 1, borderColor: '#838383' }}>
                                                <View>
                                                    <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 12 }}>{item.trans_status_display}</Text>
                                                </View>
                                            </View>
                                        </View>
                                    </View>
                                </TouchableOpacity>
                            ))
                        ) : (
                                <View style={{ justifyContent: 'center', alignItems: 'center', height: 100 }}>
                                    <Text style={{ textAlign: 'left', fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>No Order History</Text>
                                </View>
                            )
                    }
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {
        flex: 0.1,
        backgroundColor: '#ccb46c',
        justifyContent: 'center'
    },

    body: {
        flex: 3,
        margin: 10,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,

    }
}

export default connect(mapStateToProps)(OrderHistory);