
import Auth from './view/Auth';
import { NavigationContainer } from '@react-navigation/native';
import { persistStore, persistReducer } from 'redux-persist';
import { AsyncStorage } from 'react-native';
import { PersistGate } from "redux-persist/integration/react";
import rootReducer from './redux/globalReducer';
import { createStore } from 'redux';
import { Provider } from 'react-redux';
import * as Localization from 'expo-localization';
import i18n from 'i18n-js';
import en from './lib/en';
import id from './lib/id';
import React, { useState, useEffect } from 'react';
import { Alert, Vibration } from 'react-native';
import { AppLoading, Notifications } from 'expo';
import * as Font from 'expo-font';
import * as Sentry from 'sentry-expo';
import Constants from 'expo-constants';

Sentry.init({
  dsn: 'https://ae2449ac801244d99f170140c7cd6d0a@o392471.ingest.sentry.io/5239999',
  enableInExpoDevelopment: true,
  debug: true,
});

Sentry.setRelease(Constants.manifest.revisionId);

export const lang = i18n.translations = {
  en: en,
  id: id
}

export const set_lang = i18n.locale = Localization.locale;
export const fallbacks = i18n.fallbacks = true;

const persistConfig = {
  key: 'root',
  storage: AsyncStorage,
};

const persistReducers = persistReducer(persistConfig, rootReducer)
const store = createStore(persistReducers);
const persistor = persistStore(store)
i18n.locale = Localization.locale;

let customFonts = {
  'Gotham-Black': require('./assets/font/Gotham-Bold-700.otf'),
  'Gotham-SemiBoldItalic': require('./assets/font/Gotham-BoldItalic-400.otf'),
  'Gotham-Thin': require('./assets/font/iCiel-Gotham-Thin.ttf'),
  'Gotham-Light': require('./assets/font/Metropolis-Light.otf'),
};

export default function App() {
  const [fontsLoaded, setfontsLoaded] = useState(false)

  const loadFont = async () => {
    await Font.loadAsync(customFonts);
  };

  const handleNotification = notification => {
    Vibration.vibrate();
    console.log('Notification Payload Data : ' + JSON.stringify(notification.data))
    const data = notification.data;
    Alert.alert(
      data.title,
      data.body,
      [
        {
          text: 'Close',
          onPress: () => console.log('Close'),
          style: 'cancel',
        },
        {
          text: 'View', onPress: () => {
            console.log('Pindah Halaman')
            if (data.action_type == 'Rewards') {
              // props.navigation.navigate('Reward Detail', { rewardId: data.data_id })
            } else if (data.action_type == 'Inbox') {

            } else if (data.action_type == 'Transaction') {

            } else if (data.action_type == 'Review') {

            } else if (data.action_type == 'WebView') {

            } else if (data.action_type == 'Transfer Receive') {

            } else if (data.action_type == 'Cashback') {

            }
          }
        },
      ],
      { cancelable: false },
    )
  }


  useEffect(() => {
    console.log('===> Did Mount');
    this._notificationSubscription = Notifications.addListener(handleNotification);
    loadFont().then(_ => {
      setfontsLoaded(true);
    })
  }, [])

  if (!fontsLoaded) {
    return <AppLoading />;
  } else {
    return (
      <Provider store={store}>
        <PersistGate loading={null} persistor={persistor}>
          <NavigationContainer>
            <Auth />
          </NavigationContainer>
        </PersistGate>
      </Provider>
    );
  }
}
