import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, Alert, TouchableOpacity, Image } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import ActionType from '../redux/globalActionType';
import Spinner from 'react-native-loading-spinner-overlay';
import MyStatusBar from './MyStatusBar';

class ChangeEmail extends React.Component {

    constructor(props) {
        super(props);
        this.state = {
            email: "",
            caretHidden:true
        }
    }

    changeEmail() {

        let paramater = {
            "email": this.state.email,
            "registration_id": this.props.registration_id
        }

        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/auth/register_change_email', paramater).then(res => {
            // console.log(res);
            let loginProps = {
                email: this.state.email

            }
            let emailConfirmProps = {
                isEmailverif: false
            }
            this.props.setChangeEmail(loginProps)
            this.props.setEmailConfirm(emailConfirmProps)
            Alert.alert(
                '',
                'Email terkirim, mohon dicek'
                ,
            )
            this.props.navigation.navigate("Email Confirmation");
        }).catch(error => {

            let response = error.response.data;
            Alert.alert(response.msg);
        })
    }

    render() {
        return (
            <View style={styles.container}>
            <MyStatusBar />
            <Spinner
                visible={this.state.spinner}
                textContent={'Loading...'}
                textStyle={styles.spinnerTextStyle}
            />
            <View style={{ flex: 3 }}>
                <View style={{ flex: 1, marginRight: 30, marginLeft: 30, top: 50 }}>
                    <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>New Email</Text>
                    <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                        onChangeText={(email) => this.setState({ email })}
                        value={this.state.email}
                        autoCapitalize="none"
                        value={this.state.email}
                        keyboardType='email-address' 
                        caretHidden={this.state.caretHidden}
                        onFocus={() => this.setState({caretHidden: false})}/>
                    <TouchableOpacity style={{ height: 100 }} onPress={() => this.changeEmail()}>
                        <View style={{ backgroundColor: '#CFB368', height: 45, top: 20, borderRadius: 10, marginRight: 50, marginLeft: 50 }}>
                            <Text style={{ alignSelf: 'center', top: 10, color: 'white', fontFamily: 'Gotham-Black', fontSize: 20 }}>SUBMIT</Text>
                        </View>
                    </TouchableOpacity>
                </View>
            </View>
            <View style={{ flex: 1, flexDirection: 'row' }}>

                <View style={styles.v_logo}>
                    <View style={{ flex: 1, alignSelf: 'flex-start' }}>
                        <Image resizeMode="contain" source={require('../assets/images/daun.png')} style={styles.logo}></Image>
                    </View>
                    <View style={{ flex: 1 }}>

                    </View>
                </View>

                <View style={{ flex: 0.5 }}>

                </View>
            </View>
        </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    form: {
        flex: 3,
        top: 40,
        margin: 10,
        marginTop: 0,
    },

    field_email: {
        flexDirection: 'row'
    },

    button: {
        height: 40,
        margin: 10,

    },
    logo: {
        alignSelf: 'flex-start',
        marginTop: 50,
        width: 290,
        height: 290,
        bottom: 145,

    },
    v_logo: {
        flex: 2,
        flexDirection: 'column-reverse',
        alignContent: 'flex-start',
    }

})


const mapDispatchToProps = (dispacth) => {
    return {
        setChangeEmail: (params) => dispacth({
            type: ActionType.SET_CHANGE_EMAIL,
            data: {
                email: params.email,
            }
        }),

        setEmailConfirm:(emailConfirmProps) => dispacth({
            type: ActionType.SET_EMAIL_VERIFICATION,
            data:{
                isEmailverif: emailConfirmProps.isEmailverif,
            }
        })
    }
}
const mapStateToProps = (state) => {
    return {
        registration_id: state.registration_id
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(ChangeEmail);



{/* <View style={styles.header}>
                    <Text style={{ textAlign: 'center', marginTop: 10, fontSize: 25 }}>Change Email</Text>
                </View>
                <View style={styles.form}>
                    <View style={styles.field_email}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>Email</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                onChangeText={(email) => this.setState({ email })}
                                value={this.state.email}
                            />

                        </View>
                    </View>
                    <View style={styles.button}>
                        <Button title="Submit" onPress={() => this.changeEmail()}></Button>
                    </View>
                </View> */}