import { Text, TouchableOpacity, View, StyleSheet, TextInput, Alert } from 'react-native';
import React from 'react';
import ActionType from '../redux/globalActionType';
import { connect } from 'react-redux';


class setBaseUrl extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            base_url: "",
        }
    }
    componentDidMount() {
        console.log("INI YAAA: " + this.props.BASE_URL)
    }
    handleSetUrl() {
        if (this.state.base_url == '') {

            let setUrls = {
                BASE_URL:'https://excelsocrm.ravintoladev.com/'
            }
            this.props.setUrlProps(setUrls);
            Alert.alert('','Base Url di setting ke default');
            this.props.navigation.goBack();

        } else {
            let setUrls = {
                BASE_URL: this.state.base_url
            }
            this.props.setUrlProps(setUrls);
            Alert.alert('Berhasil','Berhasil set url')
            this.props.navigation.goBack();
        }
    }

    render() {
        return (
            <View style={{ flex: 1, backgroundColor: 'white' }}>
                <View style={{ flex: 3 }}>
                    <View style={{ flex: 1, marginRight: 30, marginLeft: 30, top: 60 }}>
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>URL</Text>
                        <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 5, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 12 }}
                            onChangeText={(base_url) => this.setState({ base_url })}
                            autoCapitalize="none"/>
                        <TouchableOpacity onPress={()=> this.handleSetUrl()}>
                            <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368', marginTop: 20, justifyContent: 'center' }}>
                                <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 16, textAlign: 'center' }}>CHANGE URL </Text>
                            </View>
                        </TouchableOpacity>
                    </View>
                </View>
            </View>
        )
    }
}

const mapStateToProps = (state) => {
    return {
        BASE_URL: state.BASE_URL
    }
}
const mapDispatchToProps = (dispacth) => {
    return {
        setUrlProps: (setUrls) => dispacth({
            type: ActionType.SET_BASE_URL,
            data: {
                BASE_URL: setUrls.BASE_URL
            }
        }),
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(setBaseUrl)