import * as React from 'react';
import { Button, View, Text, TextInput, StyleSheet, Alert, Platform, Image, TouchableOpacity, StatusBar, ImageBackground, ScrollView } from 'react-native';
import Spinner from 'react-native-loading-spinner-overlay';

export default class WelcomeLog extends React.Component {
    constructor(props) {
        super(props);
        this.state = ({
            spinner: false
        })
    }

    componentDidMount() {
        // console.log(this.props.language)
    }


    render() {

        return (
            <View style={styles.container}>
                <Spinner
                    visible={this.state.spinner}
                    textContent={'Loading...'}
                    textStyle={styles.spinnerTextStyle}
                />
                <StatusBar
                    hidden={true} />

                <ImageBackground source={require('../assets/images/after-log.jpg')} style={{ width: '100%', height: '100%' }}>
                    <View style={styles.v_form}>
                        <View style={{ flex: 1, marginRight: 30, marginLeft: 30, justifyContent: 'center' }}>
                        </View>
                        <View style={{ flex: 1, height: 50, marginRight: 30, marginLeft: 30, justifyContent: 'center' }}>
                        </View>
                        <View style={{ flex: 1, height: 50, marginRight: 70, marginLeft: 70, justifyContent: 'center' }}>
                        </View>
                    </View>
                    <View style={styles.v_policy}>
                        <View style={{ flex: 1, height: 50, marginRight: 70, marginLeft: 70, justifyContent: 'center' }}>
                            <TouchableOpacity onPress={() => this.props.navigation.reset({
                                index: 0,
                                routes: [
                                    {
                                        name: 'Home',
                                        params: { someParam: 'Param9' },
                                    },
                                ],
                            })}>
                                <View style={{ height: 40, borderRadius: 10, backgroundColor: '#CFB368' }}>
                                    <Text style={{ fontFamily: 'Gotham-Black', color: 'white', fontSize: 16, textAlign: 'center', margin:11}}>NEXT</Text>
                                </View>
                            </TouchableOpacity>
                        </View>
                    </View>
                </ImageBackground>
            </View>
        ) 
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: '#151515',
    },
    logo: {
        flex: 2.5,
        height: 50
    },
    imageslogo: {
        height: 170,
        margin: 10,
        width: 150,
        justifyContent: 'center',
        alignSelf: 'center',
        top: 50
    },
    v_form: {
        flex: 3,

    },
    v_policy: {
        flex: 2,
    }
})
