import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, TouchableOpacity, ScrollView, FlatList, Image, Alert, ActivityIndicator, TouchableWithoutFeedback } from 'react-native';
import { connect } from 'react-redux'
import CheckBox from 'react-native-check-box'
import { Card } from 'react-native-shadow-cards'
import { Entypo, Ionicons, MaterialCommunityIcons, MaterialIcons, AntDesign, FontAwesome } from '@expo/vector-icons'
import i18n from 'i18n-js';
import ItemShoping from './ItemShopingCart';
import Axios from 'axios'
import ActionType from '../redux/globalActionType';
import { YellowBox } from 'react-native';
import session from '../function/session';
import NumberFormat from 'react-number-format';
import MyStatusBar from './MyStatusBar';
import Toast from 'react-native-tiny-toast';
import Spinner from 'react-native-loading-spinner-overlay';



YellowBox.ignoreWarnings(['VirtualizedLists should never be nested']);

class ShoppingCart extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            kasproBalance: 0,
            kasproPoint: 0,
            checkedBalance: false,
            checkedPoint: false,
            checkedBalancePoint: false,
            balanceused: 0,
            pointsused: 0,
            ongkir: 0,
            diskon: 0,
            grabtype: '',
            grabamount: '',
            grabpickup: '',
            grabdropoff: '',
            grabdestination: '',
            my_lat: 0,
            my_long: 0,
            indicator: true,
            spinner: false,
            state_add_remove_voucher: false

            // dummyBalance : 155000,
            // dummyPoint : 20000
        }
    }


    componentDidMount() {

        if (!this.props.type_pickup) {
            this.getRate()
        }
        this.getBalance()

        this._unsubscribe = this.props.navigation.addListener('focus', () => {
            if (!this.props.type_pickup) {
                this.getRate()
            }

            this.getBalance()

            // console.log('UPDATE PRICE')

            let params = this.props.route.params;
            if (params != undefined) {
                if (params.outlet_change != undefined && params.outlet_change) {
                    Axios.post(this.props.BASE_URL + 'crm/v2/menu/get_list', {
                        outlet_id: params.outlet_id
                    }).then(res => {
                        let data = res.data.data
                        // console.log('UPDATEING PRICE :' + JSON.stringify(data.menu))
                        this.props.updateMenu(data.menu)
                    })

                }
            }

            if (this.props.value_voucher !== "") {
                this.checkExpiredReward()
            }

        });

        if (this.props.value_voucher !== "") {
            this.checkExpiredReward()
        }
    }
    componentWillUnmount() {
        this._unsubscribe();
    }

    checkExpiredReward() {
        let date_time_now = new Date()
        console.log(date_time_now)
        console.log(this.props.value_voucher.expire_time)
        if (date_time_now > this.props.value_voucher.expire_time) {
            this.props.removeVoucher()
        }
    }

    checkChangeTrans(val) {
        if (val == 'delivery') {
            // let typeProps = {
            // type_pickup: false,
            // }
            // this.props.setTypePickup(typeProps);

            this.setState({
                checkedBalance: false,
                checkedPoint: false,
                checkedBalancePoint: false,
                pointsused: 0,
                balanceused: 0
            })

            let typeProps = {
                type_pickup: false,
            }
            this.props.setTypePickup(typeProps);
            this.props.navigation.navigate("Delivery Address", { from: 'shoppingCart' })
        } else {

            let typeProps = {
                type_pickup: true,
            }
            this.props.setTypePickup(typeProps);
            this.setState({
                checkedBalance: false,
                checkedPoint: false,
                checkedBalancePoint: false,
                pointsused: 0,
                balanceused: 0
            })
            this.props.navigation.navigate('Pickup Name', { from: 'shoppingCart' })
        }
    }

    // BY WAHYU ADJIE PRASETYO
    // FUNGSI INI DI PANGGIL DI SETIAP INPUT DI SHOPING CART

    handleVoucherSelect() {
        //SPINNER ON 
        this.setState({
            spinner: true,
        })
        //CEK TYPE TRANSAKSINYA DELIVERY OR PICKUP, DICEK UNTUK DI MASUKAN DI PARAMATER PEMANGGILAN API
        let type_trans = ""
        if (this.props.type_pickup == true) {
            type_trans = 'Pickup'
        } else {
            type_trans = 'Delivery'
        }

        let params = {
            session_id: this.props.session_id,
            trans_type: type_trans,
            order_item: this.props.order_item,
            reward_id: this.props.voucher.id,
            delivery_charge: this.props.grabamount,
        }
        // MULAI DISINI PEMANGGILAN API DI MULAI, KALAU BERHASIL SET VALUE VOUCHER NYA DAN SPINER DIMATIKAN, KALAU GAGAL CABUT SESSION VOUCHER DAN SPINNER DI MATIKAN
        Axios.post(this.props.BASE_URL + 'crm/v2/reward/get_value', params).then(res => {

            if (this.state.state_add_remove_voucher == true) {
                this.setState({
                    state_add_remove_voucher: false
                })
                this.props.removeVoucher()
                this.setState({
                    spinner: false,
                })
            } else {
                let voucherProps = {
                    value_voucher: res.data.reward,
                    voucher: res.data.reward
                }
                this.props.setVoucher(voucherProps);
                this.setState({
                    spinner: false,
                })
            }
            this.setState({
                spinner: false,
            })

        }).catch(error => {
            try {
                let response = error.response.data
                Alert.alert("", response.msg)
                this.setState({
                    spinner: false,
                })
                // FUNGSI REDUX UNTUK HAPUS VOUCHER
                this.props.removeVoucher()
            } catch (error) {
                Alert.alert("", error.toString())
                this.setState({
                    spinner: false,
                })
            }
        })
    }

    handleRemoveVoucher() {
        //panggil spiner
        if (this.props.value_voucher !== "") {
            this.handleVoucherSelect()
            this.setState({
                state_add_remove_voucher: true
            })
        }
        this.setState({
            checkedBalance: false,
            checkedPoint: false,
            checkedBalancePoint: false,
            pointsused: 0,
            balanceused: 0,
            state_add_remove_voucher: true
        })
        // this.props.removeVoucher()
    }

    handleAddVoucher() {
        if (this.props.value_voucher !== "") {
            this.handleVoucherSelect()
        }

        this.setState({
            checkedBalance: false,
            checkedPoint: false,
            checkedBalancePoint: false,
            pointsused: 0,
            balanceused: 0
        })
        this.props.navigation.navigate('Reward Select')
    }

    handleMin(item, index) {

        this.setState({
            checkedBalance: false,
            checkedPoint: false,
            checkedBalancePoint: false,
            pointsused: 0,
            balanceused: 0
        })
        const list_order_item = this.props.order_item;
        let is_xist = list_order_item.find(row => row.id == item.id)
        if (is_xist) {
            if (is_xist.quantity != 0) {
                const order_item = {
                    id: item.id,
                    name: item.name,
                    price: item.price,

                }

                if (is_xist.quantity == 1) {
                    Alert.alert(
                        i18n.t('alertDeleteItemTitle'),
                        i18n.t('alertDeleteItemContent'),
                        [
                            {
                                text: i18n.t('alertno'),
                                onPress: () => console.log('Cancel Delete Item'),
                                style: 'cancel',
                            },
                            {
                                text: i18n.t('alertyes'), onPress: () => {

                                    this.props.reduceQuantityItem(order_item)
                                    if (this.props.value_voucher !== "") {
                                        this.handleVoucherSelect()
                                    }

                                    if (is_xist.quantity == 0) {
                                        const order_item = {
                                            id: item.id,
                                            name: item.name,
                                            price: item.price,
                                            note: item.note,
                                            image: item.image,
                                            description: item.description,
                                            quantity: item.quantity

                                        }

                                        this.props.removeFromChart(order_item)
                                    }

                                }
                            },
                        ],
                        { cancelable: false },
                    )
                } else {
                    this.props.reduceQuantityItem(order_item)
                    if (this.props.value_voucher !== "") {
                        this.handleVoucherSelect()
                    }
                }
            }
        }

    }


    handleAdd(item, index) {
        this.setState({
            checkedBalance: false,
            checkedPoint: false,
            checkedBalancePoint: false,
            pointsused: 0,
            balanceused: 0
        })
        const order_item = {
            id: item.id,
            code: item.code,
            name: item.name,
            description: item.description,
            note: 'jangan garing',
            price: parseInt(item.price),
        }

        this.props.addToChart(order_item)

        const list_order_item = this.props.order_item;
        let is_xist = list_order_item.find(row => row.id == item.id)
        // console.log("INI YA : " + is_xist)

        let quantity = 0
        if (is_xist) {
            quantity = is_xist.quantity
        }

        if (this.props.value_voucher !== "") {
            this.handleVoucherSelect()
        }

    }

    checkedSelection(val) {
        // console.log(val)
        if (val == 'balance') {
            if (this.props.type_pickup == true) {
                if (this.props.value_voucher == '') {
                    this.setState({
                        checkedBalance: true,
                        checkedPoint: false,
                        checkedBalancePoint: false,
                        balanceused: this.props.order_total,
                        pointsused: 0
                    })
                } else {
                    this.setState({
                        checkedBalance: true,
                        checkedPoint: false,
                        checkedBalancePoint: false,
                        balanceused: Math.max(0, this.props.order_total - this.props.voucher.reward.value),
                        pointsused: 0
                    })
                }
            } else {
                if (this.props.value_voucher == '') {
                    this.setState({
                        checkedBalance: true,
                        checkedPoint: false,
                        checkedBalancePoint: false,
                        balanceused: Math.max(0, this.props.order_total + this.props.grabamount),
                        pointsused: 0
                    })
                } else {
                    this.setState({
                        checkedBalance: true,
                        checkedPoint: false,
                        checkedBalancePoint: false,
                        balanceused: Math.max(0, this.props.order_total - this.props.voucher.reward.value + this.props.grabamount),
                        pointsused: 0
                    })
                }
            }
        } else if (val == 'point') {
            if (this.props.type_pickup == true) {
                if (this.props.value_voucher == '') {
                    this.setState({
                        checkedBalance: false,
                        checkedPoint: true,
                        checkedBalancePoint: false,
                        pointsused: this.props.order_total,
                        balanceused: 0
                    })
                } else {
                    this.setState({
                        checkedBalance: false,
                        checkedPoint: true,
                        checkedBalancePoint: false,
                        pointsused: Math.max(0, this.props.order_total - this.props.voucher.reward.value),
                        balanceused: 0
                    })
                }
            } else {
                if (this.props.value_voucher == '') {
                    this.setState({
                        checkedBalance: false,
                        checkedPoint: true,
                        checkedBalancePoint: false,
                        pointsused: this.props.order_total + this.props.grabamount,
                        balanceused: 0
                    })
                } else {
                    this.setState({
                        checkedBalance: false,
                        checkedPoint: true,
                        checkedBalancePoint: false,
                        pointsused: Math.max(0, this.props.order_total - this.props.voucher.reward.value + this.props.grabamount),
                        balanceused: 0
                    })
                }
            }
        } else {
            this.setState({
                checkedBalance: false,
                checkedPoint: false,
                checkedBalancePoint: true,
            })

            if (this.props.type_pickup == true) {
                if (this.props.value_voucher == '') {
                    if (this.state.kasproPoint - this.props.order_total >= -1) {
                        this.setState({
                            pointsused: this.props.order_total,
                            balanceused: 0
                        })
                    } else {
                        this.setState({
                            balanceused: this.props.order_total - this.state.kasproPoint,
                            pointsused: this.state.kasproPoint
                        })
                    }
                } else {
                    ////////////// JIKA KASPRO POINT TIDAK HABIS DIKURANG TOTAL SETELAH DIKURANGI VOUCHER //////////////////
                    if (this.state.kasproPoint - (parseInt(this.props.order_total) - parseInt(this.props.voucher.reward.value)) >= -1) {
                        this.setState({
                            pointsused: Math.max(0, this.props.order_total - this.props.voucher.reward.value),
                            balanceused: 0
                        })
                    } /////////// JIKA KASPRO POINT KURANG DARI TOTAL SETELAH DIKURANGI VOUCHER/////////
                    else {
                        this.setState({
                            balanceused: (parseInt(this.props.order_total) - parseInt(this.props.voucher.reward.value)) - parseInt(this.state.kasproPoint),
                            pointsused: this.state.kasproPoint
                        })
                    }
                }

            } else {
                if (this.props.value_voucher == '') {
                    if (this.state.kasproPoint - (this.props.order_total + this.props.grabamount) >= -1) {
                        this.setState({
                            pointsused: this.props.order_total + this.props.grabamount,
                            balanceused: 0
                        })
                    } else {
                        this.setState({
                            balanceused: (this.props.order_total + this.props.grabamount) - this.state.kasproPoint,
                            pointsused: this.state.kasproPoint
                        })
                    }
                } else {
                    if (this.state.kasproPoint - (Math.max(0, (parseInt(this.props.order_total) - parseInt(this.props.voucher.reward.value) + this.props.grabamount))) >= -1) {
                        console.log(this.state.kasproPoint - (Math.max(0, (parseInt(this.props.order_total) - parseInt(this.props.voucher.reward.value) + this.props.grabamount))))
                        this.setState({
                            pointsused: (Math.max(0, parseInt(this.props.order_total) - parseInt(this.props.voucher.reward.value) + this.props.grabamount)),
                            balanceused: 0
                        })
                    } else {
                        this.setState({
                            balanceused: ((parseInt(this.props.order_total) - parseInt(this.props.voucher.reward.value)) + this.props.grabamount) - this.state.kasproPoint,
                            pointsused: this.state.kasproPoint
                        })
                    }
                }
            }
        }
    }

    getRate() {

        let params = {
            session_id: this.props.session_id,
            address_id: this.props.addressId,
        }

        // console.log("INI PRAMETER NYA : " + JSON.stringify(params))

        Axios.post(this.props.BASE_URL + 'crm/v2/delivery/rate', params).then(res => {

            this.setState({
                grabamount: res.data.data.amount,
                grabdestination: res.data.data.outlet_name,
            })

            let setGrabProps = {
                grabdestination: this.state.grabdestination,
                grabamount: this.state.grabamount,
            }

            this.props.setGrab(setGrabProps);

            // console.log("INI SUKSES RESPONNYA ")
            let OutletChange = {
                outlet_id: res.data.data.outlet_id,
                name_outlet: res.data.data.outlet_name,
            }

            this.props.setChangeOutletProps(OutletChange);

            let setOrdersProps = {
                balanceUsed: this.state.balanceused,
                pointused: this.state.pointsused,
            }
            this.props.setOrder(setOrdersProps);

        }).catch(error => {
            const { navigation } = this.props
            let response = error.response.data
            session(response, navigation)
            Alert.alert(response.msg);
        })
    }


    onChange() {
        this.setState({
            checkedBalance: false,
            checkedPoint: false,
            checkedBalancePoint: false,
            pointsused: 0,
            balanceused: 0
        })
    }

    checkOut() {
        if (this.props.order_item.length == 0) {
            Alert.alert('Error', i18n.t('alertSelectOrderFirst'))
        } else if (this.state.checkedBalance == false && this.state.checkedPoint == false && this.state.checkedBalancePoint == false) {
            Alert.alert('Error', i18n.t('alertselectpayment'))
        } else if (this.props.value_voucher !== '') {
            if (parseInt(this.props.value_voucher.reward.min_transaction) > parseInt(this.props.order_total)) {
                Alert.alert('', i18n.t('alertBalanceNotEnoughtWithVooucher'))
            } else {
                this.props.navigation.navigate('CONFIRM YOUR ORDER', { balanceUsed: this.state.balanceused, pointused: this.state.pointsused })
            }
        } else {
            this.props.navigation.navigate('CONFIRM YOUR ORDER', { balanceUsed: this.state.balanceused, pointused: this.state.pointsused })

        }
    }

    getBalance() {
        let params = {
            session_id: this.props.session_id,
        }

        Axios.post(this.props.BASE_URL + 'crm/v2/member/get_profile', params).then(res => {
            const { kaspro_balance, kaspro_point } = res.data
            this.setState({
                kasproBalance: kaspro_balance.replace(/,/g, ''),
                kasproPoint: kaspro_point.replace(/,/g, '')
            })

            // console.log(this.state.kasproBalance, this.state.kasproPoint)
        }).catch(error => {
            const { navigation } = this.props
            let response = error.response.data
            session(response, navigation)
            Alert.alert(response.msg);
        })
    }

    addItem() {

        if (this.props.value_voucher !== "") {
            this.handleVoucherSelect()
        }

        this.props.navigation.goBack()
    }


    render() {
        // console.log('tes balance poin selection')
        // console.log(this.props.order_total + ' total belanja')
        // console.log(this.props.grabamount + ' ongkir')
        // console.log(parseInt(this.state.kasproPoint) + parseInt(this.state.kasproBalance) + ' balance dan point')
        // console.log(this.props.order_total + this.props.grabamount + ' total belanja dan ongkir')
        // console.log(this.state.kasproPoint + this.state.kasproBalance >= this.props.order_total + this.props.grabamount && this.state.kasproBalance != 0 && this.state.kasproPoint != 0)

        return (
            <ScrollView style={styles.container}>
                <MyStatusBar />

                <View style={{ flexDirection: 'row', justifyContent: 'center' }}>
                    <Spinner visible={this.state.spinner} textContent={'Loading...'} textStyle={{ color: "white" }} />
                    {/* <TouchableOpacity style={styles.buttonDelivery} onPress={() => this.checkChangeTrans('delivery')}>
                        <Text style={{ textAlign: 'center', color: '#354175', fontWeight: 'bold' }}>{i18n.t('delivery')}</Text>
                    </TouchableOpacity>
                    <TouchableOpacity style={styles.buttonPickup} onPress={() => this.checkChangeTrans('pickup')}>
                        <Text style={{ textAlign: 'center', color: '#fff', fontWeight: 'bold' }}>{i18n.t('pickup')}</Text>
                    </TouchableOpacity> */}
                    {

                        this.props.type_pickup == true ? (
                            <>
                                <TouchableOpacity style={styles.buttonDeliveryFalse} onPress={() => this.checkChangeTrans('delivery')}>
                                    <Text style={{ textAlign: 'center', color: 'white', fontFamily: 'Gotham-Black' }}>{i18n.t('delivery')}</Text>
                                </TouchableOpacity>
                                <TouchableOpacity style={styles.buttonPickupTrue} onPress={() => this.checkChangeTrans('pickup')}>
                                    <Text style={{ textAlign: 'center', color: '#fff', fontFamily: 'Gotham-Black' }}>{i18n.t('pickup')}</Text>
                                </TouchableOpacity>
                            </>
                        ) : (
                                <>
                                    <TouchableOpacity style={styles.buttonDeliveryTrue} onPress={() => this.checkChangeTrans('delivery')}>
                                        <Text style={{ textAlign: 'center', color: '#354175', fontFamily: 'Gotham-Black' }}>{i18n.t('delivery')}</Text>
                                    </TouchableOpacity>
                                    <TouchableOpacity style={styles.buttonPickupFalse} onPress={() => this.checkChangeTrans('pickup')}>
                                        <Text style={{ textAlign: 'center', color: '#fff', fontFamily: 'Gotham-Black' }}>{i18n.t('pickup')}</Text>
                                    </TouchableOpacity>
                                </>
                            )

                    }

                </View>
                <View style={{ alignItems: 'center' }}>
                    {

                        this.props.type_pickup == true ? (
                            <View style={{ margin: 5, padding: 10 }}>
                                <Text style={{ textAlign: 'center', fontFamily: 'Gotham-Black', fontSize: 12, color: 'grey' }}>{i18n.t('orderInfo')}</Text>
                                <Text style={{ textAlign: 'center', fontSize: 14, top: 5, fontFamily: 'Gotham-Black', color: 'grey' }}>{this.props.name_outlet}</Text>
                                <Text style={{ textAlign: 'center', fontSize: 12, top: 5, fontFamily: 'Gotham-Light', color: 'grey' }}>{this.props.outlet_detailadress}</Text>
                            </View>
                        ) : (
                                <View style={{ margin: 5, padding: 10 }}>
                                    <Text style={{ textAlign: 'center', fontFamily: 'Gotham-Black', fontSize: 12, color: 'grey' }}>{i18n.t('deliveryinfo')}</Text>
                                    <Text style={{ textAlign: 'center', fontSize: 14, top: 5, fontFamily: 'Gotham-Black', color: 'grey' }}>{this.props.home_address}</Text>
                                    <Text style={{ textAlign: 'center', fontSize: 12, top: 5, fontFamily: 'Gotham-Light', color: 'grey' }}>{this.props.address}</Text>
                                </View>
                            )
                    }
                </View>
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', fontSize: 12, fontFamily: 'Gotham-Black', color: 'grey' }}>{i18n.t('yourOrders')}</Text>
                    <TouchableOpacity style={{ marginRight: -8 }} onPress={() => this.addItem()}>
                        <Text style={{ textAlign: 'center', fontSize: 12, color: '#CFB368', fontFamily: 'Gotham-Light' }}>{i18n.t('addMore')}</Text>
                    </TouchableOpacity>
                </View>
                <View style={styles.order}>
                    <FlatList
                        data={this.props.order_item}
                        renderItem={({ item, index }) => (
                            <ItemShoping navigation={this.props.navigation}
                                item={item}
                                handleAdd={() => this.handleAdd(item, index)}
                                handleMin={() => this.handleMin(item, index)}
                                onChange={() => this.onChange(item, index)}
                            />
                        )}
                        keyExtractor={item => item.id}
                    />
                </View>
                <View style={styles.voucher}>
                    {
                        this.props.value_voucher == '' ? (
                            <TouchableOpacity onPress={() => this.handleAddVoucher()}>
                                <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: '#CFB368' }}>{i18n.t('addVoucher')}</Text>
                            </TouchableOpacity>
                        ) : (

                                <View style={{ flex: 1, flexDirection: 'row', justifyContent: 'space-between' }}>
                                    <View style={{ flex: 0.5 }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: '#838383' }}>{this.props.voucher.reward.title}</Text>
                                    </View>
                                    <View style={{ flex: 0.5, alignItems: 'flex-end', marginRight: -5 }}>
                                        <TouchableOpacity onPress={() => this.handleRemoveVoucher()}>
                                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: '#CFB368' }}>{i18n.t('removeVoucher')}</Text>
                                        </TouchableOpacity>
                                    </View>
                                </View>
                            )
                    }
                </View>
                <View style={styles.payment}>
                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'grey' }}>{i18n.t('paymentMethods')}</Text>
                </View>
                {
                    this.props.value_voucher == '' ? (
                        <>
                            <View style={{ alignItems: 'center' }}>

                                {

                                    this.state.kasproBalance < this.props.order_total + this.props.grabamount || this.props.order_total == 0 ? (
                                        <Card style={{ margin: 5, padding: 10, backgroundColor: 'gray' }}>
                                            <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                                <View>
                                                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'white' }}>EXCELSO {i18n.t('balance')}</Text>
                                                </View>
                                                <View>
                                                    <FontAwesome name='circle-o' size={30} color={'#ccb46c'} />
                                                </View>
                                            </View>
                                        </Card>
                                    ) : (
                                            <TouchableOpacity onPress={() => {
                                                this.checkedSelection('balance')
                                            }}>
                                                <Card style={{ margin: 5, padding: 10 }}>
                                                    <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                                        <View>
                                                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'grey' }}>EXCELSO {i18n.t('balance')}</Text>
                                                        </View>
                                                        <View>
                                                            <CheckBox
                                                                onClick={() => {
                                                                    this.checkedSelection('balance')
                                                                }}
                                                                isChecked={this.state.checkedBalance}
                                                                checkedImage={<FontAwesome name='check-circle' size={30} color={'#ccb46c'} />}
                                                                unCheckedImage={<FontAwesome name='circle-o' size={30} color={'#ccb46c'} />}
                                                            />
                                                        </View>
                                                    </View>
                                                </Card>
                                            </TouchableOpacity>
                                        )
                                }
                            </View>
                            <View style={{ alignItems: 'center', display: 'none' }}>
                                {
                                    this.state.kasproPoint < this.props.order_total + this.props.grabamount || this.props.order_total == 0 ? (
                                        <Card style={{ margin: 5, padding: 10, backgroundColor: 'gray' }}>
                                            <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                                <View>
                                                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'white' }}>EXCELSO {i18n.t('point')}</Text>
                                                </View>
                                                <View>
                                                    <FontAwesome name='circle-o' size={30} color={'#ccb46c'} />
                                                </View>
                                            </View>
                                        </Card>
                                    ) : (

                                            <TouchableOpacity onPress={() => {
                                                this.checkedSelection('point')
                                            }}>
                                                <Card style={{ margin: 5, padding: 10 }}>
                                                    <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                                        <View>
                                                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'grey' }}>EXCELSO {i18n.t('point')}</Text>
                                                        </View>
                                                        <View>
                                                            <CheckBox
                                                                onClick={() => {
                                                                    this.checkedSelection('point')
                                                                }}
                                                                isChecked={this.state.checkedPoint}
                                                                checkedImage={<FontAwesome name='check-circle' size={30} color={'#ccb46c'} />}
                                                                unCheckedImage={<FontAwesome name='circle-o' size={30} color={'#ccb46c'} />}
                                                            />
                                                        </View>
                                                    </View>
                                                </Card>
                                            </TouchableOpacity>
                                        )
                                }
                            </View>
                            <View style={{ alignItems: 'center', display: 'none' }}>
                                {
                                    parseInt(this.state.kasproPoint) + parseInt(this.state.kasproBalance) >= this.props.order_total + this.props.grabamount && this.state.kasproBalance != 0 && this.state.kasproPoint != 0 && this.props.order_total != 0 ? (
                                        <TouchableOpacity onPress={() => {
                                            this.checkedSelection('balancepoint')
                                        }}>
                                            <Card style={{ margin: 5, padding: 10 }}>
                                                <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                                    <View>
                                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'grey' }}>EXCELSO {i18n.t('balance')} + {i18n.t('point')}</Text>
                                                    </View>
                                                    <View>
                                                        <CheckBox
                                                            onClick={() => {
                                                                this.checkedSelection('balancepoint')
                                                            }}
                                                            isChecked={this.state.checkedBalancePoint}
                                                            checkedImage={<FontAwesome name='check-circle' size={30} color={'#ccb46c'} />}
                                                            unCheckedImage={<FontAwesome name='circle-o' size={30} color={'#ccb46c'} />}
                                                        />
                                                    </View>
                                                </View>
                                            </Card>
                                        </TouchableOpacity>

                                    ) : (
                                            <Card style={{ margin: 5, padding: 10, backgroundColor: 'gray' }}>
                                                <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                                    <View>
                                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'white' }}>EXCELSO {i18n.t('balance')} + {i18n.t('point')}</Text>
                                                    </View>
                                                    <View>
                                                        <FontAwesome name='circle-o' size={30} color={'#ccb46c'} />
                                                    </View>
                                                </View>
                                            </Card>

                                        )
                                }
                            </View>
                        </>
                    ) : (
                            <>
                                <View style={{ alignItems: 'center' }}>

                                    {

                                        this.state.kasproBalance < this.props.order_total - parseInt(this.props.voucher.reward.value) + this.props.grabamount || this.props.order_total == 0 ? (
                                            <Card style={{ margin: 5, padding: 10, backgroundColor: 'gray' }}>
                                                <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                                    <View>
                                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'white' }}>EXCELSO {i18n.t('balance')}</Text>
                                                    </View>
                                                    <View>
                                                        <FontAwesome name='circle-o' size={30} color={'#ccb46c'} />
                                                    </View>
                                                </View>
                                            </Card>
                                        ) : (
                                                <TouchableOpacity onPress={() => {
                                                    this.checkedSelection('balance')
                                                }}>
                                                    <Card style={{ margin: 5, padding: 10 }}>
                                                        <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                                            <View>
                                                                <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'grey' }}>EXCELSO {i18n.t('balance')}</Text>
                                                            </View>
                                                            <View>
                                                                <CheckBox
                                                                    onClick={() => {
                                                                        this.checkedSelection('balance')
                                                                    }}
                                                                    isChecked={this.state.checkedBalance}
                                                                    checkedImage={<FontAwesome name='check-circle' size={30} color={'#ccb46c'} />}
                                                                    unCheckedImage={<FontAwesome name='circle-o' size={30} color={'#ccb46c'} />}
                                                                />
                                                            </View>
                                                        </View>
                                                    </Card>
                                                </TouchableOpacity>
                                            )
                                    }
                                </View>
                                <View style={{ alignItems: 'center', display: 'none' }}>
                                    <TouchableOpacity activeOpacity={1} onPress={() => { Toast.show(i18n.t('alertVoucher')) }}>
                                        <Card style={{ margin: 5, padding: 10, backgroundColor: 'gray' }}>
                                            <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                                <View>
                                                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'white' }}>EXCELSO {i18n.t('point')}</Text>
                                                </View>
                                                <View>
                                                    <FontAwesome name='circle-o' size={30} color={'#ccb46c'} />
                                                </View>
                                            </View>
                                        </Card>
                                    </TouchableOpacity>

                                </View>
                                <View style={{ alignItems: 'center', display: 'none' }}>
                                    <TouchableOpacity activeOpacity={1} onPress={() => { Toast.show(i18n.t('alertVoucher')) }}>
                                        <Card style={{ margin: 5, padding: 10, backgroundColor: 'gray' }}>
                                            <View style={{ flexDirection: 'row', justifyContent: 'space-between', alignItems: 'center' }}>
                                                <View>
                                                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'white' }}>EXCELSO {i18n.t('balance')} + {i18n.t('point')}</Text>
                                                </View>
                                                <View>
                                                    <FontAwesome name='circle-o' size={30} color={'#ccb46c'} />
                                                </View>
                                            </View>
                                        </Card>
                                    </TouchableOpacity>
                                </View>
                            </>
                        )
                }
                <View style={{ alignItems: 'center', }}>
                    <Card style={{ margin: 5, padding: 10 }}>
                        <View style={{ flexDirection: 'row', justifyContent: 'space-between', marginBottom: 5 }}>
                            <View>
                                <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>{i18n.t('yourBalance')}</Text>
                                <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey', display: 'none' }}>{i18n.t('yourPoints')}</Text>
                            </View>
                            <View style={{ alignItems: 'flex-end' }}>
                                <NumberFormat decimalScale={0} value={this.state.kasproBalance} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                <NumberFormat decimalScale={0} value={this.state.kasproPoint} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey', display: 'none' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                            </View>
                        </View>
                        <View style={{ flexDirection: 'row', justifyContent: 'space-between', borderTopWidth: 1, borderColor: 'grey' }}>
                            <View style={{ marginTop: 5 }}>
                                <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>{i18n.t('yourBalanceUsed')}</Text>
                                <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey', display: 'none' }}>{i18n.t('yourPointsUsed')}</Text>
                            </View>
                            <View style={{ marginTop: 5, alignItems: 'flex-end' }}>
                                <NumberFormat decimalScale={0} value={this.state.balanceused} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey' }}>- Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                <NumberFormat decimalScale={0} value={this.state.pointsused} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'grey', display: 'none' }}>- Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                            </View>
                        </View>
                    </Card>
                </View>

                <View style={styles.paymentDetails}>
                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Black', color: 'grey' }}>{i18n.t('paymentDetails')}</Text>
                </View>
                <View style={{ marginHorizontal: 10 }}>
                    {/* <Text style={{ paddingLeft: 20, paddingTop: 15, color: 'gray' }}>Detail Pembayaran</Text> */}
                    <View style={{ flexDirection: 'row', justifyContent: 'space-between' }}>
                        <View style={{ paddingLeft: 20 }}>
                            <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'gray' }}>{i18n.t('price')}</Text>
                        </View>
                        <View style={{ alignItems: 'flex-end', paddingRight: 20 }}>
                            <NumberFormat decimalScale={0} value={this.props.order_total} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'gray' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                        </View>
                    </View>
                    {this.props.type_pickup == true ? (
                        null
                    ) : (

                            <View style={{ flexDirection: 'row', justifyContent: 'space-between' }}>
                                <View style={{ paddingLeft: 20, paddingTop: 5, }} >
                                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'gray' }}>{i18n.t('rateDelivery')}</Text>
                                </View>
                                {this.props.order_item.length ? (
                                    <View style={{ paddingRight: 20, paddingTop: 5, alignItems: 'flex-end' }}>
                                        {/* <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'gray' }}>{this.props.grabamount}</Text> */}
                                        <NumberFormat decimalScale={0} value={this.props.grabamount} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'gray' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                    </View>
                                ) : (<View style={{ paddingRight: 20, paddingTop: 5, alignItems: 'flex-end' }}>
                                    <NumberFormat decimalScale={0} value={0} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'gray' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                </View>)}
                            </View>)}

                    {
                        this.props.value_voucher == '' ? (
                            null
                        ) : (
                                <View style={{ flexDirection: 'row', justifyContent: 'space-between' }}>
                                    <View style={{ paddingLeft: 20, paddingTop: 5, }}>
                                        <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'gray' }}>{i18n.t('discount')}</Text>
                                    </View>
                                    <View style={{ paddingRight: 20, paddingTop: 5, alignItems: 'flex-end' }}>
                                        <NumberFormat decimalScale={0} value={this.props.voucher.reward.value} renderText={value => <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'gray' }}>- Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                    </View>
                                </View>

                            )
                    }

                    <View style={{ flexDirection: 'row', justifyContent: 'space-between' }}>
                        <View style={{ marginTop: 10, paddingLeft: 20 }}>
                            <Text style={{ fontSize: 20, color: '#CFB368', fontFamily: 'Gotham-Black', }}>{i18n.t('total')}</Text>
                        </View>
                        {this.props.type_pickup == true ? (
                            <View style={{ marginTop: 10, paddingRight: 20, alignItems: 'flex-end' }}>
                                {
                                    this.props.value_voucher == '' ? (
                                        <NumberFormat decimalScale={0} value={this.props.order_total} renderText={value => <Text style={{ fontSize: 20, color: '#CFB368', fontFamily: 'Gotham-Black' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                    ) : (
                                            <NumberFormat decimalScale={0} value={Math.max(0, this.props.order_total - this.props.voucher.reward.value)} renderText={value => <Text style={{ fontSize: 20, color: '#CFB368', fontFamily: 'Gotham-Black' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                        )
                                }
                            </View>
                        ) : (
                                <View style={{ marginTop: 10, paddingRight: 20, alignItems: 'flex-end' }}>
                                    {/* {this.props.order_item.length ? (
                                        <Text style={{ fontSize: 35, color: '#ccb46c' }}>{Math.max(0, this.props.order_total - this.props.voucher.reward.value + this.props.grabamount)}</Text>
                                    ) : (
                                            <Text style={{ fontSize: 35, color: '#ccb46c' }}>{this.props.order_total + this.state.diskon}</Text>
                                        )} */}
                                    {this.props.value_voucher == '' ? (
                                        <>
                                            {
                                                this.props.order_item.length ? (
                                                    <NumberFormat decimalScale={0} value={this.props.order_total + this.props.grabamount} renderText={value => <Text style={{ fontSize: 20, color: '#CFB368', fontFamily: 'Gotham-Black' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                                ) : (
                                                        <NumberFormat decimalScale={0} value={0} renderText={value => <Text style={{ fontSize: 20, color: '#CFB368', fontFamily: 'Gotham-Black' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                                    )
                                            }
                                        </>
                                    ) : (
                                            <>
                                                {
                                                    this.props.order_item.length ? (

                                                        <NumberFormat decimalScale={0} value={Math.max(0, this.props.order_total - this.props.voucher.reward.value + this.props.grabamount)} renderText={value => <Text style={{ fontSize: 20, color: '#CFB368', fontFamily: 'Gotham-Black' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                                    ) : (
                                                            <NumberFormat decimalScale={0} value={0} renderText={value => <Text style={{ fontSize: 20, color: '#CFB368', fontFamily: 'Gotham-Black' }}>Rp. {value}</Text>} displayType={'text'} thousandSeparator={true} prefix={''} />
                                                        )
                                                }
                                            </>
                                        )}

                                </View>
                            )}
                    </View>

                    {/* {this.props.type_pickup == true ? (
                        <View style={{ flex: 1, flexDirection: 'row', marginTop: 10, justifyContent: 'space-between' }}>
                            <View style={{ paddingLeft: 20, flex: 0.5 }}>
                                <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'gray' }}>Diambil di</Text>
                            </View>
                            <View style={{ paddingRight: 30, flex: 0.5, alignItems: 'flex-end' }}>
                                <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: '#CFB368', textAlign: 'right' }}>{this.props.name_outlet}</Text>
                            </View>
                        </View>
                    ) : (
                            <View style={{ flex: 1, flexDirection: 'row', marginTop: 10, justifyContent: 'space-between' }}>
                                <View style={{ paddingLeft: 20, flex: 0.5 }}>
                                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: 'gray' }}>Diantar ke</Text>
                                </View>
                                <View style={{ paddingRight: 30, flex: 0.5, alignItems: 'flex-end' }}>
                                    <Text style={{ fontSize: 12, fontFamily: 'Gotham-Light', color: '#CFB368', textAlign: 'right' }}>{this.props.address}</Text>
                                </View>
                            </View>
                        )} */}

                    {/* <View style={{ margin: 20, }}>
                        {/* <Button title='Checkout' color='#CFB368' onPress={() => this.checkOut()} /> */}
                    {/* </View> */}
                    <TouchableOpacity onPress={() => this.checkOut()}>
                        <View style={styles.button}>
                            <Text style={{ color: 'white', fontSize: 16, fontFamily: 'Gotham-Black' }}>{i18n.t('checkout')}</Text>
                        </View>
                    </TouchableOpacity>
                </View>
            </ScrollView>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.2,
        marginHorizontal: 10,
        padding: 20,
        borderBottomWidth: 1,
        borderTopWidth: 1,
        borderColor: 'grey',
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'space-between'
    },

    order: {
        flex: 1,
        margin: 10,
        backgroundColor: '#fff'
    },

    payment: {
        flex: 1,
        margin: 10,
        padding: 20,
        borderTopWidth: 1,
        borderBottomWidth: 1,
        borderColor: 'grey'
        // backgroundColor: 'lightblue'
    },

    voucher: {
        flex: 1,
        marginHorizontal: 10,
        padding: 20,
        borderTopWidth: 1,
        borderBottomWidth: 1,
        borderColor: 'grey'
        // backgroundColor: 'lightblue'
    },

    paymentDetails: {
        flex: 1,
        margin: 10,
        padding: 20,
        borderTopWidth: 1,
        borderBottomWidth: 1,
        borderColor: 'grey'
        // backgroundColor: 'lightblue'
    },
    button: {
        backgroundColor: '#CFB368',
        marginVertical: 25,
        marginHorizontal: 30,
        borderRadius: 10,
        height: 40,
        alignItems: 'center',
        justifyContent: 'center'
    },
    buttonDeliveryTrue: {
        justifyContent: 'center',
        height: 40,
        marginTop: 10,
        // paddingTop: 15,
        // paddingBottom: 15,
        marginRight: 0,
        marginLeft: 0,
        backgroundColor: '#cce8f0',
        borderRadius: 10,
        borderWidth: 0,
        borderColor: '#fff',
        width: '50%',
        top: 0,
    },
    buttonDeliveryFalse: {
        justifyContent: 'center',
        height: 40,
        marginTop: 10,
        // paddingTop: 15,
        // paddingBottom: 15,
        marginRight: 0,
        marginLeft: 0,
        backgroundColor: '#838383',
        borderRadius: 10,
        borderWidth: 0,
        borderColor: '#fff',
        width: '50%',
        top: 0,
    },
    buttonPickupTrue: {
        justifyContent: 'center',
        height: 40,
        marginTop: 10,
        // paddingTop: 15,
        // paddingBottom: 15,
        marginRight: 0,
        marginLeft: -30,
        backgroundColor: '#354175',
        borderRadius: 10,
        borderWidth: 0,
        borderColor: '#fff',
        width: '40%',
        top: 0,
    },
    buttonPickupFalse: {
        justifyContent: 'center',
        height: 40,
        marginTop: 10,
        // paddingTop: 15,
        // paddingBottom: 15,
        marginRight: 0,
        marginLeft: -30,
        backgroundColor: '#838383',
        borderRadius: 10,
        borderWidth: 0,
        borderColor: '#fff',
        width: '40%',
        top: 0,
    },

    shadowEdit: {
        height: 30,
        width: 25,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 10,
    },
    shadowAdd: {
        height: 30,
        width: 75,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 10,
        flexDirection: 'row'
    },
    shadowMin: {
        height: 20,
        width: 20,
        borderWidth: 1,
        borderRadius: 2,
        borderColor: '#ddd',
        borderBottomWidth: 0,
        shadowColor: '#000',
        shadowOffset: { width: 0, height: 2 },
        shadowOpacity: 0.8,
        shadowRadius: 2,
        elevation: 1,
        marginLeft: 5,
        marginRight: 5,
        marginTop: 10,
    }


})


const mapDispatchToProps = (dispacth) => {
    return {
        updateMenu: (menu) => dispacth({
            type: ActionType.UPDATE_MENU,
            data: {
                menu: menu
            }
        }),
        setChangeOutletProps: (OutletChange) => dispacth({
            type: ActionType.SET_CHANGE_OUTLET,
            data: {

                outlet_id: OutletChange.outlet_id,
                name_outlet: OutletChange.name_outlet,

            }
        }),

        addToChart: (item) => dispacth({
            type: ActionType.ADD_TO_CHART,
            data: {
                item: item
            }
        }),
        //REDUCE QUANTITY ITEM
        reduceQuantityItem: (item) => dispacth({
            type: ActionType.REDUCE_QUANTITY_ITEM,
            data: {
                item: item
            }
        }),
        removeFromChart: (item) => dispacth({
            type: ActionType.REMOVE_FROM_CHART,
            data: {
                item: item
            }
        }),

        setGrab: (setGrabProps) => dispacth({
            type: ActionType.SET_GRAB,
            data: {
                grabtype: setGrabProps.grabtype,
                grabamount: setGrabProps.grabamount,
                grabpickup: setGrabProps.grabpickup,
                grabdropoff: setGrabProps.grabdropoff,
                grabdestination: setGrabProps.grabdestination,
            }
        }),
        setOrder: (setOrdersProps) => dispacth({
            type: ActionType.SET_ORDERS,
            data: {
                balanceUsed: setOrdersProps.balanceUsed,
                pointused: setOrdersProps.pointused,
            }
        }),
        setTypePickup: (typeProps) => dispacth({
            type: ActionType.SET_TYPE,
            data: {

                type_pickup: typeProps.type_pickup

            }
        }),
        removeVoucher: () => dispacth({
            type: ActionType.REMOVE_VOUCHER
        }),

        setVoucher: (voucherProps) => dispacth({
            type: ActionType.SET_VOUCHER,
            data: {

                voucher: voucherProps.voucher,
                value_voucher: voucherProps.value_voucher,

            }
        }),
    }
}

const mapStateToProps = (state) => {
    return {
        outlet_detailadress: state.outlet_detailadress,
        home_address: state.home_address,
        type_pickup: state.type_pickup,
        value_voucher: state.value_voucher,
        voucher: state.voucher,
        session_id: state.session_id,
        outlet_id: state.outlet_id,
        name_outlet: state.name_outlet,
        value_voucher: state.value_voucher,
        voucher: state.voucher,
        order_quantity: state.order_quantity,
        order_total: state.order_total,
        order_item: state.order_item,
        quantity: state.quantity,
        address: state.address,
        addressId: state.addressId,
        grabtype: state.grabtype,
        grabamount: state.grabamount,
        grabpickup: state.grabpickup,
        grabdropoff: state.grabdropoff,
        grabdestination: state.grabdestination,
        BASE_URL: state.BASE_URL,

    }
}

export default connect(mapStateToProps, mapDispatchToProps)(ShoppingCart)
