import React from 'react';
import { View, Text, TextInput, StyleSheet, ScrollView, Alert, TouchableOpacity } from 'react-native';
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux';
import Axios from 'axios';

class OrderDetail extends React.Component {

    constructor(props) {
        super(props)
        this.state = {
            trans_type_display:'',
            outlet:'',
            outlet_code:'',
            trans_status_display:'',
            transaction_detail:[],
        }
    }


    componentDidMount() {

        this.getDetailTrans()

    }

    getDetailTrans() {
        let params = {
            session_id: this.props.session_id,
            transaction_id: this.props.route.params.idTrans
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/transaction/detail', params).then(res => {
            let data = res.data
            console.log("INI OUTLET "+ data.outlet)
            console.log("OUTLET-CODE" + data.outlet_code)
            console.log("TRANS-DISPLAY" + data.trans_type_display)

            this.setState({
                outlet: data.outlet,
                outlet_code: data.outlet_code,
                trans_status_display: data.trans_status_display,
                transaction_detail: data.transaction_detail
                
            })
        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.msg);
        })
    }

    render() {
        // console.log(this.state.order_list)
        return (
            <View style={styles.container}>
                <ScrollView style={styles.body}>
                            <View>
                                <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                                    <Text>OUTLET : {this.state.outlet}</Text>
                                    <Text>OUTLET CODE : {this.state.outlet_code}</Text>
                                    <Text>OUTLET : {this.state.trans_status_display}</Text>
                                </Card>
                                <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                                    {
                                        this.state.transaction_detail.map((item,index)=>{
                                            return(
                                            <View key={index}>
                                            <Text>NAMA ITEM : {item.item_name}</Text>
                                            <Text>QTY : {item.item_quantity}</Text>
                                            <Text>PRICE  : {item.item_price}</Text>
                                            <Text>DISCOUNT : {item.item_discount}</Text>
                                            <View style={{borderWidth:1, margin:10}}></View>
                                            <Text>TOTAL : {item.item_subtotal}</Text>
                                            </View>
                                            )
                                        })
                                    }
                                </Card>
                                <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                                        <Text>{}</Text>
                                </Card>
                            </View>
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {

        flex: 0.2,
    },

    body: {
        flex: 3,
        margin: 5,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,

    }
}

export default connect(mapStateToProps)(OrderDetail);