import React from 'react';
import { View, Text, TextInput, StyleSheet, ScrollView, Alert, TouchableOpacity } from 'react-native';
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux';
import Axios from 'axios';

class OrderHistory extends React.Component {

    constructor(props) {
        super(props)
        this.state = {
            order_list: []
        }
    }


    componentDidMount() {

        this.getOrderHistory()

    }

    getOrderHistory() {
        let params = {
            session_id: this.props.session_id
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/transaction/list', params).then(res => {
            let data = res.data.data
            console.log(data)
            this.setState({
                order_list: data
            })
        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.msg);
        })
    }

    render() {
        // console.log(this.state.order_list)
        return (
            <View style={styles.container}>
                <ScrollView style={styles.body}>
                    
                    {
                        this.state.order_list.map((item, key) => (
                            <TouchableOpacity key={key} onPress={() => this.props.navigation.navigate('Order Detail', {idTrans:item.id})}>
                            <View key={key}>
                                <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                                    <Text>OUTLET : {item.outlet}</Text>
                                    <Text>TGL TRANSAKSI : {item.trans_date}</Text>
                                    <Text>TOTAL : {item.trans_total}</Text>
                                    <Text>STATUS : {item.trans_status_display}</Text>
                                </Card>
                            </View>
                            </TouchableOpacity>
                        ))
                    }
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {

        flex: 0.2,
    },

    body: {
        flex: 3,
        margin: 5,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,

    }
}

export default connect(mapStateToProps)(OrderHistory);