import React from 'react';
import { View, Text, StyleSheet, Button, Alert } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';

class Renewal extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            current_balance: "",
            expired: "",
            card_number: "",
            biaya_renewal: "100.000",
            renew_until: "",
        }
    }

    componentDidMount() {
        this._getProfile();
    }


    _renewal() {
        let params = {
            session_id: this.props.session_id
        }
        console.log(params);
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/card/renewal', params).then(res => {
            // console.log('ini res ' + JSON.stringify(res.data))
            this._getProfile();
            Alert.alert('Renewal Berhasil');
        }).catch(error => {
            let response = error.response.data;
            console.log(response.msg)
            Alert.alert(response.msg);
        })
    }

    _getProfile() {
        let params = {
            session_id: this.props.session_id
        }

        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/member/get_profile', params).then(res => {
            console.log('ini res ' + JSON.stringify(res.data))
            const dataCard = res.data

            let balance = dataCard.kaspro_balance
            let expired = dataCard.expire_date
            let c_renew_until = dataCard.expire_date

            var date_string = c_renew_until
            var date_arr = date_string.split('-');
            var date = new Date(date_arr[0], date_arr[1], date_arr[2]);
            
            date.setFullYear(date.getFullYear() + 1);
            let date_nextyear_string = date.getFullYear() + "-" + date.getMonth() + "-" + date.getDate()
            
            this.setState({
                current_balance: balance,
                expired: expired,
                renew_until: date_nextyear_string
            })



        }).catch(error => {
            console.log('ini error ' + error)
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', margin: 20, fontSize: 25, alignSelf: 'center' }}>Renewal</Text>
                </View>
                <View style={styles.body}>
                    <View style={styles.cont_curent_balance}>
                        <View style={styles.current_balance}>
                            <Text style={{ textAlign: 'center' }}>Current Balance</Text>
                        </View>
                        <View style={styles.value_current_balance}>
                            <Text style={{ textAlign: 'center' }}>{this.state.current_balance}</Text>
                        </View>
                    </View>
                    <View style={styles.cont_biaya_renewal}>
                        <View style={styles.biaya_renewal}>
                            <Text style={{ textAlign: 'center' }}>Biaya Renewal</Text>
                        </View>
                        <View style={styles.value_biaya_renewal}>
                            <Text style={{ textAlign: 'center' }}>{this.state.biaya_renewal}</Text>
                        </View>
                    </View>
                    <View style={styles.cont_expired}>
                        <View style={styles.expired}>
                            <Text style={{ textAlign: 'center' }}>Expired</Text>
                        </View>
                        <View style={styles.value_expired}>
                            <Text style={{ textAlign: 'center' }}>{this.state.expired}</Text>
                        </View>
                    </View>

                    <View style={styles.cont_renew_until}>
                        <View style={styles.renew_until}>
                            <Text style={{ textAlign: 'center' }}>Renew Until</Text>
                        </View>
                        <View style={styles.value_renew_until}>
                            <Text style={{ textAlign: 'center' }}>{this.state.renew_until}</Text>
                        </View>
                    </View>
                    <View style={styles.btn_renewal}>
                        <Button title="Renew" onPress={() => this._renewal()}></Button>
                    </View>
                </View>
            </View>
        )
    }
}


const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {
        flex: 1,
    },
    body: {
        flex: 4,
    },
    cont_curent_balance: {
        flexDirection: 'row',
        height: 50,
    },
    cont_biaya_renewal: {
        flexDirection: 'row',
        height: 50,
    },
    cont_expired: {
        flexDirection: 'row',
        height: 50,
    },
    cont_renew_until: {
        flexDirection: 'row',
        height: 50,

    },
    current_balance: {
        flex: 1,
        margin: 5,
        justifyContent: 'center'
    },

    biaya_renewal: {
        flex: 1,
        margin: 5,
        justifyContent: 'center'

    },

    expired: {
        flex: 1,
        margin: 5,
        justifyContent: 'center'

    },

    renew_until: {
        flex: 1,
        margin: 5,
        justifyContent: 'center'

    },

    value_current_balance: {
        flex: 1,
        margin: 5,
        justifyContent: 'center',
    },

    value_biaya_renewal: {
        flex: 1,
        margin: 5,
        justifyContent: 'center',
    },

    value_expired: {
        flex: 1,
        margin: 5,
        justifyContent: 'center',
    },

    value_renew_until: {
        flex: 1,
        margin: 5,
        justifyContent: 'center',
    },
    btn_renewal: {
        marginRight: 30,
        marginLeft: 30,
        marginTop: 10,
    }
})

const mapStateToProps = (state) => {
    return {
        session_id: state.session_id,
    }
}
export default connect(mapStateToProps)(Renewal);
