import React from 'react';
import { View, Text, TextInput, StyleSheet, ScrollView, Alert, TouchableOpacity } from 'react-native';
import { Card } from 'react-native-shadow-cards'
import { connect } from 'react-redux';
import Axios from 'axios';

class TransactionHistory extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            history_list: []
        }
    }

    componentDidMount() {
        this.getTransactionHistory()
    }

    getTransactionHistory() {
        let params = {
            session_id: this.props.session_id
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/transaction/history', params).then(res => {
            let data = res.data.transactions
            console.log('ini datanya loh : ' + JSON.stringify(data))
            this.setState({
                history_list: data
            })
           
        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.msg);
        })
    }

    render() {
        return (
            <View style={styles.container}>
                <ScrollView style={styles.body}>
                    {
                        this.state.history_list.map((item) => (

                            item.transactions.map((i, k) => (
                                <TouchableOpacity key={k} onPress={() => this.props.navigation.navigate('Transaction Detail', {idTrans:i.id})}>
                                    <Card style={{ padding: 10, margin: 10, alignContent: 'center' }}>
                                        <Text>TANGGAL : {i.trans_date}</Text>
                                        <Text>TOTAL : {i.trans_total}</Text>
                                        <Text>TRANSAKSI : {i.trans_type_display}</Text>
                                    </Card>
                                </TouchableOpacity>
                            ))
                        ))
                    }
                </ScrollView>
            </View>
        )
    }
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',
    },
    header: {

        flex: 0.2,
    },

    body: {
        flex: 3,
        margin: 5,
    },
    list_detail_order: {
        flex: 1,
        margin: 20,
        borderWidth: 1,
    }
})

const mapStateToProps = (state) => {
    return {

        session_id: state.session_id,

    }
}

export default connect(mapStateToProps)(TransactionHistory);