import Axios from 'axios';
import React from 'react';
import { Alert, StyleSheet, Text, TextInput, TouchableOpacity, View } from 'react-native';
import { connect } from 'react-redux';
import i18n from 'i18n-js';

class PaymentCode extends React.Component {
    constructor(props) {
        super(props);
        this.handleBackButtonClick = this.handleBackButtonClick.bind(this)
        this.state = {
            current_balance: '',
            kaspro_point: '',
            redeem_balance: '',
            redeem_point: '',
            caretHidden:true,
        }
    }


    componentDidMount() {
        "INI YAAAAAAAAAAAAAAAAASSSS"
        this._getProfile()
    }

    _getProfile() {
        let params = {
            session_id: this.props.session_id
        }

        Axios.post(this.props.BASE_URL + 'crm/v2/member/get_profile', params).then(res => {
            // console.log('INI RESPONNYA : ' + JSON.stringify(res.data))
            const dataCard = res.data

            let balance = dataCard.kaspro_balance
            let point = dataCard.kaspro_point


            this.setState({
                current_balance: balance,
                kaspro_point: point,
            })


        }).catch(error => {
            // console.log('ini error ' + error)
        })
    }

    redeem() {

        if (this.state.redeem_balance > this.state.current_balance) {
            Alert.alert('', i18n.t('notEnoughBalance'))
        } else if (this.state.redeem_point > this.state.kaspro_point) {
            Alert.alert('', i18n.t('notEnoughPoint'))
        } else {
            let params = {
                session_id: this.props.session_id,
                pin: 123456,
                balance: this.state.current_balance,
                point: this.state.kaspro_point

            }

            Axios.post(this.props.BASE_URL + 'crm/v2/point/redeem', params).then(res => {
                Alert.alert('', i18n.t('successRedeem'))
            }).catch(error => {
                let response = error.response.data;
                Alert.alert(response.msg);
            })
        }
    }



    render() {
        return (
            <View style={styles.container}>
                <View style={{ flex: 3 }}>
                    <View style={{ flex: 1, marginRight: 30, marginLeft: 30, top: 50 }}>
                        <View style={{ height: 150, justifyContent: 'center', alignContent: 'center' }}>
                            <View style={{ borderColor: '#838383', height: 1, borderWidth: 1, marginLeft: 20, marginRight: 20 }}></View>
                        </View>
                        <Text style={{ fontFamily: 'Gotham-Black', color: '#CFB368', fontSize: 20, textAlign: 'center', margin: 3 }}>{i18n.t('currentbalance')}</Text>
                        <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10, borderRadius: 10, borderColor: 'grey', fontFamily: 'Gotham-Black', textAlign: 'center', color: 'grey', fontWeight: 'bold', fontSize: 20 }}
                            onChangeText={(redeem_point) => this.setState({ redeem_point })}
                            autoCapitalize="none"
                            caretHidden={this.state.caretHidden}
                            onFocus={() => this.setState({caretHidden: false})}
                            keyboardType='numeric'>IDR.{this.state.kaspro_point}</TextInput>
                        <TouchableOpacity style={{ height: 100 }} onPress={() => this.redeem()}>
                            <View style={{ backgroundColor: '#CFB368', height: 40, top: 20, borderRadius: 10, marginRight: 50, marginLeft: 50 }}>
                                <Text style={{ alignSelf: 'center', top: 10, color: 'white', fontFamily: 'Gotham-Black', fontSize: 20 }}>REDEEM</Text>
                            </View>
                        </TouchableOpacity>
                    </View>
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    form: {
        flex: 3,
        top: 40,
        margin: 10,
        marginTop: 0,
    },

    field_email: {
        flexDirection: 'row'
    },

    button: {
        height: 40,
        margin: 10,

    },
    logo: {
        alignSelf: 'flex-start',
        marginTop: 50,
        width: 290,
        height: 290,
        bottom: 145,

    },
    v_logo: {
        flex: 2,
        flexDirection: 'column-reverse',
        alignContent: 'flex-start',
    }

})

const mapStateToProps = (state) => {
    return {
        session_id: state.session_id,
        language: state.language,
        pageEmailConfirmation: state.pageEmailConfirmation,
        BASE_URL: state.BASE_URL,
    }
}

export default connect(mapStateToProps)(PaymentCode);
