import * as Location from 'expo-location';
import * as Permissions from 'expo-permissions';
import * as Device from 'expo-device';


 export default  _getPermissions = async () => {
    let { status } = await Permissions.askAsync(Permissions.LOCATION);
    if (status !== 'granted') {
      Alert.alert('Akses tidak dizinkan!')
    } else if (Platform.OS === 'android' && !Device.isDevice) {

      Alert.alert('Silahkan anda coba di real Device')
    } else {
      this._getCurrentPosisition()
    }
  }

   _getCurrentPosisition = async () => {
    this.setState({
      spinner: true,
    })
    let location = await Location.getCurrentPositionAsync({
      accuracy: Location.Accuracy.Highest
    })

    let latitude = location.coords.latitude;
    let longitude = location.coords.longitude;

    this.setState({
      my_lat: latitude,
      my_long: longitude
    })

    console.log("MY LAT : " + this.state.my_lat)
    console.log("MY LONG : " + this.state.my_long)
    this.getOutlet()
  }

 function getOutlet() {
    this.setState({
      spinner: true,
    })
    let params = {
      session_id: this.props.session_id
    }

    Axios.post("https://excelsocrm.ravintoladev.com/crm/v2/outlet/get_list", params).then(res => {
      let dataOutlets = res.data.outlets;
      for (let i = 0; i < dataOutlets.length; i++) {
        dataOutlets[i]['distance'] = this.distance(dataOutlets[i]['lat'], dataOutlets[i]['long']);
        let address = dataOutlets[i]['address'];
        if (dataOutlets[i]['city'] !== '') {
          if (address !== '') {
            address = address + ', ' + dataOutlets[i]['city'];
          } else {
            address = dataOutlets[i]['city'];
          }
        }
        if (dataOutlets[i]['province']) {
          if (address !== '') {
            address = address + ', ' + dataOutlets[i]['province'];
          } else {
            address = dataOutlets[i]['province'];
          }
        }
        if (dataOutlets[i]['postal_code']) {
          if (address !== '') {
            address = address + ' ' + dataOutlets[i]['postal_code'];
          } else {
            address = dataOutlets[i]['postal_code'];
          }
        }
        dataOutlets[i]['full_address'] = address;
      }
      this.setState({
        dataOutlets: dataOutlets,
        data_before_search: dataOutlets,

      })
      this.setState({
        spinner: false,
      })

    }).catch(error => {
      let response = error.response.data;
      Alert.alert(response.msg);
      this.setState({
        spinner: false,
      })
    })
  }

 function toRad(value) {
    return value * Math.PI / 180;
  }

 function distance(locationLat, locationLong) {

    let R = 6371;
    let dLat = this.toRad(locationLat - this.state.my_lat);  // Javascript functions in radians
    let dLon = this.toRad(locationLong - this.state.my_long);
    let a = Math.sin(dLat / 2) * Math.sin(dLat / 2) + Math.cos(this.toRad(this.state.my_lat)) * Math.cos(this.toRad(locationLat)) * Math.sin(dLon / 2) * Math.sin(dLon / 2);
    let c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
    let d = R * c;
    return Math.round(d * 10) / 10;

  }
