import React from 'react';
import { View, Text, TextInput, StyleSheet, Button, Alert } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import ActionType from '../redux/globalActionType';
import Spinner from 'react-native-loading-spinner-overlay';

class CardActivation extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            session_id: "",
            mobile_phone: "",
            card_number: "",
            token: "",
            timer: 80,
            onclick: false,
            spinner: false,
        }
    }

    componentDidUpdate(prevProps) {
        if (this.state.timer === 0) {
            clearInterval(this.interval);
        }
    }

    componentWillUnmount() {
        clearInterval(this.interval);
    }

    handleToken() {
        let params = {
            session_id: this.props.session_id,
            mobile_phone: this.state.mobile_phone
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/get_token', params).then(res => {
            this.setState({
                onclick: true
            })
            Alert.alert('Kami telah mengirimkan sms otp ke nomor anda!');
            this.interval = setInterval(
                () => this.setState((prevState) => ({ timer: prevState.timer - 1 })),
                1000
            );
            this.setState({
                onclick: true
            })
        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.msg);
        })
    }

    ResendToken() {
        this.setState({
            spinner: true,
        })
        let params = {
            session_id: this.props.session_id,
            mobile_phone: this.state.mobile_phone
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/resend_token', params).then(res => {
            this.setState({
                spinner: false,
            })

            Alert.alert('Kami telah kembali mengirimkan sms otp ke nomor anda!');
            this.setState({
                timer: 80
            })
            this.interval = setInterval(
                () => this.setState((prevState) => ({ timer: prevState.timer - 1 })),
                1000
            );
        }).catch(error => {
            this.setState({
                spinner: false,
            })
            let response = error.response.data;
            Alert.alert(response.msg);
        })
    }

    handleActivate() {
        this.setState({
            spinner: true,
        })
        let params = {
            session_id: this.props.session_id,
            mobile_phone: this.state.mobile_phone,
            card_number: this.state.card_number,
            token: this.state.token
        }
        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/card/activate', params).then(res => {
            Alert.alert("Kartu anda berhasil di aktifkan");
            this.setState({
                spinner: false,
            })
            this.props.navigation.reset({
                index: 0,
                routes: [{ name: 'Home' }],
            })

        }).catch(error => {
            this.setState({
                spinner: false,
            })
            let response = error.response.data;
            Alert.alert(response.msg);

        })
    }

    render() {
        return (
            <View style={styles.container}>
                <Spinner
                    visible={this.state.spinner}
                    textContent={'Loading...'}
                    textStyle={styles.spinnerTextStyle}
                />
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', marginTop: 10, fontSize: 25 }}>Activate Card</Text>
                </View>
                <View style={styles.form}>
                    <View style={styles.field_phone}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>Phone</Text>
                        </View>
                        <View style={{ flex: 1, margin: 10 }}>
                            <TextInput
                                style={{ height: 40, borderColor: 'gray', borderWidth: 1, padding: 5 }}
                                onChangeText={mobile_phone => this.setState({ mobile_phone })}
                                value={this.state.mobile_phone}
                            />
                        </View>
                        <View style={styles.button}>
                            <Button title="Token" onPress={() => this.handleToken()}></Button>
                        </View>
                    </View>
                    {
                        this.state.onclick === true ? (<Text style={{ textAlign: 'center' }}> 0:{this.state.timer} </Text>) : (
                            null
                        )
                    }
                    {
                        this.state.timer === 0 ? (
                            <View style={{ width: 90, height: 40, alignSelf: 'center', margin: 20, top: 0 }}>

                                <Button title="Resend Token" onPress={() => this.ResendToken()}></Button>
                            </View>
                        ) : (null)}

                    <View style={styles.field_email}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>Card number</Text>
                        </View>
                        <View style={{ flex: 1, margin: 10 }}>
                            <TextInput
                                style={{ height: 40, borderColor: 'gray', borderWidth: 1, padding: 5 }}
                                onChangeText={card_number => this.setState({ card_number })}
                                value={this.state.card_number}
                            />
                        </View>
                    </View>
                    <View style={styles.field_email}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>Token</Text>
                        </View>
                        <View style={{ flex: 1, margin: 10 }}>
                            <TextInput
                                style={{ height: 40, borderColor: 'gray', borderWidth: 1, padding: 5 }}
                                onChangeText={token => this.setState({ token })}
                                value={this.state.token}
                            />
                        </View>
                    </View>
                    <View style={styles.button}>
                        <Button title="Activate" onPress={() => this.handleActivate()}></Button>
                    </View>
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    form: {
        flex: 3,
        margin: 10,
        marginTop: 0,
    },

    field_email: {
        flexDirection: 'row'
    },

    field_phone: {
        flexDirection: 'row'
    },


    button: {
        height: 50,
        margin: 10,

    }
})

const mapStateToProps = (state) => {
    return {
        session_id: state.session_id,
        set_card: state.set_card
    }
}


export default connect(mapStateToProps)(CardActivation);