import React from 'react';
import { View, Text, TextInput, StyleSheet, Button,Alert } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import {  BASE_URL_NEW_PASSWORD } from '../model/Base_Model'
import Spinner from 'react-native-loading-spinner-overlay';

class NewPassword extends React.Component {
    constructor(props) {
        super(props)
        this.state = {
            confirmation_number: '',
            email: this.props.email,
            password: this.props.password,
            password_confirmation: '',
            spinner: false,
        }
    }

    componentDidMount(){
        console.log(this.props)
    }

    validation(){
        this.setState({
            spinner: true,
        })
        if (this.state.password !== this.state.password_confirmation) {
            this.setState({
                spinner: false,
            })
            Alert.alert(
                '',
                'Password harus sama!'
                ,
            )
            
        }else{
            this.handleResetPassword();
        }
    }

    handleResetPassword() {
        this.setState({
            spinner: true,
        })
        let params = {
            'confirmation_number': this.state.confirmation_number,
            'email': this.state.email,
            'password': this.state.password,
            'password_confirmation': this.state.password_confirmation
        }
        console.log(params);
        Axios.post(BASE_URL_NEW_PASSWORD,params).then(res => {
            this.setState({
                spinner: false,
            })
                this.props.navigation.navigate('Login')
        }).catch(error => {
            this.setState({
                spinner: false,
            })
            let response = error.response.data;
            Alert.alert(response.msg);
        })
    }

    render() {
        return (
            <View style={styles.container}>
                 <Spinner
                    visible={this.state.spinner}
                    textContent={'Loading...'}
                    textStyle={styles.spinnerTextStyle}
                />
                {/* <Text>{this.state.email}</Text> */}
                <View style={styles.header}>
                    <Text style={{ textAlign: 'center', marginTop: 10, fontSize: 25 }}>New Password</Text>
                </View>
                <View style={styles.form}>
                    <View style={styles.field_token}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>Token</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                onChangeText={(confirmation_number) => this.setState({ confirmation_number })}
                                value={this.state.confirmation_number} />
                        </View>
                    </View>
                    <View style={styles.field_new_password}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>New Password</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                onChangeText={(password) => this.setState({ password })}
                                value={this.state.password}  
                                secureTextEntry={true}/>
                        </View>
                    </View>
                    <View style={styles.field_repeat_password}>
                        <View style={{ width: 55, justifyContent: 'center' }}>
                            <Text>Repeat Password</Text>
                        </View>
                        <View style={{ flex: 1 }}>
                            <TextInput style={{ height: 40, borderWidth: 1, padding: 5, margin: 10 }}
                                onChangeText={(password_confirmation) => this.setState({ password_confirmation })}
                                value={this.state.password_confirmation} 
                                secureTextEntry={true}/>
                        </View>
                    </View>
                    <View style={styles.button}>
                        <Button title="Submit" onPress={() => this.validation()}></Button>
                    </View>
                </View>
            </View>
        )
    }
}

const styles = StyleSheet.create({

    container: {
        flex: 1,
        backgroundColor: '#ffff'
    },

    header: {
        flex: 0.5,
        margin: 10,
    },

    form: {
        flex: 3,
        margin: 10,
        marginTop: 0,
    },

    field_token: {
        flexDirection: 'row'
    },

    field_new_password: {
        flexDirection: 'row'
    },

    field_repeat_password: {
        flexDirection: 'row'
    },

    button: {
        height: 50,
        margin: 10,

    }

})

const mapStateToProps = (state) => { console.log(JSON.stringify(state))
    return {
        email: state.email
    }
}

export default connect(mapStateToProps)(NewPassword);