import React, { PureComponent } from 'react';
import { View, Text, button, StyleSheet, Button, Alert } from 'react-native';
import { connect } from 'react-redux';
import Axios from 'axios';
import ActionType from '../redux/globalActionType';
import i18n from 'i18n-js';
import { StackActions } from '@react-navigation/native';

class ProfilePage extends PureComponent {
    constructor(props) {
        super(props)
        this.state = {
            full_name: '',
            dob_day: '',
            dob_month: '',
            dob_year: '',
            gender: '',
            email: '',
        }
    }

    componentDidMount() {
        this.getProfile();
    }


    getProfile() {
        let params = {
            session_id: this.props.session_id
        }

        Axios.post('https://excelsocrm.ravintoladev.com/crm/v2/member/get_profile', params).then(res => {
            let data = res.data

            this.setState({
                full_name: data.name,
                email: data.email,
                dob_day: data.dob_day,
                dob_month: data.dob_month,
                dob_year: data.dob_year,
                gender: data.gender_display,

            })
        }).catch(error => {
            let response = error.response.data;
            Alert.alert(response.msg);
        })
    }


    onChangeProfil = data => {
        console.log('DATA FROM CHANGE PROFILE  ' + data);
        this.getProfile()
    }

    handleChangeProfil() {
        this.props.navigation.navigate('Change Profil', { 'data': 'sample', onChangeProfil: this.onChangeProfil })
    }

    // logout() {
    //     const navigation = this.props.navigation
    //     let sessionProps = {
    //         session_id: ''
    //     }
    //     this.props.setSessionid(sessionProps);
    //     navigation.dispatch(StackActions.replace('Login'))
    // }

    logout() {
        const navigation = this.props.navigation
        let sessionProps = {
            session_id: ''
        }
        this.props.setSessionid(sessionProps);
        navigation.reset({
            index: 0,
            routes: [
              {
                name: 'Login',
                params: { someParam: 'Param1' },
              },
            ],
          })
    }

    render() {
        return (
            <View style={styles.container}>
                <Text style={{ textAlign: "center", margin: 50, fontWeight: 'bold', fontSize: 25 }}> Profil </Text>
                <View style={{ margin: 10, flex: 1, }}>
                    <View style={{ height: 50, flexDirection: 'row' }}>

                        <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>Name : </Text>
                        <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>{this.state.full_name} </Text>
                    </View>
                    <View style={{ height: 50, flexDirection: 'row' }}>
                        <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>Date of Birth </Text>
                        <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>{this.state.dob_day} / {this.state.dob_month} / {this.state.dob_year} </Text>
                    </View>
                    <View style={{ height: 50, flexDirection: 'row' }}>
                        <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>Gender :</Text>
                        <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>{this.state.gender} </Text>
                    </View>
                    <View style={{ height: 50, flexDirection: 'row' }}>
                        <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>Email :</Text>
                        <Text style={{ fontSize: 20, margin: 5, flex: 2 }}>{this.state.email} </Text>
                    </View>
                </View>
                <View style={{ flexDirection: 'row', top: 20, margin: 5, }}>
                    <View style={{ flex: 1, margin: 5 }}>
                        <Button title="Edit" onPress={() => this.handleChangeProfil()}></Button>
                    </View>
                    <View style={{ flex: 1, margin: 5 }}>
                        <Button title="Change Password" onPress={() => this.props.navigation.navigate('Change password')}></Button>
                    </View>
                </View>
                <View style={{ flex: 1, flexDirection: 'row', top: 20, margin: 5 }}>
                    <View style={{ flex: 1, margin: 5 }}>
                        <Button title="Language" onPress={() => this.props.navigation.navigate('Change language')}></Button>
                    </View>
                    <View style={{ flex: 1, margin: 5 }}>
                        <Button title="Logout" onPress={() => this.logout()}></Button>
                    </View>
                </View>
            </View>
        )
    }
}


const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: 'white',

    }
})

const mapDispatchToProps = (dispacth) => {
    return {
        setSessionid: (sessionProps) => dispacth({
            type: ActionType.SET_LOGOUT,
            data: {
                session_id: sessionProps.session_id
            }
        }),
    }
}

const mapStateToProps = (state) => {
    console.log('PROFIL PAGE' + JSON.stringify(state))
    return {
        session_id: state.session_id,
        language: state.language,
        full_name: state.full_name,
        gender_display: state.gender_display,
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(ProfilePage);
